#ifndef		__T_CONV_RGB2YCRCB_H_INCLUDE_
#define		__T_CONV_RGB2YCRCB_H_INCLUDE_

#include "../contena/t_image_rgb.h"
#include "../contena/t_image_ycrcb.h"
#include "../common/t_com_operator.h"
#include "../common/t_com_allconv.h"

namespace t_image_engine{

// ycrcbvZ
template <class _TI, class _TO> 
class t_conv_c_rgb2ycrcb
{
public:
	// PxvZ
	inline static _TO calc_y(_TI r, _TI g, _TI b)
		{return static_cast<_TO>(0.29900 * r + 0.58700 * g + 0.11400 * b);}
	// CRvZ
	inline static _TO calc_cr(_TI r, _TI g, _TI b)
		{return static_cast<_TO>(0.50000 * r - 0.41869 * g - 0.08131 * b);}
	// CBvZ
	inline static _TO calc_cb(_TI r, _TI g, _TI b)
		{return static_cast<_TO>(-0.16874 * r - 0.33126 * g + 0.50000 *b);}
};

// rgbvZ
template <class _TI, class _TO> 
class t_conv_c_ycrcb2rgb
{
public:
	// R
	inline static _TO calc_r(_TI y, _TI cr, _TI cb)
		{return static_cast<_TO>(y + 1.40200 * cr);}
	// G
	inline static _TO calc_g(_TI y, _TI cr, _TI cb)
		{return static_cast<_TO>(y - 0.71414 * cr -0.34414 * cb);}
	// B
	inline static _TO calc_b(_TI y, _TI cr, _TI cb)
		{return static_cast<_TO>(y + 1.77200 * cb);}
};

// 摜ϊ(RGB->YCRCB)
class t_conv_rgb2ycrcb{
public:
	///! RGBYCrCbɕϊ
	inline static bool rgb2ycrcb(const t_image_rgb& src, t_image_ycrcb* dst)
	{
		return t_com_allconv<t_image_rgb, t_image_ycrcb, t_conv_f_rgb2ycrcb>::func(src, dst); 
	}

	///! YCrCbRGBɕϊ
	inline static bool ycrcb2rgb(const t_image_ycrcb& src, t_image_rgb* dst)
	{
		return t_com_allconv<t_image_ycrcb, t_image_rgb, t_conv_f_ycrcb2rgb>::func(src, dst);
	}


protected:
	//! rgb -> ycrcb
	struct t_conv_f_rgb2ycrcb{
		inline static void f(const t_type_rgb* src, t_type_ycrcb* dst)
		{
			const float r = (float)src->r_;
			const float g = (float)src->g_;
			const float b = (float)src->b_;
			dst->y_ = i2uc(t_conv_c_rgb2ycrcb<float, int>::calc_y(r,g,b));
			dst->cr_= i2uc(t_conv_c_rgb2ycrcb<float, int>::calc_cr(r,g,b)+128);
			dst->cb_= i2uc(t_conv_c_rgb2ycrcb<float, int>::calc_cb(r,g,b)+128);
		}
	};

	//! ycrcb -> rgb
	struct t_conv_f_ycrcb2rgb{
		inline static void f(const t_type_ycrcb* src, t_type_rgb* dst)
		{
			const float y = (float)src->y_;
			const float cr = (float)(src->cr_-128);
			const float cb = (float)(src->cb_-128);
			dst->r_ = i2uc(t_conv_c_ycrcb2rgb<float, int>::calc_r(y, cr, cb));
			dst->g_ = i2uc(t_conv_c_ycrcb2rgb<float, int>::calc_g(y, cr, cb));
			dst->b_ = i2uc(t_conv_c_ycrcb2rgb<float, int>::calc_b(y, cr, cb));
		}
	};
};

}

#endif