#ifndef		__T_CORR_LUMINANCE_H_INCLUDE_
#define		__T_CORR_LUMINANCE_H_INCLUDE_

#include "../common/t_com_allconv.h"
#include "../converter/t_conv_rgb2ycrcb.h"

namespace t_image_engine{

// Px␳NX
class t_corr_luminance{
public:
	inline static bool correct(const t_image_rgb& src, t_image_rgb* dst, double coef)
	{
		return t_com_allconv_a1<t_image_rgb, t_image_rgb, t_corr_f_luminance_ycrcb, double>::func(src, dst, coef);
	}

protected:
	//! rgb -> rgb(Px␳ ycrcboR)
	struct t_corr_f_luminance_ycrcb{
		inline static void f(const t_type_rgb* src, t_type_rgb* dst, const double coef)
		{
			const unsigned char r = src->r_;
			const unsigned char g = src->g_;
			const unsigned char b = src->b_;
			const double y =  t_conv_c_rgb2ycrcb<unsigned char, double>::calc_y(r,g,b) * coef;
			const double cr = t_conv_c_rgb2ycrcb<unsigned char, double>::calc_cr(r,g,b);
			const double cb = t_conv_c_rgb2ycrcb<unsigned char, double>::calc_cb(r,g,b);
			dst->r_ = d2uc(t_conv_c_ycrcb2rgb<double, double>::calc_r(y,cr,cb));
			dst->g_ = d2uc(t_conv_c_ycrcb2rgb<double, double>::calc_g(y,cr,cb));
			dst->b_ = d2uc(t_conv_c_ycrcb2rgb<double, double>::calc_b(y,cr,cb));
		}
	};
};

};
#endif