#ifndef		__T_LABEL_H_INCLUDE_
#define		__T_LABEL_H_INCLUDE_

#include "t_rect.h"
#include <vector>
#include <limits>

namespace t_image_engine{

// xf[^
template <typename _TYPE>
class t_label_template
{
public:

	typedef t_rect_template<_TYPE>	_T_RECT;
	typedef t_line_template<_TYPE>	_T_LINE;		// Cf[^
	typedef std::vector< _T_LINE>	_T_LINE_VECTOR;	// Cf[^z

	// Cz̃Zbg
	inline void set_line_data(
		typename _T_LINE_VECTOR::iterator	begin,
		typename _T_LINE_VECTOR::iterator	end
	)
	{
		// Cf[^̃Zbg
		linedata_.clear();
		linedata_.insert(linedata_.begin(), begin, end);
		rect_ = make_outline(linedata_);
	}

	// x̍
	inline bool add_label_data(const t_label_template<_TYPE> & src)
	{	
		// Cf[^ǉ
		if(src.linedata_.size() == 0){
			return false;
		}
		const int myno = get_label_no();
		for(_T_LINE_VECTOR::const_iterator it = src.linedata_.begin(); it < src.linedata_.end(); it++){
			this->linedata_.push_back(t_line(it->sx_,it->ex_,it->y_, myno));
		}
		rect_+=*(src.get_rect_pt());
		return true;
	}

	// `̎擾
	inline const _T_RECT* get_rect_pt() const
	{
		return &rect_;
	}

	// xԍ̎擾
	inline unsigned int get_label_no() const
	{
		return linedata_.begin()->no_;

	}

	// Cf[^
	_T_LINE_VECTOR linedata_;

protected:
	// Oڋ`
	_T_RECT rect_;


protected:
	// Cz̊Oڋ`擾
	t_rect make_outline(const _T_LINE_VECTOR& linedata) const
	{
		_T_RECT rc;
		int sx = std::numeric_limits<_TYPE>::max();
		int ex = std::numeric_limits<_TYPE>::min();
		for(_T_LINE_VECTOR::const_iterator it = linedata.begin(); it != linedata.end(); it++){
			if(it->sx_ < sx){
				sx = it->sx_ ;
			}
			if(it->ex_ > ex){
				ex = it->ex_ ;
			}
		}
		rc.left_	= sx;
		rc.right_	= ex;
		rc.top_		= linedata_.begin()->y_;
		rc.bottom_	= (linedata_.end()-1)->y_;
		return rc;
	}

	
};

typedef t_label_template<int> t_label;

};

#endif