#ifndef		__T_DRAW_GRADATION_H_INCLUDE_
#define		__T_DRAW_GRADATION_H_INCLUDE_

#include "../type/t_type_define.h"
#include "../contena/t_image_base.h"
#include "../common/t_com_operator.h"

namespace t_image_engine{

// Of[V͗l̕`
template < typename _CLASS >
class t_draw_gradation
{
public:
	typename typedef _CLASS::imagetype_ _TYPE;
	inline static bool draw(_CLASS* dst, _TYPE c1, _TYPE c2)
	{
		if(!dst){
			return false;
		}
		_TYPE* table = colortable<_TYPE>::make(dst->height(), c1, c2);
		_TYPE* pt = dst->pointer();
		for(int y = 0; y < dst->height(); y++){
			_TYPE v = table[y];
			for(int x = 0; x < dst->width(); x++, pt++){
				*pt = v; 
			}
		}
		delete [] table;
		return true;
	}

protected:
	// e[u쐬ev[g
	template <typename _COLOR> 
	struct colortable
	{};

	template <> 
	struct colortable < t_type_rgb >
	{
		static t_type_rgb* make(int width, const t_type_rgb& c1, const t_type_rgb& c2)
		{
			t_type_rgb *taddr;
			t_type_rgb *const table = taddr = new t_type_rgb [width];
			t_type_frgb add;
			t_type_frgb base;
			float wf = static_cast<float>(width);
			add.r_ = static_cast<float>(c2.r_ - c1.r_) / wf;
			add.g_ = static_cast<float>(c2.g_ - c1.g_) / wf;
			add.b_ = static_cast<float>(c2.b_ - c1.b_) / wf;
			base = c1;
			for(int i = 0; i < width; i++, taddr++){
				taddr->r_ = f2uc(base.r_);
				taddr->g_ = f2uc(base.g_);
				taddr->b_ = f2uc(base.b_);
				base += add;
			}
			return table;
		}
	};
};

}

#endif