#ifndef		__T_FILT_BASE_H_INCLUDE_
#define		__T_FILT_BASE_H_INCLUDE_

namespace t_image_engine{

//! tB^p[^
class t_filt_param_interface{
protected:
	int	type_;	// g̃tB^^Cv

public:
	t_filt_param_interface()
	{
		type_ = 0;
	}
	virtual ~t_filt_param_interface()	
	{
	}

	// g̃^Cv擾
	inline int type() const 
	{
		return type_;
	}

};


//! tB^C^[tFCX
class t_filt_interface{
public:
	virtual t_filt_param_interface* make_param_if()		= 0;
	virtual bool run(t_filt_param_interface* param)		= 0;
};


//! tB^(LXgt)
template <class _T >class t_filt_base : public t_filt_interface{
public:
	// p[^(_T^Ő)
	inline virtual _T* make_param()
	{
		return param_downcast(make_param_if());
	}

	// p[^(t_filt_interface^Ő)
	inline virtual t_filt_param_interface* make_param_if()
	{
		return new _T;
	}

	// p[^_ELXg
	inline virtual _T* param_downcast(t_filt_param_interface* param)
	{
		return reinterpret_cast<_T*>(param);
	}

	// p[^AbvLXg
	inline virtual t_filt_param_interface* param_upcast(_T* param)
	{
		return reinterpret_cast<t_filt_param_interface*>(param);
	}
};

}

#endif