#ifndef		__T_FILT_DIFF_H_INCLUDE_
#define		__T_FILT_DIFF_H_INCLUDE_

#include "../type/t_type_rgb.h"
#include "../type/t_type_gray.h"
#include "../contena/t_image_base.h"
#include "../runner/t_run_base.h"

#include "t_filt_base.h"
#include "template/t_filt_template_diff.h"

namespace t_image_engine{

//! tB^^Cv
typedef enum{
	ftype_sobel,		// [-1, -2, -1] [ 0,  0,  0] [ 1,  2,  1]
	ftype_prewitt,		// [ 1,  1,  1] [ 0,  0,  0] [ 1,  1,  1]
	ftype_laplacian		// [ 0, -1,  0] [-1,  4, -1] [ 0, -1,  0]
}diff_filter_type;

//! tB^
typedef enum{
	dir_left			= 0,
	dir_topleft,
	dir_top,
	dir_topright,
	dir_right,
	dir_bottomright,
	dir_bottom,
	dir_bottomleft,
	
	dir_dir4			= 0,
	dir_dir8
}filter_direction;

//! tB^p[^
class t_filt_param_diff : public t_filt_param_interface
{
public:
	// p[^
	t_image_interface	*src_;			//<! Ώۉ摜Q
	t_image_interface	*dst_;			//<! o͑Ώۉ摜Q(NULLȂsrc_ɏo)
	const t_run_base*	runner_;		//<! ̈
	diff_filter_type	filter_type_;	//<! tB^^Cv
	filter_direction	filter_dir_;	//<! tB^

public:
	//! RXgN^
	t_filt_param_diff()
	{
		type_ = 2;
		src_ = dst_ = NULL;
	}

	//! fXgN^
	~t_filt_param_diff()
	{
	}

	//! p[^ݒ
	bool set_param(	
		t_image_interface* src, 
		t_image_interface* dst = NULL,
		const t_run_base* runner = NULL,
		t_image_engine::diff_filter_type filter_type	= t_image_engine::ftype_sobel, 
		t_image_engine::filter_direction filter_dir		= t_image_engine::dir_left
	)
	{
		dst_ = dst;
		src_ = src;
		filter_type_ = filter_type;
		filter_dir_  = filter_dir;
		runner_ = runner;
		return true;
	}
};

//! tB^
class t_filt_diff : public t_filt_base <t_filt_param_diff>
{
public:
	// tB^s
	virtual bool run(t_filt_param_interface* param)
	{
		if(!param || param->type() != 2)
			return false;
		t_filt_param_diff* p = param_downcast(param);
		if(p->dst_ && !p->src_->is_same(p->dst_))
			return false;

		switch(p->src_->tag()){
			case rgb_24bit:	 return t_filt_diff_main< t_image_rgb >::func(p);
			case rgba_32bit: return t_filt_diff_main< t_image_rgba >::func(p);
			case gray_8bit:	 return t_filt_diff_main< t_image_gray >::func(p);
			default:return false;
		}
		return true;
	}
};

}

#endif