#ifndef		__T_FILT_NOISE_H_INCLUDE_
#define		__T_FILT_NOISE_H_INCLUDE_

#include "../type/t_type_rgb.h"
#include "../type/t_type_gray.h"
#include "../contena/t_image_base.h"
#include "../runner/t_run_base.h"

#include "t_filt_base.h"
#include "template/t_filt_template_noise.h"

namespace t_image_engine{

//! mCYtB^p[^
class t_filt_param_noise : public t_filt_param_interface
{
public:
	// p[^
	t_image_interface	*src_;			//<! Ώۉ摜Q
	t_image_interface	*dst_;			//<! o͑Ώۉ摜Q(NULLȂsrc_ɏo)
	const t_run_base*	runner_;		//<! ̈
	float				strength_;		//<! mCYx
	float				incidence_;		//<! mCY 0.0-100.0

public:
	t_filt_param_noise()
	{
		type_ = 6;
		src_ = dst_ = NULL;
		strength_ = 10.0f;
		incidence_ = 10.0f;
		runner_ = NULL;
	}
	~t_filt_param_noise()
	{
	}

	bool set_param(
		t_image_interface* src, 
		t_image_interface* dst = NULL,
		const t_run_base* runner = NULL,
		float strength  = 10.0f,
		float incidence = 10.0f
	)
	{
		src_ = src;
		dst_ = dst;
		strength_  = strength;
		incidence_ = incidence;
		runner_ = runner;

		return true;
	}
};

//! mCYtB^
class t_filt_noise : public t_filt_base <t_filt_param_noise>
{
public:
	// tB^s
	virtual bool run(t_filt_param_interface* param)
	{
		
		if(!param || param->type() != 6){
			return false;
		}
		t_filt_param_noise* p = param_downcast(param);
		if(p->dst_ && !p->src_->is_same(p->dst_)){
			return false;
		}
		switch(p->src_->tag()){
			case rgb_24bit:	return t_filt_noise_main<t_image_rgb>::func(p);
		}
		return false;
	}
};

}

#endif