#ifndef		__T_FILT_PIXELATE_H_INCLUDE_
#define		__T_FILT_PIXELATE_H_INCLUDE_

#include "../type/t_type_rgb.h"
#include "../type/t_type_gray.h"
#include "../contena/t_image_base.h"
#include "../runner/t_run_base.h"

#include "t_filt_base.h"
#include "template/t_filt_template_pixelate.h"

namespace t_image_engine{

//! sNZ[g(UCN)tB^p[^
class t_filt_param_pixelate : public t_filt_param_interface
{
public:
	// p[^
	t_image_interface	*src_;			//<! Ώۉ摜Q
	t_image_interface	*dst_;			//<! o͑Ώۉ摜Q(NULLȂsrc_ɏo)
	const t_run_base*	runner_;		//<! ̈
	int					filter_size_;	//<! tB^TCY

	//! RXgN^
	t_filt_param_pixelate() : t_filt_param_interface()
	{
		type_ = 7;
		src_ = dst_ = NULL;
		filter_size_ = 3;
		runner_ = NULL;
	}

	//! fXgN^
	virtual ~t_filt_param_pixelate()	
	{
	}

	//! p[^Zbg
	bool set_param(	
		t_image_interface* src, 
		t_image_interface* dst = NULL,
		const t_run_base* runner = NULL,
		int filter_size = 3
	)
	{
		dst_ = dst;
		src_ = src;
		runner_ = runner;
		filter_size_ = filter_size;

		return true;
	}
};

//! sNZ[gtB^
class t_filt_pixelate : public t_filt_base <t_filt_param_pixelate>
{
public:
	// tB^s
	virtual bool run(t_filt_param_interface* param)
	{
		if(!param || param->type() != 7){
			return false;
		}
		const t_filt_param_pixelate* p = param_downcast(param);
		if(p->dst_ && !p->src_->is_same(p->dst_)){
			return false;
		}

		// tB^Kp
		switch(p->src_->tag()){
			case rgb_24bit:		return t_filt_pixelate_main<t_image_rgb >::func(p);
			case rgba_32bit:	return t_filt_pixelate_main<t_image_rgba >::func(p);
			case gray_8bit:		return t_filt_pixelate_main<t_image_gray >::func(p);
			default:return false;
		}	
		return false;
	}
};

};

#endif
