#ifndef		__T_FILT_TEMPLATE_MEDIAN_H_INCLUDE_
#define		__T_FILT_TEMPLATE_MEDIAN_H_INCLUDE_

#include "../common/t_com_sort_functor.h"
#include "multifunc/t_filt_template_multifunc.h"
#include <vector>

namespace t_image_engine{

// p[^NX`	
class t_filt_param_median;

//! MediantB^C (t_filt_multifunctorev[g)
template < typename _PROCT> 
class t_filt_multifunctor <_PROCT, t_filt_param_median >
{
protected:
	int mid_;
	int size_;
	std::vector< const _PROCT* > pixels_;
	t_com_sort_functor<_PROCT>* sort_;
public:	

	// 
	t_filt_multifunctor(const t_filt_param_median* p)
	{
		size_ = p->filter_size_ * p->filter_size_;
		mid_ = (size_ + 1) / 2 - 1;
		pixels_.reserve(p->filter_size_);
		sort_ = new t_com_sort_functor<_PROCT>(p->sort_type_);
	}

	inline void func_filter_init()
	{}
	inline void func_filter_initline()
	{
		pixels_.clear();
	}
	inline void func_filter_make(const _PROCT* addr)
	{
		pixels_.push_back(addr);
	}
	inline void func_filter_run(_PROCT* dst)
	{
		std::sort(pixels_.begin(), pixels_.end(), *sort_);
		*dst = **(pixels_.begin() + mid_);
	}
	inline void func_linebuff_next(const _PROCT* faddr, const _PROCT* naddr)
	{
		*find(pixels_.begin(), pixels_.end(), faddr) = naddr;
	}
	inline void func_filter_finalize()
	{
		delete sort_;
	}

};


//! MediantB^Ăяo
template < typename _TYPE > 
class t_filt_median_main
{
protected:
	typename typedef _TYPE::imagetype_ _PROCT;

public:
	// ėp֐gp
	static inline bool func(const t_filt_param_median* p)
	{
		// tB^s
		return t_filt_template_multifunc<_PROCT ,t_filt_param_median >::
			func(p->src_, p->dst_, p, p->filter_size_);
	}
};

}

#endif
