#ifndef		__T_FILT_TEMPLATE_NOISE_H_INCLUDE_
#define		__T_FILT_TEMPLATE_NOISE_H_INCLUDE_

#include <time.h>
#include <limits>
#include <boost/random.hpp>
#include "multifunc/t_filt_template_multifunc.h"

namespace t_image_engine{

// mCYNX
template <class _TYPE>
class t_filt_noise_maker
{
protected:
	typename typedef _TYPE::_SINGLE_T _LT;
	typedef boost::mt19937	MT;
	typedef boost::uniform_real<float>	UF;
	
	// mCY@
	MT *gen_th_;
	UF *dst_th_;
	boost::variate_generator<MT, UF> *rand_th_;

	// x@
	MT *gen_str_;
	UF *dst_str_;
	boost::variate_generator<MT, UF> *rand_str_;
	
	// mCY
	float th_;

public:
	// RXgN^
	t_filt_noise_maker(float strength, float th)
	{
		// mCY@(0-100.0) 
		gen_str_  = new MT( static_cast<unsigned long>(time(0)));
		dst_str_  = new UF(0.f, 100.0f);
		rand_str_ = new boost::variate_generator<MT, UF>(*gen_str_, *dst_str_);

		// x@
		gen_th_   = new MT( static_cast<unsigned long>(time(0)));
		dst_th_   = new UF(0, strength);
		rand_th_  = new boost::variate_generator<MT, UF>(*gen_th_, *dst_th_);

		// mCY
		th_ = th;
	}

	// fXgN^
	~t_filt_noise_maker()
	{
		delete gen_th_, dst_th_, rand_th_;
		delete gen_str_, dst_str_, rand_str_;
	}

	// mCY
	inline void noise(_TYPE* dst, const _TYPE* src)
	{
		_LT* d = reinterpret_cast<_LT*>(dst);
		const _LT* s = reinterpret_cast<const _LT*>(src);

		if(static_cast<_LT>((*rand_th_)()) < th_){
			for(int i = 0; i < _TYPE::_MEMBER_NUM; i++, d++ ){	
				_LT noise = static_cast<_LT>((*rand_str_)());
				if(*d > noise){
					*d -= noise;
				}else{
					*d += noise;
				}
			}
		}
	}
};

// mCYNXC
class t_filt_param_noise;

template <typename _TYPE> 
class t_filt_noise_main
{
protected:
	typename typedef _TYPE::imagetype_ _PROCT;

	// Functor
	struct t_filt_noise_functor
	{
		inline static void f(const _PROCT *spt, _PROCT *dpt, t_filt_noise_maker<_PROCT>* noise)
		{
			noise->noise(dpt, spt);
		}
	};

public:
	static inline bool func(t_filt_param_noise* p)
	{

		// mCY@
		t_filt_noise_maker<_PROCT> noise_maker(p->strength_,  p->incidence_);

		// tB^s
		return t_filt_template_multifunc_simple<_TYPE, t_filt_param_noise, 
			t_filt_noise_functor,  t_filt_noise_maker<_PROCT>* >::func(p, &noise_maker);
	}
};

}

#endif