#ifndef		__T_FILT_TEMPLATE_POSTALISATION_H_INCLUDE_
#define		__T_FILT_TEMPLATE_POSTALISATION_H_INCLUDE_

#include "multifunc/t_filt_template_multifunc.h"
#include <limits>

namespace t_image_engine{

// ϊNXev[g
template <class _TYPE> 
class t_filt_postalisation_func
{
protected:
	typename typedef _TYPE::_SINGLE_T _LT;
	_LT* table_;

public:
	// RXgN^ e[u쐬
	t_filt_postalisation_func(int step)
	{
		int typestep = std::numeric_limits<_LT>::max();
		table_ = new _LT [typestep + 1];

		const float fmax = static_cast<float>(typestep);
		const float v_add = fmax / static_cast<float>(step);
		const float t_add = fmax / static_cast<float>(step-1);
		float th = fmax - t_add;
		float val = fmax;
		for(int i = typestep; i >= 0; i--){
			if(i < th){
				th  -= t_add;
				val -= v_add;
			}
			table_[i] = static_cast<_LT>(val);
		}
	}

	// fXgN^
	~t_filt_postalisation_func()
	{
		delete [] table_;
	}

	// l̎擾
	void postal(_TYPE* dst, const _TYPE* src)
	{
		_LT* d = reinterpret_cast<_LT*>(dst);
		const _LT* s = reinterpret_cast<const _LT*>(src);
		for(int i = 0; i < _TYPE::_MEMBER_NUM; i++){
			*d++ = table_[*s++];
		}
	}
};

// |X^[[VNXC
class t_filt_param_postalisation;

template <class _TYPE> 
class t_filt_postalisation_main
{
protected:
	typename typedef _TYPE::imagetype_ _PROCT;
	typename typedef _PROCT::_SINGLE_T _LT;

	// Functor
	class t_filt_postalisation_functor
	{
	public:
		inline static void f(const _PROCT *spt, _PROCT *dpt, t_filt_postalisation_func<_PROCT>* postal)
		{
			postal->postal(dpt, spt);
		}
	};

public:
	// |X^[[VsC
	static inline bool func(t_filt_param_postalisation* p)
	{
		// P|X^[[V
		t_filt_postalisation_func<_PROCT> postal(p->step_);

		// tB^s
		return t_filt_template_multifunc_simple<_TYPE, t_filt_param_postalisation, 
			t_filt_postalisation_functor,  t_filt_postalisation_func<_PROCT>* >::func(p, &postal);
	}
};

}

#endif