#ifndef		__T_IOIF_BMP_H_INCLUDE_
#define		__T_IOIF_BMP_H_INCLUDE_

#include <stdio.h>
#include "t_ioif_bmpheader.h"

namespace t_image_engine{

class t_image_gray;
class t_image_rgb;

// BMPǏpNX
class t_ioif_bmp
{
public:
	/*==========================================================================================*//*!
	@brief
		BITMAP HEADERǍ݊֐(wb_ȍ~̃t@C|C^Q)
	@return
		֐
	*//*==========================================================================================*/
	static bool read(LPCSTR filepath, BITMAPFILEHEADER* fileheader, BITMAPINFOHEADER* infoheader)
	{
		// t@CI[v
		FILE* fp = fopen(filepath, "rb");
		if(!fp)	
			return false;	// t@CI[vs
		// wb_t@CǍ
		fread(fileheader, sizeof(BITMAPFILEHEADER), 1, fp);
		fread(infoheader, sizeof(BITMAPINFOHEADER), 1, fp);
		fclose(fp);
		return true;
	}

	/*==========================================================================================*//*!
	@brief
		BITMAP HEADERǍ݊֐(wb_ȍ~̃t@C|C^Q)
	@return
		֐
	*//*==========================================================================================*/
	static bool read(LPCSTR filepath, BITMAPFILEHEADER* fileheader, BITMAPINFOHEADER* infoheader, FILE** dstfp)
	{
		// t@CI[v
		FILE* fp = fopen(filepath, "rb");
		if(!fp)	
			return false;	// t@CI[vs
		// wb_t@CǍ
		fread(fileheader, sizeof(BITMAPFILEHEADER), 1, fp);
		fread(infoheader, sizeof(BITMAPINFOHEADER), 1, fp);
		// ItZbgǂݔ΂
		fseek(fp, fileheader->bfOffBits, SEEK_SET);
		if(dstfp)
			*dstfp = fp;
		return true;
	}
	
	/*==========================================================================================*//*!
	@brief
		8bitBITMAPǍ݊֐

	@param	filepath	ǍBITMAPt@C̃pX
	@param	img			ǂݍ񂾉摜̊i[
	@return
		֐
	*//*==========================================================================================*/
	static bool read(LPCSTR filepath, t_image_gray* img)
	{	
		if(!img)
			return false;
		// t@CI[v
		FILE* fp;
		BITMAPFILEHEADER	bfhFileHeader;
		BITMAPINFOHEADER	bihInfoHeader;
		if(!read(filepath, &bfhFileHeader, &bihInfoHeader, &fp))
			return false;
		const int width = bihInfoHeader.biWidth;
		const int height = abs(bihInfoHeader.biHeight);
		const int bmpwidth = (width * bihInfoHeader.biBitCount / 8 + 3) & ~3;
		
		// 摜m
		if(!img->create(width, height)){
			fclose(fp);
			return	false;
		}

		// 24rbgJ[
		if(bihInfoHeader.biBitCount == 24){	
			// PC̃m
			unsigned char*	pt = img->pointer();
			RGBTRIPLE*	linebuff = new RGBTRIPLE[bmpwidth];
			for(int y = 0; y < height; y++){
				fread(linebuff, 1, bmpwidth, fp);
				
				unsigned char* p = (bihInfoHeader.biHeight > 0) ? 
					p = pt + (height - y - 1) * width:	// DOWNUP					
					p = pt + y * width;					// UPDOWN

				// widthRs[ RGBϒl
				for(int x = 0; x < width; x++, p++)
					*p = (unsigned char)(((int)linebuff[x].rgbtRed + (int)linebuff[x].rgbtGreen + (int)linebuff[x].rgbtBlue) / 3);
			}
			delete [] linebuff;
		}

		// 8rbgJ[
		else if(bihInfoHeader.biBitCount == 8)
		{
			// PC̃m
			unsigned char*	pt = img->pointer();
			unsigned char*	linebuff = new unsigned char[bmpwidth];
			for(int y = 0; y < height; y++){
				fread(linebuff, sizeof(unsigned char),  bmpwidth, fp);
				unsigned char* p;
				if(bihInfoHeader.biHeight > 0)
					p = pt + (height - y - 1) * width;	// DOWNUP
				else
					p = pt + y * width;					// UPDOWN
				memcpy(p, linebuff, sizeof(unsigned char) * width);
			}
			delete [] linebuff;
		}
		// ̑
		else{
			fclose(fp);
			return false;
		}

		// t@CN[Y
		fclose(fp);
		return true;
	}


	/*==========================================================================================*//*!
	@brief
		24bitBITMAPǍ݊֐
	@param	filepath	ǍBITMAPt@C̃pX
	@param	img			ǂݍ񂾉摜̊i[
	@return
		֐
	*//*==========================================================================================*/
	static bool read(LPCSTR filepath, t_image_rgb* img)
	{
		if(!img)
			return false;

		// t@CI[v
		FILE* fp;
		BITMAPFILEHEADER	bfhFileHeader;
		BITMAPINFOHEADER	bihInfoHeader;
		if(!read(filepath, &bfhFileHeader, &bihInfoHeader, &fp))
			return false;

		int	width = bihInfoHeader.biWidth;
		int	height = abs(bihInfoHeader.biHeight);
		int bmpwidth = (width * bihInfoHeader.biBitCount / 8 + 3) & ~3;
		
		// 摜m
		if(!img->create(width, height)){
			fclose(fp);
			return	false;
		}

		// 24rbgJ[
		if(bihInfoHeader.biBitCount == 24){	
			// PC̃m
			t_type_rgb*	pt = img->pointer();
			unsigned char*	linebuff = new unsigned char[bmpwidth];
			for(int y = 0; y < height; y++){
				fread(linebuff, sizeof(unsigned char), bmpwidth, fp);
				t_type_rgb* p = (bihInfoHeader.biHeight > 0) ?
					p = pt + (height - y - 1) * width:	// DOWNUP
					p = pt + y * width;					// UPDOWN
				memcpy(p, linebuff, sizeof(t_type_rgb) * width);
			}
			delete [] linebuff;
		}

		// 8rbgJ[
		else if(bihInfoHeader.biBitCount == 8){
			// PC̃m
			t_type_rgb*	pt = img->pointer();
			unsigned char*	linebuff = new unsigned char[bmpwidth];
			for(int y = 0; y < height; y++){
				fread(linebuff, sizeof(unsigned char),  bmpwidth, fp);
				t_type_rgb* p = (bihInfoHeader.biHeight > 0) ?
					p = pt + (height - y - 1) * width:	// DOWNUP
					p = pt + y * width;					// UPDOWN
				for(int i = 0; i < width; i++){
					(p + i)->r_ = (p + i)->g_ = (p + i)->b_ = linebuff[i];
				}
			}
			delete [] linebuff;
		}
		// ̑
		else{
			fclose(fp);
			return false;
		}
		// t@CN[Y
		fclose(fp);
		return true;
	}

	/*==========================================================================================*//*!
	@brief
		BITMAPt@Cݏ

	@param	filepath	ރt@CpX
	@param	img			މ摜
	@return
		֐
	*//*==========================================================================================*/
	static bool write(LPCSTR filepath, const t_image_interface& img)
	{
		// t@CI[v
		FILE *fp = fopen(filepath, "wb");
		if(fp == NULL)	
			return false;	// t@CI[vs

		// wb_񐶐
		BITMAPFILEHEADER	bfhFileHeader = t_ioif_bmpheader::make_fileheader(img);
		BITMAPINFOHEADER	bihInfoHeader = t_ioif_bmpheader::make_infoheader(img);

		// 
		fwrite(&bfhFileHeader, sizeof(BITMAPFILEHEADER), 1, fp);
		fwrite(&bihInfoHeader, sizeof(BITMAPINFOHEADER), 1, fp);

		// J[e[u
		if(img.bitcount() == 8){
			RGBQUAD colorTB[256];
			for(int i = 0; i < 256; i++){
				colorTB[i].rgbRed	= i;
				colorTB[i].rgbGreen = i;
				colorTB[i].rgbBlue	= i;
				colorTB[i].rgbReserved	= 0;
			}
			fwrite(colorTB, sizeof(RGBQUAD) * 256, 1, fp);
		}

		// 4BYTEĚvZ
		const int widthbmp = (img.linesize()+3)&~3;
		if((img.width()*3)%4 == 0){
			// 1C4BYTE̔{
			for(int i = 0; i < img.height(); i++){
				const unsigned char* p = img.pointer_safe_() + (img.height() - i - 1) * img.linesize();
				fwrite(p, widthbmp, 1, fp);
			}
		}else{
			// 1C4BYTE̔{łȂꍇ
			const int width = img.linesize();
			unsigned char* buffer = new unsigned char [widthbmp];
			for(int i = 0; i < img.height(); i++){
				const unsigned char* p = img.pointer_safe_() + (img.height() - i - 1) * img.linesize();
				memcpy(buffer, p, width);
				fwrite(buffer, widthbmp, 1, fp);
			}
			delete [] buffer;
		}

		// N[Y
		fclose(fp);
		return true;
	}
};

}

#endif