#ifndef	__T_IOIF_DC_H_INCLUDE_
#define	__T_IOIF_DC_H_INCLUDE_

#if _MSC_VER > 1000
#pragma once
#endif

#include "../type/t_type_define.h"
#include "t_ioif_bmpheader.h"

namespace t_image_engine{

//! BMP`pNX
class t_ioif_dc
{
protected:

public:
	//! RXgN^
	t_ioif_dc()
	{
	}

	//! fXgN^
	virtual ~t_ioif_dc()
	{
	}

	/*==========================================================================================*//*!
	@brief
		` BmpInfo쐬
	*//*==========================================================================================*/
	static bool draw(	const t_image_interface& img, HDC hDC, 
				int dstSx = 0, int dstSy = 0, int dstWidth = 0, int dstHeight = 0, 
				int srcSx = 0, int srcSy = 0, int srcWidth = 0, int srcHeight = 0,
				DWORD operation = SRCCOPY)
	{
		// BITMAPINFO쐬
		unsigned char* bmiInfodata = t_ioif_bmpheader::make_bmiinfo(img);
		BITMAPINFO* bmiInfo = reinterpret_cast<BITMAPINFO*>(bmiInfodata);
		
		// `
		bool ret = draw_ex(img, hDC, bmiInfo,
				dstSx, dstSy, dstWidth, dstHeight, 
				srcSx, srcSy, srcWidth, srcWidth, operation);
		delete [] bmiInfodata;
		return ret;
	}


	/*==========================================================================================*//*!
	@brief
		`(gkL) + BITMAPINFOw
	@param	img			`悷摜
	@param	dstSx		` Jn XWʒu
	@param	dstSy		` Jn YWʒu
	@param	dstWidth	` 摜̕
	@param	dstHeight	` 摜̍
	@param	srcSx		`摜 Jn XWʒu
	@param	srcSy		`摜 Jn YWʒu
	@param	srcWidth	`摜 摜̕
	@param	srcHeight	`摜 摜̍
	@param	bmiinfo		BitmapInfo\
	@param	operation	X^Iy[V
	@return
		֐
	*//*==========================================================================================*/
	static bool draw_ex(	
				const t_image_interface& img, HDC hDC, const BITMAPINFO* bmiInfo,
				int dstSx = 0, int dstSy = 0, int dstWidth = 0, int dstHeight = 0, 
				int srcSx = 0, int srcSy = 0, int srcWidth = 0, int srcHeight = 0, 
				DWORD operation = SRCCOPY)
	{
		// 摜|C^NULLȂ\Ȃ
		if( !img.pointer_safe_() || !bmiInfo)	
			return false;

		// EftHglȂ␳
		if(!dstWidth)	dstWidth = img.width();
		if(!srcWidth)	srcWidth = img.width();
		if(!dstHeight)	dstHeight = img.height();
		if(!srcHeight)	srcHeight = img.height();
		
		BOOL bRet;
		SetStretchBltMode(hDC, HALFTONE);
		//SetStretchBltMode(hDC, BLACKONWHITE);

		// 4BYTEE`FbN
		const void* dibAddr = NULL;
		if(img.linesize() & 3){ 
			// ␳vZ
			const int widht_b = (img.linesize() + 3) & ~3;
			const int width_c = img.linesize();

			// 4oCg݂ɃRs[
			unsigned char* buff = new unsigned char [widht_b * img.height()];
			unsigned char* buff_b = buff;
			const BYTE* buff_s =img.pointer_safe_();
			for(int i = 0; i < img.height(); i++, buff_b += widht_b, buff_s += width_c)
				memcpy(buff_b, buff_s, width_c);
			dibAddr = buff;
		}

		// `
		bRet = StretchDIBits(
			hDC,				// foCXReLXg̃nh
			dstSx,				// ]撷`̍ x W
			dstSy,				// ]撷`̍ y W
			dstWidth,			// ]3撷`̕
			dstHeight,			// ]撷`̍
			srcSx,				// ]`̍ x W
			srcSy,				// ]`̍ y W
			srcWidth,			// ]`̕
			srcHeight,			// ]`̍
			dibAddr ? dibAddr : img.pointer_safe_(),// DIB rbgȂz
			bmiInfo,			// rbg}bv
			DIB_RGB_COLORS,		// RGB l܂̓pbgCfbNX
			operation			// X^Iy[V
		);
	
		// obt@폜
		if(dibAddr){
			delete [] dibAddr;
		}
		return ( bRet ) ? true : false;
	}
};

}

#endif