#ifndef		__T_IOIF_JPEG_H_INCLUDE_
#define		__T_IOIF_JPEG_H_INCLUDE_

extern "C" {
#include "../../lib/libjpeg/include/jconfig.h"
#include "../../lib/libjpeg/include/jmorecfg.h"
#include "../../lib/libjpeg/include/jpeglib.h"
}

namespace t_image_engine{

//! JPEGǏNX(gpꍇ̓vWFNglibjpeg.libǍނ)
class t_ioif_jpeg
{
public:
	// ݃\bh
	/*==========================================================================================*//*!
	@brief
		imagef[^jpegɕϊď
	@param	filepath	ݐ
	@param	img			݉摜
	@param	quality		jpegi	
	@return
		֐
	*//*==========================================================================================*/
	static bool write(LPCSTR filepath, const t_image_interface& img, int quality = 80)
	{
		// G[`FbN
		if(!img.size())
			return false;
		// t@CI[v
		FILE* file = fopen(filepath, "wb");
		if(!file)
			return false;

		// 쐬
		jpeg_compress_struct	jc_jpeg;	//GR[hp\
		jpeg_error_mgr			jem_error;	//JPEGG[}l[W
		jc_jpeg.err = jpeg_std_error(&jem_error);
		jpeg_create_compress(&jc_jpeg);
	
		// fXeBl[Vݒ
		jpeg_stdio_dest(&jc_jpeg, file);

		// GR[h
		bool ret = encode(&jc_jpeg, img, quality);
		jpeg_destroy_compress(&jc_jpeg);
		fclose(file);

		return ret;
	}

	/*==========================================================================================*//*!
	@brief
		imagef[^jpegɕϊăWJ
	@param	buffer		ݐ
	@param	buffersize	ݐ TCY
	@param	img			݉摜
	@param	quality		jpegi	
	@return
		WJチTCY (̒lȂG[)
	*//*==========================================================================================*/
	static int write2memory(unsigned char* buffer, unsigned long buffersize, 
							const t_image_interface& img, int quality = 80)
	{
		// G[`FbN
		if(!img.size() || !buffer)
			return false;
		// 쐬
		jpeg_compress_struct	jc_jpeg;	//GR[hp\
		jpeg_error_mgr			jem_error;	//JPEGG[}l[W
		jc_jpeg.err = jpeg_std_error(&jem_error);
		jpeg_create_compress(&jc_jpeg);
	
		// fXeBl[Vݒ
		jpeg_memory_dest(&jc_jpeg, buffer, buffersize);

		// GR[h
		bool ret = encode(&jc_jpeg, img, quality);
		int size = buffersize - jc_jpeg.dest->free_in_buffer;
		jpeg_destroy_compress(&jc_jpeg);
		return size;
	}

public:
	// ǂݍ݃\bh
	/*==========================================================================================*//*!
	@brief
		JPEGǂݍ
	@param	filepath	ǂݍݐt@CpX
	@param	img			摜i[
	@return
		֐
	*//*==========================================================================================*/
	static bool read(LPCSTR filepath, t_image_rgb* img)
	{	
		if(!img)
			return false;
		// t@CI[v
		FILE* file = fopen(filepath, "rb");
		if(!file)
			return false;

		jpeg_decompress_struct	jd_jpeg;	// fR[hp\
		jpeg_error_mgr			jem_error;	// JPEGG[}l[W
		jd_jpeg.err = jpeg_std_error(&jem_error);	
		jpeg_create_decompress(&jd_jpeg);	// fR[hpݒ\z

		jpeg_stdio_src(&jd_jpeg,file);		// Ǎt@Cݒ
		bool ret = decode(&jd_jpeg, img);
		jpeg_destroy_decompress(&jd_jpeg);
		fclose(file);

		return true;
	}

	static bool read2memory(unsigned char* buffer, unsigned long buffersize, t_image_rgb* img)
	{
		return false;
	}

protected:
	// GR[h
	static bool encode(jpeg_compress_struct* jc_jpeg, const t_image_interface& img, int quality)
	{
		// ݒ
		jc_jpeg->image_width = img.width();
		jc_jpeg->image_height = img.height();

		// 摜^Cv
		switch(img.tag()){
		case rgb_24bit:
			jc_jpeg->input_components = 3;
			jc_jpeg->in_color_space = JCS_RGB;
			break;
		case gray_8bit:
			jc_jpeg->input_components = 1;
			jc_jpeg->in_color_space = JCS_GRAYSCALE;
			break;
		default:
			return false;
		}
		// ftHgݒ
		jpeg_set_defaults(jc_jpeg);
		// NIeB̐ݒ
		jpeg_set_quality(jc_jpeg, quality, false);
		// GR[hJn
		jpeg_start_compress(jc_jpeg, true);
		// sobt@̐ݒ
		const int linesize = ((img.width() * jc_jpeg->input_components) + 3) & 0xfffffffc;
		// GR[h
		int lineoffset = 0;
		const int offsetwidth = img.width() * jc_jpeg->input_components; 
		while(jc_jpeg->next_scanline < (unsigned int)img.height()){
			JSAMPROW work = (JSAMPROW)(img.pointer_safe_() + lineoffset);
			jpeg_write_scanlines(jc_jpeg, (JSAMPARRAY)&work , 1);
			lineoffset += offsetwidth;
		}
		// GR[h㏈ & I
		jpeg_finish_compress(jc_jpeg);
		
		return true;
	}

	// WJp֐
	static void jpeg_memory_dest(jpeg_compress_struct* jc_jpeg, void* buffer, unsigned long len)
	{
		memory_destination_mgr* dest;
		if (!jc_jpeg->dest) {
			jc_jpeg->dest = (struct jpeg_destination_mgr *)
			(*jc_jpeg->mem->alloc_small) ((j_common_ptr) jc_jpeg, JPOOL_PERMANENT,
			sizeof(memory_destination_mgr));
		}
		dest = (memory_destination_mgr*) jc_jpeg->dest;
		dest->pub.init_destination		= memory_init_destination;
		dest->pub.empty_output_buffer	= memory_empty_output_buffer;
		dest->pub.term_destination		= memory_term_destination;
		dest->buffer = (JOCTET*)buffer;
		dest->buffer_length = len;
	}

	// WJp֐
	static void memory_init_destination (jpeg_compress_struct* jc_jpeg)
	{
		memory_destination_mgr* dest;
		dest = (memory_destination_mgr*)jc_jpeg->dest;
		dest->pub.free_in_buffer = dest->buffer_length;
		dest->pub.next_output_byte = dest->buffer;
	}
	
	static boolean memory_empty_output_buffer (jpeg_compress_struct* jc_jpeg)
	{
		return true;
	}
	static void memory_term_destination (jpeg_compress_struct* jc_jpeg)
	{
	}

protected:
	// fR[h 
	static bool decode(jpeg_decompress_struct* jd_jpeg, t_image_rgb* img)
	{
		jpeg_read_header(jd_jpeg,TRUE);	// wb_[Ǎ
		jpeg_start_decompress(jd_jpeg);	// fR[hX^[g

		// m
		img->create(jd_jpeg->output_width, jd_jpeg->output_height);
		
		// Rs[Jnʒuw
		t_type_rgb* img_pt = img->pointer();

		// sobt@̐ݒ
		int linesize_jpg = jd_jpeg->output_width * jd_jpeg->output_components;

		// JPEGǍ
		JSAMPLE* read_buffer = new JSAMPLE[linesize_jpg + 10];
		const int width = img->width()*sizeof(t_type_rgb);
		while(jd_jpeg->output_scanline < jd_jpeg->output_height){
			jpeg_read_scanlines(jd_jpeg, &read_buffer, 1);		//Jpeg1CǍ
			memcpy(img_pt, read_buffer, width);
			img_pt += img->width();
		}
		delete [] read_buffer;
		jpeg_finish_decompress(jd_jpeg);		// ǂݍݏI

		return true;
	}
protected:
	// WJp\
	typedef struct {
		struct jpeg_destination_mgr pub;
		JOCTET * buffer;
		unsigned long buffer_length;
	} memory_destination_mgr;
};

}

#endif