#ifndef		__T_PHY_PARABOLA_H_INCLUDE_
#define		__T_PHY_PARABOLA_H_INCLUDE_

#include "../data/t_point.h"
#include "../type/t_type_define.h"
#include <math.h>
#include <utility>
#include <boost/tuple/tuple.hpp>

namespace t_image_engine{

// 쐬(2)
template <typename _TYPE = float>
class t_phy_parabola{

public:
	typedef _TYPE _SINGLE_T;
	typedef t_point_template<_TYPE> _POINT_T;

	// RXgN^
	t_phy_parabola(_TYPE angle, _TYPE gravity, _TYPE velocity)
	{
		set(angle, gravity, velocity);
	}
	// fXgN^
	virtual ~t_phy_parabola(){}

	// Zbg
	inline void reset(_TYPE angle, _TYPE gravity, _TYPE velocity)
	{
		set(angle, gravity, velocity);
	}

	// W擾
	inline _POINT_T getpos(_TYPE sec)
	{
		const _TYPE v = velocity_*sec;
		return _POINT_T(
			v*cos_, 
			v*sin_-(gravity_*sec*sec)/2);
	}

protected:
	// Zbg
	inline void set(_TYPE angle, _TYPE gravity, _TYPE velocity)
	{
		gravity_	= gravity; 
		velocity_	= velocity;
		const _TYPE rad = angle * radf_f;
		cos_ = cosf(rad);
		sin_ = sinf(rad);
	}

	_TYPE	gravity_;	// d͒l
	_TYPE	velocity_;	// 
	_TYPE	cos_;
	_TYPE	sin_;
};

}

#endif