#ifndef		__T_PHY_PARABOLA3D_H_INCLUDE_
#define		__T_PHY_PARABOLA3D_H_INCLUDE_

#include "../data/t_point3d.h"
#include "../type/t_type_define.h"
#include <math.h>
#include <utility>

namespace t_image_engine{

// 쐬(3)
template <typename _TYPE = float>
class t_phy_parabola_3d{

public:
	typedef _TYPE _SINGLE_T;
	typedef t_point3d_template<_TYPE> _POINT_T;

	// RXgN^
	t_phy_parabola_3d(_TYPE angle_xy, _TYPE angle_xz, _TYPE gravity, _TYPE velocity)
	{
		set(angle_xy, angle_xz, gravity, velocity);
	}
	// fXgN^
	virtual ~t_phy_parabola_3d(){}

	// Zbg
	inline void reset(_TYPE angle_xy, _TYPE angle_xz, _TYPE gravity, _TYPE velocity)
	{
		set(angle_xy, angle_xz, gravity, velocity);
	}
	// W擾
	inline _POINT_T getpos(_TYPE sec)
	{
		const _TYPE v = velocity_*sec;
		return _POINT_T(
			v*cos_xy_, 
			v*sin_xy_-(gravity_*sec*sec)/2,
			v*sin_xz_);
	}

protected:
	// Zbg
	inline void set(_TYPE angle_xy, _TYPE angle_xz, _TYPE gravity, _TYPE velocity)
	{
		gravity_	= gravity; 
		velocity_	= velocity;
		const _TYPE radxy = angle_xy * radf_f;
		const _TYPE radxz = angle_xz * radf_f;
		cos_xy_ = cosf(radxy);
		sin_xy_ = sinf(radxy);
		sin_xz_ = sinf(radxz);
	}

	_TYPE	gravity_;	// d͒l
	_TYPE	velocity_;	// 
	_TYPE	cos_xy_;
	_TYPE	sin_xy_;
	_TYPE	sin_xz_;
};

}

#endif