#ifndef		__T_TRANS_TABLE_H_INCLUDE_
#define		__T_TRANS_TABLE_H_INCLUDE_

#include "../data/t_table.h"

namespace t_image_engine{

class t_trans_table{
public:
	// We[uό`
//	inline static bool trans(const t_image_interface& src, t_image_interface* dst, 
//						const t_table& table, stretch_type type = nearest_neighbor)

	inline static bool trans(const t_image_rgb& src, t_image_rgb* dst, 
		const t_point& offset, const t_table& table, stretch_type type = nearest_neighbor)
	{
		// o͐̍쐬
		if(dst->width()!=src.width() || dst->height()!=src.height()){
			dst->create(src.width(), src.height());
		}

		// e[uS̏
		const t_type_rgb *const sptbase = src.pointer_safe();
		const int w = src.width();
		const int h = src.height();
		for(int y = 0; y < table.get_height(); y++){
			const int ypos = y + offset.y_;
			if(ypos < 0 || ypos > h){
				continue;
			}
			t_type_rgb* dpt = dst->pointer() + ypos * dst->width();
			const t_table::_T_TABLE_LINE* line = table.get_line_pt_safe(y);
			for(int x = 0; x < table.get_width(); x++){
				const int xpos = x + offset.x_;
				if(xpos < 0 || xpos > w){
					continue;
				}
				const int txpos = static_cast<int>(line->at(x).x_ + offset.x_);
				const int typos = static_cast<int>(line->at(x).y_ + offset.y_);
				if(	typos >= 0 && typos < dst->height() &&
					txpos >= 0 && txpos < dst->width()){
					*(dpt+xpos) = *(sptbase + typos * w + txpos); 
				}
			}
		}
		return false;
	};
};

};

#endif