#ifndef		__T_TTABLE_ZOOM_H_INCLUDE_
#define		__T_TTABLE_ZOOM_H_INCLUDE_

#include "../data/t_table.h"
#include "../type/t_type_define.h"


namespace t_image_engine{


// Y[u[e[u̍쐬
class t_ttable_zoom{
public:
	inline static bool create(t_table* table, int radius)
	{
		const int diameter =  radius * 2;
		table->create_table(diameter, diameter);

		// CƂ̃Y[l
		std::vector<float> zoomTable(360);
		for(int i = 0; i < 360; i++){
			zoomTable[i] = static_cast<float>(rand() % 100 + 100) / 100.0f;		
		}

		for(int y = 0; y < diameter; y++){
			t_table::_T_TABLE_LINE *line = table->get_line_pt(y);
			const int xpos = static_cast<int>(radius - sqrt(
				pow(static_cast<double>(radius),2) - 
				pow(static_cast<double>(radius - y),2)));
			for(int x = 0; x < diameter; x++){
				//if(x <= xpos || x >= diameter-xpos){
				//	line->at(x) = t_pointf((float)x, (float)y);
				//}else{
					calcpos(&line->at(x), x, y, radius, radius, radius, zoomTable);
				//}
			}
		}
		return true;
	}

	inline static void calcpos(t_pointf* pos, int x, int y, 
		int centerx, int centery, int radius, const std::vector<float>& zoomTable)
	{
		// ݂̓_璆S܂ł̊px
		float xlen = static_cast<float>(x - centerx);
		float ylen = static_cast<float>(y - centery);
		float rad = atan2f(xlen, ylen) + pi_f/2; // 90x]
		float angle = rad * degf_f;
		if(angle >= 360.f) angle -= 360.f;
		if(angle <   0.f) angle += 360.f;

		// pxW擾
		float anglei, anglef, coef;
		anglef = modf(angle, &anglei);
		
		if(anglef == 0.f){
			coef =  zoomTable[static_cast<int>(anglei)];
		}else{
			float coef_a = zoomTable[static_cast<int>(anglei)];
			float coef_b = zoomTable[static_cast<int>(anglei + 1)];
			coef = coef_a * (1.f-anglef) + coef_b * anglef;
		}

		// ݂̓_璆S܂ł̋
		float len = sqrt(xlen*xlen+ylen*ylen);
		len *= coef;
		pos->x_ = centerx - len * cos(rad);
		pos->y_ = centery + len * sin(rad);
	}
};

}

#endif