#ifndef		__T_UTIL_TIMER_H_INCLUDE_
#define		__T_UTIL_TIMER_H_INCLUDE_

// windows only

namespace t_image_engine{

// ԑNX 
class t_util_timer{
protected:
	__int64	freq_;
	__int64	start_;

	__int64	get_time_span(__int64 freq)
	{
		__int64 now;
		::QueryPerformanceCounter((LARGE_INTEGER*)&now);
		return ((now - start_) * freq) / freq_;
	}

public:
	t_util_timer()
	{
		::QueryPerformanceFrequency((LARGE_INTEGER*)&freq_);
		start();
	}

	~t_util_timer()
	{
	}

	inline void	start()
	{
		::Sleep(0);
		::QueryPerformanceCounter((LARGE_INTEGER*)&start_);
	}

	inline void	synchro(const t_util_timer& src)
	{
		freq_	= src.freq_;
		start_	= src.start_;
	}
	inline double	get_freq_cpu()
	{
		return static_cast<double>(freq_ / 1000) / 1000.0;
	}

	inline __int64	get_micro_sec64()
	{
		return get_time_span(1000000);
	}

	inline __int64	get_milli_sec64()
	{
		return get_time_span(1000);
	}

	inline unsigned int get_micro_sec()
	{
		return static_cast<unsigned int>(get_micro_sec64());
	}

	inline double	get_milli_sec()
	{
		return static_cast<double>(get_micro_sec()) / 1000.0;
	}

	inline double	get_sec()
	{
		return get_milli_sec() / 1000.0;
	}
};

}

#endif