package jp.osoite.tomu.itree.core;

import java.util.ArrayList;
import java.util.TimerTask;
import jp.osoite.tomu.itree.list.LinList;
import jp.osoite.tomu.itree.list.SortedLinList;
import jp.osoite.tomu.itree.util.Node;

public class PeriodicDeleteTask extends TimerTask {

    private ITreeCore itree;

    public void setCurrentITree(ITreeCore it) {
        this.itree = it;
    }

    public ITreeCore getCurrentITree() {
        return itree;
    }

    public void run() {
        //System.out.println("Current num of data in itree : " + itree.num_of_data);
        if (itree.num_of_data != 0) {
            float root_mbr[] = new float[itree.dimension * 2];
            LinList matchNodes = new LinList();

            try {
                root_mbr = ((Node) itree.root_ptr).get_mbr();
            } catch (NullPointerException e) {
                System.err.println(e.getMessage());
            }

            // LinList for storing result of a query.
            SortedLinList res = new SortedLinList();
            // rangeQuery using root_mbr
            itree.rangeQuery(root_mbr, res, matchNodes);

            //System.out.println("Num of Nodes in current I-Tree : " + matchNodes.get_num());
            ITDataNode matchNode = null;
            for (int i = 0; i < matchNodes.get_num(); i++) {
                ArrayList<Integer> matchData = new ArrayList<Integer>();

                for (int j = 0; j < ((ITDataNode) matchNodes.get(i)).get_num(); j++) {
                    matchNode = (ITDataNode) matchNodes.get(i);

                    if (((ITDataNode) matchNodes.get(i)).data[j].time_of_delete + itree.getWindowTime() < System.currentTimeMillis()) {
                        matchData.add(j);
                        //System.out.println(matchNode.data[j].get_ID() + " is a candidate of a delete.");
                        //System.out.println("j : " + j);
                    }
                }

                if (matchNode != null) {
                    for (int k = 0; k < matchData.size(); k++) {
                        //System.out.println("matchNode.num_entries : " + matchNode.num_entries);
                        //System.out.println("matchData.size() : " + matchData.size());
                        //System.out.println("matchData.get(k) : " + matchData.get(k));
                        //System.out.println(matchNode.data[matchData.get(k)].get_ID() + " is deleted.");

                        matchNode.data[matchData.get(k)] = null;

                        /*int count = 0;
                        while(count != matchNode.num_entries){
                        if(matchNode.data[count] != null){
                        System.out.println("matchNode.data[" + count + "] : " + matchNode.data[count].get_ID());
                        }else{
                        System.out.println("matchNode.data[" + count + "] : null");
                        }
                        count++;
                        }*/
                    }

                    // Removing null data node.
                    for (int l = 0; l < matchData.size(); l++) {
                        for (int m = 0; m < matchNode.num_entries + 1; m++) {
                            if (matchNode.data[m] == null) {
                                for (int n = m; n < matchNode.num_entries + 1; n++) {
                                    matchNode.data[n] = matchNode.data[n + 1];
                                }

                                /*
                                int count = 0;
                                while(count != matchNode.num_entries){
                                if(matchNode.data[count] != null){
                                System.out.println("## matchNode.data[" + count + "] : " + matchNode.data[count].get_ID());
                                }else{
                                System.out.println("## matchNode.data[" + count + "] : null");
                                }
                                count++;
                                }
                                 */
                            }
                        }
                    }

                    /*int count = 0;
                    while(count != matchNode.num_entries){
                    if(matchNode.data[count] != null){
                    System.out.println("### matchNode.data[" + count + "] : " + matchNode.data[count].get_ID());
                    }else{
                    System.out.println("### matchNode.data[" + count + "] : null");
                    }
                    count++;
                    }*/

                    matchNode.num_entries = matchNode.num_entries - matchData.size();
                    matchNode.set_num(matchNode.num_entries);
                    matchNode.dirty = true;
                    itree.set_num(itree.get_num() - matchData.size());

                }

                if (matchNode.num_entries == 0) {
                    //System.out.println("MatchNode is deleted");
                    matchNode.delete();
                }
            }
        }
    }
}
