/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import junit.framework.TestCase;
import org.openqa.selenium.server.browserlaunchers.MacProxyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacProxyManagerUnitTest
extends TestCase {
    MockableMacProxyManager mmpm;

    public void setUp() {
        this.mmpm = new MockableMacProxyManager("", 4444);
    }

    public void testReadSettingsProxyEnabled() throws Exception {
        MacProxyManager.MacNetworkSettings networkSettings = this.mmpm._getCurrentNetworkSettings();
        networkSettings.toString();
        MacProxyManagerUnitTest.assertEquals((String)"wrong serviceName", (String)"foo bar", (String)networkSettings.serviceName);
        MacProxyManagerUnitTest.assertEquals((String)"wrong enabled", (boolean)true, (boolean)networkSettings.enabled);
        MacProxyManagerUnitTest.assertEquals((String)"wrong proxyServer", (String)"foo", (String)networkSettings.proxyServer);
        MacProxyManagerUnitTest.assertEquals((String)"wrong port", (int)123, (int)networkSettings.port1);
        MacProxyManagerUnitTest.assertEquals((String)"wrong authenticated", (boolean)true, (boolean)networkSettings.authenticated);
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass length", (int)3, (int)networkSettings.bypass.length);
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass", (String)"3\thost-one\thost-two\thost-three\t", (String)networkSettings.bypassAsString());
    }

    public void testReadSettingsProxyDisabled() throws Exception {
        this.useProxyDisabledMMPM();
        MacProxyManager.MacNetworkSettings networkSettings = this.mmpm._getCurrentNetworkSettings();
        MacProxyManagerUnitTest.assertEquals((String)"wrong serviceName", (String)"foo bar", (String)networkSettings.serviceName);
        MacProxyManagerUnitTest.assertEquals((String)"wrong enabled", (boolean)false, (boolean)networkSettings.enabled);
        MacProxyManagerUnitTest.assertEquals((String)"wrong proxyServer", (String)"", (String)networkSettings.proxyServer);
        MacProxyManagerUnitTest.assertEquals((String)"wrong port", (int)80, (int)networkSettings.port1);
        MacProxyManagerUnitTest.assertEquals((String)"wrong authenticated", (boolean)false, (boolean)networkSettings.authenticated);
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass length", (int)0, (int)networkSettings.bypass.length);
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass", (String)"0\t", (String)networkSettings.bypassAsString());
    }

    private void useProxyDisabledMMPM() {
        this.mmpm = new MockableMacProxyManager("", 4444){

            protected String runNetworkSetupGetWebProxy() {
                return "cp: /Library/blah/blah/blah\nEnabled: No\nServer: \nPort: 80\nAuthenticated Proxy Enabled: 0\n";
            }

            protected String runNetworkSetupGetProxyBypassDomains() {
                return "cp: /Library/blah/blah/blah\nThere aren't any domains blah blah blah";
            }
        };
    }

    private void useBlankDomainMMPM() {
        this.mmpm = new MockableMacProxyManager("", 4444){

            protected String runNetworkSetupGetProxyBypassDomains() {
                return "cp: /Library/blah/blah/blah\n";
            }
        };
    }

    public void testReadSettingsBlankDomain() throws Exception {
        this.useBlankDomainMMPM();
        MacProxyManager.MacNetworkSettings networkSettings = this.mmpm._getCurrentNetworkSettings();
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass length", (int)1, (int)networkSettings.bypass.length);
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass", (String)"1\t\t", (String)networkSettings.bypassAsString());
    }

    public void testReadSettingsNoCpWarningBlankDomain() throws Exception {
        this.mmpm = new MockableMacProxyManager("", 4444){

            protected String runNetworkSetupGetProxyBypassDomains() {
                return "\n";
            }
        };
        MacProxyManager.MacNetworkSettings networkSettings = this.mmpm._getCurrentNetworkSettings();
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass length", (int)1, (int)networkSettings.bypass.length);
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass", (String)"1\t\t", (String)networkSettings.bypassAsString());
    }

    public void testBackupBlankDomain() throws IOException {
        this.useBlankDomainMMPM();
        this.mmpm.backupNetworkSettings();
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass", (String)"1\t\t", (String)this.mmpm.mockPrefs.internalPrefs.get("bypass"));
    }

    public void testRestoreBlankDomain() {
        this.preparePrefsProxyDisabled();
        this.mmpm.mockPrefs.put("bypass", "1\t\t");
        this.mmpm.restoreNetworkSettings();
        List<String> setwebproxy = this.assertNetworkSetupCall("-setwebproxy");
        List<String> setproxybypassdomains = this.assertNetworkSetupCall("-setproxybypassdomains");
        List<String> setwebproxystate = this.assertNetworkSetupCall("-setwebproxystate");
        this.assertStringListEquals("setwebproxy was wrong", Arrays.asList("-setwebproxy", "foo bar", "", "80"), setwebproxy);
        this.assertStringListEquals("setproxybypassdomains was wrong", Arrays.asList("-setproxybypassdomains", "foo bar", ""), setproxybypassdomains);
        this.assertStringListEquals("setwebproxystate was wrong", Arrays.asList("-setwebproxystate", "foo bar", "off"), setwebproxystate);
        MacProxyManagerUnitTest.assertEquals((String)"wrong backupready", (String)"false", (String)this.mmpm.mockPrefs.internalPrefs.get("backupready"));
    }

    public void testReadSettingsNoCpWarningProxyDisabled() throws Exception {
        this.mmpm = new MockableMacProxyManager("", 4444){

            protected String runNetworkSetupGetWebProxy() {
                return "Enabled: No\nServer: \nPort: 80\nAuthenticated Proxy Enabled: 0\n";
            }

            protected String runNetworkSetupGetProxyBypassDomains() {
                return "There aren't any domains blah blah blah";
            }
        };
        MacProxyManager.MacNetworkSettings networkSettings = this.mmpm._getCurrentNetworkSettings();
        MacProxyManagerUnitTest.assertEquals((String)"wrong serviceName", (String)"foo bar", (String)networkSettings.serviceName);
        MacProxyManagerUnitTest.assertEquals((String)"wrong enabled", (boolean)false, (boolean)networkSettings.enabled);
        MacProxyManagerUnitTest.assertEquals((String)"wrong proxyServer", (String)"", (String)networkSettings.proxyServer);
        MacProxyManagerUnitTest.assertEquals((String)"wrong port", (int)80, (int)networkSettings.port1);
        MacProxyManagerUnitTest.assertEquals((String)"wrong authenticated", (boolean)false, (boolean)networkSettings.authenticated);
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass length", (int)0, (int)networkSettings.bypass.length);
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass", (String)"0\t", (String)networkSettings.bypassAsString());
    }

    public void testReadSettingsNoCpWarningProxyEnabled() throws Exception {
        this.mmpm = new MockableMacProxyManager("", 4444){

            protected String runNetworkSetupGetWebProxy() {
                return "Enabled: Yes\nServer: foo\nPort: 123\nAuthenticated Proxy Enabled: 1\n";
            }

            protected String runNetworkSetupGetProxyBypassDomains() {
                return "host-one\nhost-two\nhost-three\n";
            }
        };
        MacProxyManager.MacNetworkSettings networkSettings = this.mmpm._getCurrentNetworkSettings();
        MacProxyManagerUnitTest.assertEquals((String)"wrong serviceName", (String)"foo bar", (String)networkSettings.serviceName);
        MacProxyManagerUnitTest.assertEquals((String)"wrong enabled", (boolean)true, (boolean)networkSettings.enabled);
        MacProxyManagerUnitTest.assertEquals((String)"wrong proxyServer", (String)"foo", (String)networkSettings.proxyServer);
        MacProxyManagerUnitTest.assertEquals((String)"wrong port", (int)123, (int)networkSettings.port1);
        MacProxyManagerUnitTest.assertEquals((String)"wrong authenticated", (boolean)true, (boolean)networkSettings.authenticated);
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass length", (int)3, (int)networkSettings.bypass.length);
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass", (String)"3\thost-one\thost-two\thost-three\t", (String)networkSettings.bypassAsString());
    }

    public void testBackupProxyEnabled() throws IOException {
        this.mmpm.backupNetworkSettings();
        MacProxyManagerUnitTest.assertEquals((String)"wrong backupready", (String)"true", (String)this.mmpm.mockPrefs.internalPrefs.get("backupready"));
        MacProxyManagerUnitTest.assertEquals((String)"wrong serviceName", (String)"foo bar", (String)this.mmpm.mockPrefs.internalPrefs.get("serviceName"));
        MacProxyManagerUnitTest.assertEquals((String)"wrong enabled", (String)"true", (String)this.mmpm.mockPrefs.internalPrefs.get("enabled"));
        MacProxyManagerUnitTest.assertEquals((String)"wrong proxyServer", (String)"foo", (String)this.mmpm.mockPrefs.internalPrefs.get("proxyServer"));
        MacProxyManagerUnitTest.assertEquals((String)"wrong port", (String)"123", (String)this.mmpm.mockPrefs.internalPrefs.get("port"));
        MacProxyManagerUnitTest.assertEquals((String)"wrong authenticated", (String)"true", (String)this.mmpm.mockPrefs.internalPrefs.get("authenticated"));
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass", (String)"3\thost-one\thost-two\thost-three\t", (String)this.mmpm.mockPrefs.internalPrefs.get("bypass"));
    }

    public void testBackupProxyDisabled() throws IOException {
        this.useProxyDisabledMMPM();
        this.mmpm.backupNetworkSettings();
        MacProxyManagerUnitTest.assertEquals((String)"wrong backupready", (String)"true", (String)this.mmpm.mockPrefs.internalPrefs.get("backupready"));
        MacProxyManagerUnitTest.assertEquals((String)"wrong serviceName", (String)"foo bar", (String)this.mmpm.mockPrefs.internalPrefs.get("serviceName"));
        MacProxyManagerUnitTest.assertEquals((String)"wrong enabled", (String)"false", (String)this.mmpm.mockPrefs.internalPrefs.get("enabled"));
        MacProxyManagerUnitTest.assertEquals((String)"wrong proxyServer", (String)"", (String)this.mmpm.mockPrefs.internalPrefs.get("proxyServer"));
        MacProxyManagerUnitTest.assertEquals((String)"wrong port", (String)"80", (String)this.mmpm.mockPrefs.internalPrefs.get("port"));
        MacProxyManagerUnitTest.assertEquals((String)"wrong authenticated", (String)"false", (String)this.mmpm.mockPrefs.internalPrefs.get("authenticated"));
        MacProxyManagerUnitTest.assertEquals((String)"wrong bypass", (String)"0\t", (String)this.mmpm.mockPrefs.internalPrefs.get("bypass"));
    }

    public void testChange() throws Exception {
        this.mmpm.changeNetworkSettings();
        List<String> setwebproxy = this.assertNetworkSetupCall("-setwebproxy");
        List<String> setproxybypassdomains = this.assertNetworkSetupCall("-setproxybypassdomains");
        this.assertStringListEquals("setwebproxy was wrong", Arrays.asList("-setwebproxy", "foo bar", "localhost", "4444"), setwebproxy);
        this.assertStringListEquals("setproxybypassdomains was wrong", Arrays.asList("-setproxybypassdomains", "foo bar", "Empty"), setproxybypassdomains);
    }

    public void testRestoreProxyEnabled() {
        this.mmpm.mockPrefs.put("backupready", "true");
        this.mmpm.mockPrefs.put("serviceName", "foo bar");
        this.mmpm.mockPrefs.put("enabled", "true");
        this.mmpm.mockPrefs.put("proxyServer", "foo");
        this.mmpm.mockPrefs.put("port", "123");
        this.mmpm.mockPrefs.put("authenticated", "true");
        this.mmpm.mockPrefs.put("bypass", "3\thost-one\thost-two\thost-three\t");
        this.mmpm.restoreNetworkSettings();
        List<String> setwebproxy = this.assertNetworkSetupCall("-setwebproxy");
        List<String> setproxybypassdomains = this.assertNetworkSetupCall("-setproxybypassdomains");
        List<String> setwebproxystate = this.assertNetworkSetupCall("-setwebproxystate");
        this.assertStringListEquals("setwebproxy was wrong", Arrays.asList("-setwebproxy", "foo bar", "foo", "123"), setwebproxy);
        this.assertStringListEquals("setproxybypassdomains was wrong", Arrays.asList("-setproxybypassdomains", "foo bar", "host-one", "host-two", "host-three"), setproxybypassdomains);
        this.assertStringListEquals("setwebproxystate was wrong", Arrays.asList("-setwebproxystate", "foo bar", "on"), setwebproxystate);
        MacProxyManagerUnitTest.assertEquals((String)"wrong backupready", (String)"false", (String)this.mmpm.mockPrefs.internalPrefs.get("backupready"));
    }

    public void testRestoreProxyDisabled() {
        this.preparePrefsProxyDisabled();
        this.mmpm.restoreNetworkSettings();
        List<String> setwebproxy = this.assertNetworkSetupCall("-setwebproxy");
        List<String> setproxybypassdomains = this.assertNetworkSetupCall("-setproxybypassdomains");
        List<String> setwebproxystate = this.assertNetworkSetupCall("-setwebproxystate");
        this.assertStringListEquals("setwebproxy was wrong", Arrays.asList("-setwebproxy", "foo bar", "", "80"), setwebproxy);
        this.assertStringListEquals("setproxybypassdomains was wrong", Arrays.asList("-setproxybypassdomains", "foo bar", "Empty"), setproxybypassdomains);
        this.assertStringListEquals("setwebproxystate was wrong", Arrays.asList("-setwebproxystate", "foo bar", "off"), setwebproxystate);
        MacProxyManagerUnitTest.assertEquals((String)"wrong backupready", (String)"false", (String)this.mmpm.mockPrefs.internalPrefs.get("backupready"));
    }

    private void preparePrefsProxyDisabled() {
        this.mmpm.mockPrefs.put("backupready", "true");
        this.mmpm.mockPrefs.put("serviceName", "foo bar");
        this.mmpm.mockPrefs.put("enabled", "false");
        this.mmpm.mockPrefs.put("proxyServer", "");
        this.mmpm.mockPrefs.put("port", "80");
        this.mmpm.mockPrefs.put("authenticated", "false");
        this.mmpm.mockPrefs.put("bypass", "0\t");
    }

    public void testRestoreBackupNotReady() {
        this.mmpm.restoreNetworkSettings();
        MacProxyManagerUnitTest.assertTrue((String)("Not supposed to call networksetup when the backup isn't ready: " + this.mmpm.networkSetupCalls), (this.mmpm.networkSetupCalls.size() == 0 ? 1 : 0) != 0);
        MacProxyManagerUnitTest.assertEquals((String)"wrong backupready", null, (String)this.mmpm.mockPrefs.internalPrefs.get("backupready"));
    }

    public void testRestoreAfterBackupProxyDisabled() throws Exception {
        this.testBackupProxyDisabled();
        this.testChange();
        this.mmpm.networkSetupCalls.clear();
        this.mmpm.restoreNetworkSettings();
        List<String> setwebproxy = this.assertNetworkSetupCall("-setwebproxy");
        List<String> setproxybypassdomains = this.assertNetworkSetupCall("-setproxybypassdomains");
        List<String> setwebproxystate = this.assertNetworkSetupCall("-setwebproxystate");
        this.assertStringListEquals("setwebproxy was wrong", Arrays.asList("-setwebproxy", "foo bar", "", "80"), setwebproxy);
        this.assertStringListEquals("setproxybypassdomains was wrong", Arrays.asList("-setproxybypassdomains", "foo bar", "Empty"), setproxybypassdomains);
        this.assertStringListEquals("setwebproxystate was wrong", Arrays.asList("-setwebproxystate", "foo bar", "off"), setwebproxystate);
        MacProxyManagerUnitTest.assertEquals((String)"wrong backupready", (String)"false", (String)this.mmpm.mockPrefs.internalPrefs.get("backupready"));
    }

    public void testRestoreAfterBackupProxyEnabled() throws Exception {
        this.testBackupProxyEnabled();
        this.testChange();
        this.mmpm.networkSetupCalls.clear();
        this.mmpm.restoreNetworkSettings();
        List<String> setwebproxy = this.assertNetworkSetupCall("-setwebproxy");
        List<String> setproxybypassdomains = this.assertNetworkSetupCall("-setproxybypassdomains");
        List<String> setwebproxystate = this.assertNetworkSetupCall("-setwebproxystate");
        this.assertStringListEquals("setwebproxy was wrong", Arrays.asList("-setwebproxy", "foo bar", "foo", "123"), setwebproxy);
        this.assertStringListEquals("setproxybypassdomains was wrong", Arrays.asList("-setproxybypassdomains", "foo bar", "host-one", "host-two", "host-three"), setproxybypassdomains);
        this.assertStringListEquals("setwebproxystate was wrong", Arrays.asList("-setwebproxystate", "foo bar", "on"), setwebproxystate);
        MacProxyManagerUnitTest.assertEquals((String)"wrong backupready", (String)"false", (String)this.mmpm.mockPrefs.internalPrefs.get("backupready"));
    }

    public void testEvilScutilState() throws Exception {
        this.mmpm = new MockableMacProxyManager("", 4444){

            protected String runScutil(String arg) {
                if (arg.contains("State:/Network/Global/IPv4")) {
                    return "<dictionary> {\n  Foo : 666\n}";
                }
                throw new RuntimeException("Not mocked!");
            }
        };
        try {
            this.mmpm._getCurrentNetworkSettings();
            MacProxyManagerUnitTest.fail((String)"Didn't get expected exception");
        }
        catch (MacProxyManager.MacNetworkSetupException e) {
            this.assertExceptionContains("Unhelpful exception message", "PrimaryInterface", (Exception)((Object)e));
        }
    }

    private void assertExceptionContains(String message, String substring, Exception e) {
        String stack = this.exceptionToString(e);
        if (!stack.contains(substring)) {
            MacProxyManagerUnitTest.fail((String)(message + "; expected containing <" + substring + ">, was " + stack));
        }
    }

    private String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public void testEvilNetworkSetupMissingInterface() throws Exception {
        this.mmpm = new MockableMacProxyManager("", 4444){

            protected String runNetworkSetupListNetworkServiceOrder() {
                return "cp: /Library/blah/blah/blah\n(Hardware Port: Foo Bar, Device: foo)\n";
            }
        };
        try {
            this.mmpm._getCurrentNetworkSettings();
            MacProxyManagerUnitTest.fail((String)"Didn't get expected exception");
        }
        catch (MacProxyManager.MacNetworkSetupException e) {
            this.assertExceptionContains("Unhelpful exception message", "en0", (Exception)((Object)e));
        }
    }

    public void testEvilPrefsMissingKey() {
        this.mmpm.mockPrefs.put("backupready", "true");
        try {
            this.mmpm.restoreNetworkSettings();
            MacProxyManagerUnitTest.fail((String)"Didn't see expected exception");
        }
        catch (RuntimeException e) {
            this.assertExceptionContains("Unhelpful exception message", "serviceName", e);
        }
    }

    public void testEvilPrefsBadEncodedDomains() {
        this.verifyEvilPrefsBadEncodedDomains("foo");
        this.verifyEvilPrefsBadEncodedDomains("4");
        this.verifyEvilPrefsBadEncodedDomains("4\tfoo");
    }

    public void verifyEvilPrefsBadEncodedDomains(String strBypass) {
        this.preparePrefsProxyDisabled();
        this.mmpm.mockPrefs.put("bypass", strBypass);
        try {
            this.mmpm.restoreNetworkSettings();
            MacProxyManagerUnitTest.fail((String)"Didn't see expected exception");
        }
        catch (RuntimeException e) {
            this.assertExceptionContains("Unhelpful exception message", strBypass, e);
        }
    }

    public void testEvilNetworkSetupBadPort() throws Exception {
        this.mmpm = new MockableMacProxyManager("", 4444){

            protected String runNetworkSetupGetWebProxy() {
                return "Enabled: No\nServer: \nPort: Foo\nAuthenticated Proxy Enabled: 0\n";
            }
        };
        try {
            this.mmpm._getCurrentNetworkSettings();
            MacProxyManagerUnitTest.fail((String)"Didn't see expected exception");
        }
        catch (MacProxyManager.MacNetworkSetupException e) {
            this.assertExceptionContains("Unhelpful exception message", "Port didn't look right", (Exception)((Object)e));
        }
    }

    public void testEvilNetworkSetupMissingKey() throws Exception {
        this.mmpm = new MockableMacProxyManager("", 4444){

            protected String runNetworkSetupGetWebProxy() {
                return "Foo: No\nBar: \nBaz: 80\nAuthenticated Xyzzy Enabled: 0\n";
            }
        };
        try {
            this.mmpm._getCurrentNetworkSettings();
            MacProxyManagerUnitTest.fail((String)"Didn't see expected exception");
        }
        catch (RuntimeException e) {
            this.assertExceptionContains("Unhelpful exception message", "Enabled", e);
            this.assertExceptionContains("Unhelpful exception message", "Xyzzy", e);
        }
    }

    public void testChooseSuitableNetworkSetupNoCandidates() throws Exception {
        String result = this.mmpm._chooseSuitableNetworkSetup("", "", "foo", "bar");
        MacProxyManagerUnitTest.assertNull((String)"Should not have picked a candidate", (Object)result);
    }

    public void testChooseSuitableNetworkSetupOneCandidate() throws Exception {
        String result = this.mmpm._chooseSuitableNetworkSetup("", "", "foo", "networksetup-bar");
        MacProxyManagerUnitTest.assertEquals((String)"Should have picked the only candidate", (String)"networksetup-bar", (String)result);
    }

    public void testChooseSuitableNetworkSetupEvilOsVersion() throws Exception {
        String result = this.mmpm._chooseSuitableNetworkSetup("", "", "networksetup-foo", "networksetup-bar");
        MacProxyManagerUnitTest.assertNull((String)"Should not have picked a candidate; OS version was blank", (Object)result);
        result = this.mmpm._chooseSuitableNetworkSetup("12.8", "", "networksetup-foo", "networksetup-bar");
        MacProxyManagerUnitTest.assertNull((String)"Should not have picked a candidate; OS version was 12.8", (Object)result);
        result = this.mmpm._chooseSuitableNetworkSetup("10.8", "", "networksetup-foo", "networksetup-bar");
        MacProxyManagerUnitTest.assertNull((String)"Should not have picked a candidate; OS version was 10.8 (unrecognized)", (Object)result);
    }

    public void testChooseSuitableNetworkSetupPanther() throws Exception {
        String result = this.mmpm._chooseSuitableNetworkSetup("10.3", "", "networksetup-foo", "networksetup-panther");
        MacProxyManagerUnitTest.assertEquals((String)"Wrong candidate", (String)"networksetup-panther", (String)result);
    }

    public void testChooseSuitableNetworkSetupEvilPantherButNoneSuitable() throws Exception {
        String result = this.mmpm._chooseSuitableNetworkSetup("10.3", "", "networksetup-foo", "networksetup-bar");
        MacProxyManagerUnitTest.assertNull((String)"Should not have picked a candidate", (Object)result);
    }

    private List<String> assertNetworkSetupCall(String command) {
        for (List<String> call : this.mmpm.networkSetupCalls) {
            MacProxyManagerUnitTest.assertTrue((String)"called networksetup with no arguments", (call.size() > 0 ? 1 : 0) != 0);
            if (!command.equals(call.get(0))) continue;
            return call;
        }
        MacProxyManagerUnitTest.fail((String)("No networksetup call used " + command + "; " + this.mmpm.networkSetupCalls));
        return null;
    }

    private void assertStringListEquals(String message, List<String> expected, List<String> actual) {
        if (expected == null) {
            MacProxyManagerUnitTest.assertNull((String)message, actual);
            return;
        }
        if (actual == null) {
            MacProxyManagerUnitTest.assertNotNull((String)message, actual);
        }
        if (expected.size() != actual.size()) {
            MacProxyManagerUnitTest.assertEquals((String)(message + "; size didn't match, expected <" + expected.toString() + "> but was <" + actual.toString() + ">"), (int)expected.size(), (int)actual.size());
        }
        for (int i = 0; i < expected.size(); ++i) {
            MacProxyManagerUnitTest.assertEquals((String)(message + "; item " + i + " didn't match"), (String)expected.get(i), (String)actual.get(i));
        }
    }

    private static class MockPreferences
    extends AbstractPreferences {
        Map<String, String> internalPrefs = new HashMap<String, String>();

        protected MockPreferences() {
            super(null, "");
        }

        protected String getSpi(String key) {
            return this.internalPrefs.get(key);
        }

        protected void putSpi(String key, String value) {
            this.internalPrefs.put(key, value);
        }

        protected AbstractPreferences childSpi(String name) {
            return null;
        }

        protected String[] childrenNamesSpi() throws BackingStoreException {
            return null;
        }

        protected String[] keysSpi() throws BackingStoreException {
            return null;
        }

        protected void flushSpi() throws BackingStoreException {
        }

        protected void removeNodeSpi() throws BackingStoreException {
        }

        protected void removeSpi(String key) {
        }

        protected void syncSpi() throws BackingStoreException {
        }
    }

    private static class MockableMacProxyManager
    extends MacProxyManager {
        List<List<String>> networkSetupCalls = new ArrayList<List<String>>();
        MockPreferences mockPrefs;

        public MockableMacProxyManager(String sessionId, int port) {
            super(sessionId, port);
            try {
                this.replacePrefs();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void replacePrefs() throws Exception {
            Field prefs = MacProxyManager.class.getDeclaredField("prefs");
            prefs.setAccessible(true);
            this.mockPrefs = new MockPreferences();
            prefs.set((Object)this, this.mockPrefs);
        }

        protected String runNetworkSetup(String ... args) {
            this.networkSetupCalls.add(Arrays.asList(args));
            if (args[0].startsWith("-set")) {
                return null;
            }
            if ("-listnetworkserviceorder".equals(args[0])) {
                return this.runNetworkSetupListNetworkServiceOrder();
            }
            if ("-getwebproxy".equals(args[0])) {
                return this.runNetworkSetupGetWebProxy();
            }
            if ("-getproxybypassdomains".equals(args[0])) {
                return this.runNetworkSetupGetProxyBypassDomains();
            }
            throw new RuntimeException("not mocked! " + Arrays.toString(args));
        }

        protected String runNetworkSetupListNetworkServiceOrder() {
            return "cp: /Library/blah/blah/blah\n(Hardware Port: foo bar, Device: en0)\n";
        }

        protected String runNetworkSetupGetWebProxy() {
            return "cp: /Library/blah/blah/blah\nEnabled: Yes\nServer: foo\nPort: 123\nAuthenticated Proxy Enabled: 1\n";
        }

        protected String runNetworkSetupGetProxyBypassDomains() {
            return "cp: /Library/blah/blah/blah\nhost-one\nhost-two\nhost-three";
        }

        protected String runScutil(String arg) {
            if (arg.contains("State:/Network/Global/IPv4")) {
                return "<dictionary> {\n  PrimaryInterface : en0\n}";
            }
            throw new RuntimeException("Not mocked!");
        }

        protected String _chooseSuitableNetworkSetup(String osVersion, String osArch, String ... files) throws Exception {
            Method cSNS = MacProxyManager.class.getDeclaredMethod("chooseSuitableNetworkSetup", String.class, String.class, files.getClass());
            cSNS.setAccessible(true);
            try {
                return (String)cSNS.invoke((Object)this, osVersion, osArch, files);
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof Exception) {
                    throw (Exception)ite.getCause();
                }
                throw ite;
            }
        }

        protected MacProxyManager.MacNetworkSettings _getCurrentNetworkSettings() throws Exception {
            Method gCNS = MacProxyManager.class.getDeclaredMethod("getCurrentNetworkSettings", new Class[0]);
            gCNS.setAccessible(true);
            try {
                return (MacProxyManager.MacNetworkSettings)gCNS.invoke((Object)this, new Object[0]);
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof Exception) {
                    throw (Exception)ite.getCause();
                }
                throw ite;
            }
        }
    }
}

