/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.mock;

import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.mock.BrowserRequest;

public class MockPIFrame {
    static Log log = LogFactory.getLog(MockPIFrame.class);
    final String driverUrl;
    final String sessionId;
    final String uniqueId;
    String localFrameAddress;
    String seleniumWindowName;
    BrowserRequest mostRecentRequest;
    int sequenceNumber;

    public MockPIFrame(String driverUrl, String sessionId, String uniqueId) {
        this(driverUrl, sessionId, uniqueId, "top", "");
    }

    public MockPIFrame(String driverUrl, String sessionId, String uniqueId, String localFrameAddress, String seleniumWindowName) {
        this.driverUrl = driverUrl;
        this.sessionId = sessionId;
        this.uniqueId = uniqueId;
        this.localFrameAddress = localFrameAddress;
        this.seleniumWindowName = seleniumWindowName;
    }

    public BrowserRequest seleniumStart() {
        log.info((Object)(this.uniqueId + " sends START"));
        this.mostRecentRequest = BrowserRequest.request(this.getUrl() + "&seleniumStart=true", "START");
        return this.mostRecentRequest;
    }

    private String getUrl() {
        return this.driverUrl + '?' + "sessionId=" + this.sessionId + "&uniqueId=" + this.uniqueId + "&localFrameAddress=" + this.localFrameAddress + "&seleniumWindowName=" + this.seleniumWindowName + "&sequenceNumber=" + this.sequenceNumber++;
    }

    public BrowserRequest sendResult(String body) {
        log.info((Object)(this.uniqueId + " sends " + body));
        this.mostRecentRequest = BrowserRequest.request(this.getUrl(), body);
        return this.mostRecentRequest;
    }

    public BrowserRequest sendClose() {
        log.info((Object)(this.uniqueId + "sends close"));
        this.mostRecentRequest = BrowserRequest.request(this.getUrl() + "&closing=true", "Current window or frame is closed!");
        return this.mostRecentRequest;
    }

    public RemoteCommand expectCommand(String cmd, String arg1, String arg2) {
        return this.mostRecentRequest.expectCommand(cmd, arg1, arg2);
    }

    public BrowserRequest sendRetry() {
        log.info((Object)(this.uniqueId + "sends retry"));
        this.mostRecentRequest = BrowserRequest.request(this.getUrl() + "&retry=true", "RETRY");
        return this.mostRecentRequest;
    }

    public boolean frameMatchesFrameExpression(RemoteCommand identifyCommand) {
        if (!"getWhetherThisFrameMatchFrameExpression".equals(identifyCommand.getCommand())) {
            Assert.fail((String)("this isn't a frame expression: " + identifyCommand));
        }
        if ("top".equals(this.localFrameAddress) && this.localFrameAddress.equals(identifyCommand.getField()) && this.localFrameAddress.equals(identifyCommand.getValue())) {
            return true;
        }
        Assert.fail((String)("I'm just a mock; I can't tell whether my frame expression <" + this.seleniumWindowName + ':' + this.localFrameAddress + "> matches: " + identifyCommand));
        throw new RuntimeException("unreachable; fail() will throw");
    }

    public BrowserRequest getMostRecentRequest() {
        return this.mostRecentRequest;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }
}

