//trac 横断検索 0.2
$(function (){
    var base_url = "/trac/"; //環境に合わせて変更してください
    var trac_wiki = new Array("CamelCase",  "InterMapTxt",  "InterTrac",  "InterWiki",  "RecentChanges",  "SandBox",  "TitleIndex",  "TracAccessibility",  "TracAdmin",  "TracBackup",  "TracBrowser",  "TracCgi",  "TracChangeset",  "TracEnvironment",  "TracFastCgi",  "TracGuide",  "TracImport",  "TracIni",  "TracInstall",  "TracInterfaceCustomization",  "TracJa",  "TracLinks",  "TracLogging",  "TracModPython",  "TracNotification",  "TracPermissions",  "TracPlugins",  "TracQuery",  "TracReports",  "TracRevisionLog",  "TracRoadmap",  "TracRss",  "TracSearch",  "TracStandalone",  "TracSupport",  "TracSyntaxColoring",  "TracTermsJa",  "TracTickets",  "TracTicketsCustomFields",  "TracTimeline",  "TracUnicode",  "TracUpgrade",  "TracWiki",  "WikiDeletePage",  "WikiFormatting",  "WikiHtml",  "WikiMacros",  "WikiNewPage",  "WikiPageNames",  "WikiProcessors",  "WikiRestructuredText",  "WikiRestructuredTextLinks" ,"checkwiki.py");
    var split_count = 0;
    var pos = base_url.indexOf("/");
    while ( pos != -1 ) {
       split_count++;
       pos = base_url.indexOf("/",pos+1);
    }
    split_count = split_count + 2;
    
    var check_attribute = function(key) {
        return $( "#" + key ).attr("checked")? "&" + key + "=on": "";
    }


    $("span#loading").hide();
    $("span#loading").ajaxStart(function(){ $(this).show(); });
    $("span#loading").ajaxStop(function(){ $(this).hide(); });

    $("span#search_title").hide();
    $("span#search_title2").hide();

    var projects = new Object();
    var retrieve_projects = function(data, status) {
        var temp_elem = $(document.createElement("div"));
        temp_elem.html(data);
        var a_elem = $("a",temp_elem);

        var select_elem = $("#projects");
        var navi_elem = $("#mainnav");
        var count = 0
        var ul_elem = $( document.createElement("ul") );
        var pns = new Array();
        a_elem.each(function(){
            var pi = $(this).href().indexOf(base_url);
            if (pi < 0) {
                return;
            }
            var pn = $(this).href().substr(pi + base_url.length);
            if (pn.indexOf("/") > 0) {
                return;
            }
            var n;
            for (n in pns) {
                if (pns[n] == pn) {
                    return;
                }
            }
            pns.push(pn);

            var href_attr = $(this).href().split("/")[split_count];
            projects[ href_attr ] = { pj_name:href_attr, pj_title:$(this).text(), pj_url:$(this).href() };
            var option_elem = $( document.createElement("option") );
            option_elem.html( $(this).text() );
            option_elem.val( href_attr );
            option_elem.addClass( "project" );
            select_elem.append( option_elem );
            var li_elem = $( document.createElement("li") );
            var li_a_elem = $(document.createElement("a"));
            li_a_elem.html( href_attr );
            li_a_elem.title($(this).text() + "\n　　"+ this.title );
            li_a_elem.href(this.href);
            count = count +1;
            if (a_elem.length == count){
                li_a_elem.addClass( "last" );
            }
            li_elem.append( li_a_elem );
            ul_elem.append( li_elem );
        });
       navi_elem.append( ul_elem );
    }
    $.get(base_url, retrieve_projects );

    var search_into_project = function(project) {
        return function(data, status) {
            var temp_elem = $(document.createElement("div"));
            temp_elem.html(data);

            //TracのDefaultのwikiの除外E
            if (check_attribute("remove_trac")) {
				var remove_count = 0;
                $("dl#results dt", temp_elem).each(function() {
                    trac_flg = false;
                    temp_text = $(this).text();
                    $.each(trac_wiki, function( i ) {
                        if (temp_text.match(new RegExp("^" + trac_wiki[i] + ":")) != undefined) {
                            trac_flg = true;
							remove_count++;
                        }
                    });
                    if (trac_flg) {
                        $(this).next().remove();
                        $(this).next().remove();
                        $(this).remove();
                    }

                });
            }

            var res_elem = $("div#results",temp_elem);
            $("a", res_elem).attr("target", "_blank");

            var res_area_elem = $(document.createElement("div"));
            res_area_elem.addClass("indiv_result"); 
            $("div#search_result").append( res_area_elem );

            var h3_elem = $(document.createElement("h3"));
            var h3m_elem = $(document.createElement("h3"));
            var a_elem = $(document.createElement("a"));
            a_elem.html(project.pj_title);
            a_elem.href(project.pj_url);
            a_elem.attr("target", "_blank");
            h3_elem.append(a_elem);

            var a2_elem = $(document.createElement("a"));
            h3_elem.append("&nbsp;&nbsp;&nbsp;");
            a2_elem.html("[&nbsp;詳細検索&nbsp;]");
            a2_elem.href(this.url);
            a2_elem.attr("target", "_blank");
            h3_elem.append(a2_elem);
            if ($("div#paging", temp_elem).text()!="") {
                h3_elem.append("&nbsp;&nbsp;&nbsp;&nbsp;検索結果が10件を超えています。");
            }

            
            res_area_elem.append( h3_elem );
            if (res_elem.size() == 0) { 
                res_area_elem.append( "検索条件にマッチするものが見つかりません..." );
                res_area_elem.append("<HR>");
            } else {
				if (remove_count >= 10) {
	                res_area_elem.append( "1ページ目が全てtracのDefault wikiでした...詳細検索で結果を確認してください。" );
       	            res_area_elem.append("<HR>");
				} else {
	                res_area_elem.append( res_elem );
	            }
            }       
        }       
    }

    $("#whole_search").click(function(){
        $("div#search_result").empty();
        var elem_selected = false;
        var project_elems = $("option.project");
        $.each( project_elems, function ( i ) { 
                if (this.selected) {
                    elem_selected = true; 
                    var req_url = base_url + projects[ this.value ].pj_name + "/search?q=" + encodeURIComponent($( "#q" ).val()) + check_attribute("wiki") + check_attribute( "discussion" ) + check_attribute( "changeset" ) + check_attribute( "ticket" );
                    $.get( req_url, search_into_project( projects[ this.value ] ) );
                }
            }
        );
        if (!elem_selected) {
            $.each( projects, function( i ) {
                    var req_url = base_url + this.pj_name + "/search?q=" + encodeURIComponent($( "#q" ).val()) + check_attribute("wiki") + check_attribute( "discussion" ) + check_attribute( "changeset" ) + check_attribute( "ticket" );
                    $.get( req_url, search_into_project(this) );
                }
            );
        }
        $("span#search_title").show();
        $("span#search_title2").show();
    });
});
