/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.locators.Firefox2or3Locator;

public class FirefoxCustomProfileLauncher
extends AbstractBrowserLauncher {
    private static final Log LOGGER = LogFactory.getLog(FirefoxCustomProfileLauncher.class);
    private static boolean simple = false;
    private String[] cmdarray;
    private boolean closed = false;
    private BrowserInstallation browserInstallation;
    private Process process;
    protected LauncherUtils.ProxySetting proxySetting = LauncherUtils.ProxySetting.PROXY_SELENIUM_TRAFFIC_ONLY;
    private static boolean alwaysChangeMaxConnections = false;
    protected boolean changeMaxConnections = alwaysChangeMaxConnections;
    private static AsyncExecute exe = new AsyncExecute();
    private File customProfileDir;

    public FirefoxCustomProfileLauncher(RemoteControlConfiguration configuration, String sessionId) {
        this(configuration, sessionId, (String)null);
    }

    public FirefoxCustomProfileLauncher(RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        this(configuration, sessionId, ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation("firefox", browserLaunchLocation, new Firefox2or3Locator()));
    }

    public FirefoxCustomProfileLauncher(RemoteControlConfiguration configuration, String sessionId, BrowserInstallation browserInstallation) {
        super(sessionId, configuration);
        this.init();
        this.browserInstallation = browserInstallation;
        exe.setLibraryPath(browserInstallation.libraryPath());
        exe.setEnvironmentVariable("MOZ_NO_REMOTE", "1");
    }

    protected void init() {
    }

    protected void launch(String url) {
        try {
            LOGGER.debug((Object)("customProfileDir = " + this.customProfileDir()));
            this.makeCustomProfile(this.customProfileDir());
            String chromeURL = "chrome://killff/content/kill.html";
            this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), "-profile", this.customProfileDir().getAbsolutePath(), "-chrome", chromeURL};
            LOGGER.info((Object)"Preparing Firefox profile...");
            exe.setCommandline(this.cmdarray);
            exe.execute();
            this.waitForFullProfileToBeCreated(20000L);
            LOGGER.info((Object)"Launching Firefox...");
            this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), "-profile", this.customProfileDir().getAbsolutePath(), url};
            exe.setCommandline(this.cmdarray);
            this.process = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void makeCustomProfile(File customProfileDirectory) throws IOException {
        if (simple) {
            return;
        }
        File firefoxProfileTemplate = this.getConfiguration().getFirefoxProfileTemplate();
        if (firefoxProfileTemplate != null) {
            LauncherUtils.copyDirectory(firefoxProfileTemplate, this.customProfileDir);
        }
        ResourceExtractor.extractResourcePath(this.getClass(), "/customProfileDirCUSTFF", this.customProfileDir);
        LauncherUtils.generatePacAndPrefJs(customProfileDirectory, this.getPort(), this.proxySetting, null, this.changeMaxConnections, this.getConfiguration());
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.process == null) {
            return;
        }
        LOGGER.info((Object)"Killing Firefox...");
        Throwable taskKillException = null;
        FileLockRemainedException fileLockException = null;
        int exitValue = AsyncExecute.killProcess(this.process);
        if (exitValue == 0) {
            LOGGER.warn((Object)"Firefox seems to have ended on its own (did we kill the real browser???)");
        }
        try {
            this.waitForFileLockToGoAway(0L, 500L);
        }
        catch (FileLockRemainedException e1) {
            fileLockException = e1;
        }
        try {
            LauncherUtils.deleteTryTryAgain(this.customProfileDir(), 6);
        }
        catch (RuntimeException e) {
            if (taskKillException != null || fileLockException != null) {
                LOGGER.error((Object)"Couldn't delete custom Firefox profile directory", (Throwable)e);
                LOGGER.error((Object)"Perhaps caused by this exception:");
                if (taskKillException != null) {
                    LOGGER.error((Object)"Perhaps caused by this exception:", taskKillException);
                }
                if (fileLockException != null) {
                    LOGGER.error((Object)"Perhaps caused by this exception:", (Throwable)fileLockException);
                }
                throw new RuntimeException("Couldn't delete custom Firefox profile directory, presumably because task kill failed; see error log!", e);
            }
            throw e;
        }
        this.closed = true;
    }

    public Process getProcess() {
        return this.process;
    }

    private File customProfileDir() {
        if (this.customProfileDir == null) {
            this.customProfileDir = LauncherUtils.createCustomProfileDir(this.sessionId);
        }
        return this.customProfileDir;
    }

    private void waitForFileLockToGoAway(long timeout, long timeToWait) throws FileLockRemainedException {
        File lock = new File(this.customProfileDir(), "parent.lock");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (lock.exists() || !this.makeSureFileLockRemainsGone(lock, timeToWait)) continue;
            return;
        }
        if (lock.exists()) {
            throw new FileLockRemainedException("Lock file still present! " + lock.getAbsolutePath());
        }
    }

    private boolean makeSureFileLockRemainsGone(File lock, long timeToWait) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            AsyncExecute.sleepTight(500L);
            if (!lock.exists()) continue;
            return false;
        }
        return !lock.exists();
    }

    private void waitForFullProfileToBeCreated(long timeout) {
        File testFile = new File(this.customProfileDir(), "extensions.ini");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (!testFile.exists()) continue;
        }
        if (!testFile.exists()) {
            throw new RuntimeException("Timed out waiting for profile to be created!");
        }
        long subTimeout = timeout - (System.currentTimeMillis() - start);
        try {
            this.waitForFileLockToGoAway(subTimeout, 500L);
        }
        catch (FileLockRemainedException e) {
            throw new RuntimeException("Firefox refused shutdown while preparing a profile", e);
        }
    }

    public static void setChangeMaxConnections(boolean changeMaxConnections) {
        alwaysChangeMaxConnections = changeMaxConnections;
    }

    private class FileLockRemainedException
    extends Exception {
        FileLockRemainedException(String message) {
            super(message);
        }
    }
}

