/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.util.FileUtils;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.SafariCustomProfileLauncher;

public class SafariFileBasedLauncher
extends SafariCustomProfileLauncher {
    public SafariFileBasedLauncher(RemoteControlConfiguration configuration, String sessionId) {
        super(configuration, sessionId);
    }

    public SafariFileBasedLauncher(RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        super(configuration, sessionId, browserLaunchLocation);
    }

    public SafariFileBasedLauncher(RemoteControlConfiguration configuration, String sessionId, BrowserInstallation browserInstallation) {
        super(configuration, sessionId, browserInstallation);
    }

    protected void launch(String url) {
        String query = LauncherUtils.getQueryString(url);
        query = query + "&driverUrl=http://localhost:" + this.getPort() + "/selenium-server/driver/";
        try {
            if (SeleniumServer.isEnsureCleanSession()) {
                this.ensureCleanSession();
            }
            String fileUrl = this.createExtractedFiles().toURL() + "?" + query;
            this.cmdarray = new String[]{this.browserInstallation.launcherFilePath()};
            if (Os.isFamily("mac")) {
                String redirectHtmlFileName = this.makeRedirectionHtml(this.customProfileDir, fileUrl);
                this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), redirectHtmlFileName};
            } else {
                this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), "-url", fileUrl};
            }
            log.info("Launching Safari...");
            exe.setCommandline(this.cmdarray);
            this.process = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File createExtractedFiles() {
        File dir = this.customProfileDir;
        File coreDir = new File(dir, "core");
        try {
            coreDir.mkdirs();
            ResourceExtractor.extractResourcePath(SafariFileBasedLauncher.class, "/core", coreDir);
            FileUtils f = FileUtils.getFileUtils();
            File userExt = this.getConfiguration().getUserExtensions();
            if (userExt != null) {
                File selUserExt = new File(coreDir, "scripts/user-extensions.js");
                f.copyFile(userExt, selUserExt, null, true);
            }
            return new File(coreDir, "RemoteRunner.html");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

