/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import junit.framework.TestCase;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.util.Resource;
import org.openqa.selenium.server.ResourceLocator;
import org.openqa.selenium.server.StaticContentHandler;

public class StaticContentHandlerUnitTest
extends TestCase {
    private StaticContentHandler handler;
    private boolean slowResourcesInitially;

    public void setUp() throws Exception {
        super.setUp();
        this.handler = new StaticContentHandler("");
        this.slowResourcesInitially = StaticContentHandler.getSlowResources();
    }

    public void tearDown() {
        StaticContentHandler.setSlowResources((boolean)this.slowResourcesInitially);
    }

    public void testShouldMakePageNotCachedWhenHandle() throws Exception {
        HttpResponse response = new HttpResponse();
        this.handler.handle("", "", new HttpRequest(), response);
        StaticContentHandlerUnitTest.assertEquals((String)"Thu, 01 Jan 1970 00:00:00 GMT", (String)response.getField("Expires"));
    }

    public void testShouldDelayResourceLoadingIfSetToSlow() throws Exception {
        long start = new Date().getTime();
        StaticContentHandler.setSlowResources((boolean)true);
        this.handler.getResource("not_exists");
        long end = new Date().getTime();
        StaticContentHandlerUnitTest.assertTrue(((double)(end - start) >= 900.0 ? 1 : 0) != 0);
    }

    public void testShouldDoubleDelayWithAPageMarkedAsSlow() throws Exception {
        long start = new Date().getTime();
        StaticContentHandler.setSlowResources((boolean)true);
        this.handler.getResource("something-really-slow.html");
        long end = new Date().getTime();
        long diff = end - start;
        System.out.println("diff = " + diff);
        StaticContentHandlerUnitTest.assertTrue(((double)(end - start) >= 1900.0 ? 1 : 0) != 0);
    }

    public void testShouldReturnTheFirstResourceLocatedByLocators() throws Exception {
        final File file = File.createTempFile("selenium-test-", "");
        file.deleteOnExit();
        this.handler.addStaticContent(new ResourceLocator(){

            public Resource getResource(HttpContext context, String pathInContext) throws IOException {
                return Resource.newResource((String)"Missing");
            }
        });
        this.handler.addStaticContent(new ResourceLocator(){

            public Resource getResource(HttpContext context, String pathInContext) throws IOException {
                return Resource.newResource((URL)file.toURI().toURL());
            }
        });
        StaticContentHandlerUnitTest.assertEquals((Object)file, (Object)this.handler.getResource(file.toURI().toURL().toString()).getFile());
    }

    public void testShouldReturnMissingResourceIfNoResourceLocated() throws Exception {
        Resource resource = this.handler.getResource("not exists path");
        StaticContentHandlerUnitTest.assertFalse((boolean)resource.exists());
    }
}

