/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.mock;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncHttpRequest {
    _AsyncRunnable runner;
    Thread thread;
    public static final int DEFAULT_TIMEOUT = 30000;
    static Log log = LogFactory.getLog(AsyncHttpRequest.class);

    protected AsyncHttpRequest() {
    }

    protected static <T extends AsyncHttpRequest> T constructRequest(T request, String name, String url, String body, int timeoutInMillis) {
        request.runner = new _AsyncRunnable(url, body, timeoutInMillis);
        request.thread = new Thread(request.runner);
        request.thread.setName(name);
        request.thread.start();
        return request;
    }

    protected String getResult() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.runner.ioex != null) {
            throw new RuntimeException(this.runner.ioex);
        }
        if (this.runner.rtex != null) {
            throw new RuntimeException(this.runner.rtex);
        }
        return this.runner.resultBody;
    }

    public boolean isAlive() {
        return this.thread.isAlive();
    }

    protected static class _AsyncRunnable
    implements Runnable {
        String url;
        String requestBody;
        String resultBody;
        int timeoutInMillis;
        IOException ioex;
        RuntimeException rtex;

        public _AsyncRunnable(String url, String body, int timeoutInMillis) {
            this.url = url;
            this.requestBody = body;
            this.timeoutInMillis = timeoutInMillis;
        }

        public void run() {
            try {
                log.info((Object)("requesting url " + this.url));
                log.info((Object)("request body " + this.requestBody));
                this.resultBody = this.doBrowserRequest(this.url, this.requestBody);
                log.info((Object)("request got result: " + this.resultBody));
            }
            catch (IOException e) {
                this.ioex = e;
            }
            catch (RuntimeException e) {
                this.rtex = e;
            }
        }

        private String doBrowserRequest(String urlString, String body) throws IOException {
            int responsecode = 200;
            URL result = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)result.openConnection();
            conn.setConnectTimeout(this.timeoutInMillis);
            conn.setReadTimeout(this.timeoutInMillis);
            conn.setRequestProperty("Content-Type", "application/xml");
            if (body != null) {
                conn.setDoOutput(true);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(body);
                wr.flush();
                wr.close();
            }
            if (responsecode == 301) {
                String pathToServlet = conn.getRequestProperty("Location");
                throw new RuntimeException("Bug! 301 redirect??? " + pathToServlet);
            }
            if (responsecode != 200) {
                throw new RuntimeException(conn.getResponseMessage());
            }
            InputStream is = conn.getInputStream();
            return this.stringContentsOfInputStream(is);
        }

        private String stringContentsOfInputStream(InputStream is) throws IOException {
            int c;
            StringBuffer sb = new StringBuffer();
            InputStreamReader r = new InputStreamReader(is, "UTF-8");
            while ((c = r.read()) != -1) {
                sb.append((char)c);
            }
            return sb.toString();
        }
    }
}

