﻿// create namespace
if(typeof ultimania=="undefined"){var ultimania={'trac':{}};}

(function($){

/**
 * The addCalendar function add YahooUI Calenar component feature for 
 * specified elmement by id.
 * Usage example:
 * <pre>
 *    &lt;input id="cal" type="text"&gt;
 * ...
 *    &lt;script type="text/javascript"&gt;
 *       ultimania.trac.addCalendar("cal");
 *    &lt;/script&gt;
 * </pre>
 * @param {String} element id for element to add calendar feature.
 * @namespace ultimania.trac
 */
ultimania.trac.addCalendar = function(id){
  var base = ultimania.trac.base;
  var calid = "__cal_"+id;
  var calbodyid = "__calbody_"+id;
  var pickerid = "__picker_"+id;
  if (document.getElementById(id) == null) return;
  e = $("#"+id);

  e.after('<img title="+" id="' + pickerid + '" src="'+base+'/icons/calendar.png" /><span class="yui-skin-sam"><span style="display:none; width: 168px; position:absolute; z-index:2" id="' + calid + '"></span></span>');
  var init = function(){
    var cal = new YAHOO.widget.Calendar(calbodyid,calid, { title:"日付を選択してください", close:true } );
    cal.cfg.setProperty("MONTHS_SHORT",   ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"]);
    cal.cfg.setProperty("MONTHS_LONG",    ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"]);
    cal.cfg.setProperty("WEEKDAYS_1CHAR", ["日", "月", "火", "水", "木", "金", "土"]);
    cal.cfg.setProperty("WEEKDAYS_SHORT", ["日", "月", "火", "水", "木", "金", "土"]);
    cal.cfg.setProperty("WEEKDAYS_MEDIUM",["日", "月", "火", "水", "木", "金", "土"]);
    cal.cfg.setProperty("WEEKDAYS_LONG",  ["日", "月", "火", "水", "木", "金", "土"]);

    cal.render();
    cal.selectEvent.subscribe(function(type,args,obj) {
      var dates = args[0]; 
      var date = dates[0];
      var year = date[0], month = date[1], day = date[2];
      var txtDate = document.getElementById(id);
      if(month < 10) month = "0" + month;
      if(day < 10) day = "0" + day;
      txtDate.value = year + "/" + month + "/" + day;
      $("#"+calid).hide();
    }, cal, true);
    YAHOO.util.Event.addListener(pickerid, "click", cal.show, cal, true);
  }
  YAHOO.util.Event.onDOMReady(init);
}

if(ultimania.trac.decoratorTable==undefined){
  ultimania.trac.decoratorTable={};
}


/**
 * Regist the decorator. Specified field and name in report
 * will replace by icon by decorate() function.
 * 
 *   field:  priority
 *   name:   blocker
 *   icon:   decorator/icons/blocker.png
 * 
 * @param {String} fieldtype   field name to decorate
 * @param {String} name        name of field to decorate
 * @param {String} icon        icon path 
 * @namespace ultimania.trac
 */
ultimania.trac.registDecorator = function(fieldtype, name, icon){
  fields = ultimania.trac.decoratorTable[fieldtype];
  if(fields == undefined){
    fields = {};
    ultimania.trac.decoratorTable[fieldtype] = fields;
  }
  fields[name] = icon;
}

/**
 * Execute decorate.
 */
ultimania.trac.decorate = function(){
  var base = ultimania.trac.base;
  for (var fieldtype in ultimania.trac.decoratorTable){
    fields = ultimania.trac.decoratorTable[fieldtype];
    $("*[@class="+fieldtype+"]").each(function(i){
      htmlField = jQuery.trim(this.innerHTML);
      if(fields[htmlField]!=undefined){
        this.innerHTML = "<img title='"+htmlField+"' src='"+fields[htmlField]+"'/>"+htmlField;
      }
    });
  }

  $("td[@class=complete]").each(function(i){
    var i = 0;
    var n = 0;
    var m = 0;
    complete = jQuery.trim(this.innerHTML);

    if(!(0<=Number(complete) && Number(complete)<="100")){
      complete = "0"
    }
    n = Number(complete);
    n = Math.floor(n*64/100);
    m = Math.floor(n/8);
    n = n-(m*8);
    if(n==0&&m==0&&Number(complete)!=0){
      n = 1;
    }
    this.innerHTML = "";
    for(i=0;i<8;i++){
      if(i==m){
        switch(n){
          case 0:
            this.innerHTML = this.innerHTML+"<img title='"+complete+"' src='" + base +"/icons/0.png' />";
            break;
          case 1:
            this.innerHTML = this.innerHTML+"<img title='"+complete+"' src='" + base +"/icons/1.png' />";
            break;
          case 2:
            this.innerHTML = this.innerHTML+"<img title='"+complete+"' src='" + base +"/icons/2.png' />";
            break;
          case 3:
            this.innerHTML = this.innerHTML+"<img title='"+complete+"' src='" + base +"/icons/3.png' />";
            break;
          case 4:
            this.innerHTML = this.innerHTML+"<img title='"+complete+"' src='" + base +"/icons/4.png' />";
            break;
          case 5:
            this.innerHTML = this.innerHTML+"<img title='"+complete+"' src='" + base +"/icons/5.png' />";
            break;
          case 6:
            this.innerHTML = this.innerHTML+"<img title='"+complete+"' src='" + base +"/icons/6.png' />";
            break;
          case 7:
            this.innerHTML = this.innerHTML+"<img title='"+complete+"' src='" + base +"/icons/7.png' />";
            break;
            default:
          break;
        }
      }
      else if(i>m){
        this.innerHTML = this.innerHTML+"<img title='"+complete+"' src='" + base +"/icons/0.png' />";
      }
      else{
        this.innerHTML = this.innerHTML+"<img title='"+complete+"' src='" + base +"/icons/8.png' />";
      }
    }
  });

}

/**
 * Initialized Ext component.
 */
ultimania.trac.initExt = function(){
  Ext.onReady(function(){
      Ext.QuickTips.init();
      //
      // ComboBox.js at 417
      //     "enter" : function(e){
      //         this.onViewClick();
      //         return true;
      //     },
      Ext.EventObjectImpl.prototype.isSpecialKey = function(){
        var k = this.keyCode;
        return (this.type == 'keypress' && this.ctrlKey) || k == this.TAB || k == this.DOWN || k == this.ESC ||
        (k == this.SHIFT) || (k == this.CONTROL) ||
        (k >= 18 && k <= 20) || // ??
        (k >= 33 && k <= 35) || // PAGEUP,PAGEDOWN,RND
        (k >= 36 && k <= 39) || // HOME,LEFT,UP,RIGHT
        (k >= 44 && k <= 45);   // ?? 
      };

      $("input[@type=text]").each(function(i){
        if(this.id!=null){
          new Ext.form.TextField({
                applyTo:this.id
          });
        }
      });

      $("textarea").each(function(i){
        if(this.id!=null){
          new Ext.form.TextArea({
               applyTo:this.id
          });
        }
      });
      $("select").each(function(i){
        if(this.id!=null){
          new Ext.form.ComboBox({
              typeAhead: true,
              triggerAction: 'all',
              transform:this.id,
              forceSelection:true
            });
         }
       });
  });
}

})(jQuery);
