/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.log.AntJettyLoggerBuildListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacProxyManager {
    static Log log = LogFactory.getLog(MacProxyManager.class);
    private static final Pattern SCUTIL_LINE = Pattern.compile("^  (\\S+) : (.*)$");
    private static final Pattern NETWORKSETUP_LISTORDER_LINE = Pattern.compile("\\(Hardware Port: ([^,]*), Device: ([^\\)]*)\\)");
    private static final Pattern NETWORKSETUP_LINE = Pattern.compile("^([^:]+): (.*)$");
    private static final String BACKUP_READY = "backupready";
    private String sessionId;
    private File customProxyPACDir;
    private int port;
    private Preferences prefs = Preferences.userNodeForPackage(MacProxyManager.class);
    private String networkService;

    public MacProxyManager(String sessionId, int port) {
        this.sessionId = sessionId;
        this.port = port;
        this.prefs = Preferences.userNodeForPackage(MacProxyManager.class);
    }

    public File getCustomProxyPACDir() {
        return this.customProxyPACDir;
    }

    private boolean prefNodeExists(String key) {
        return null != this.prefs.get(key, null);
    }

    public void changeNetworkSettings() throws IOException {
        if (this.networkService == null) {
            this.getCurrentNetworkSettings();
        }
        this.customProxyPACDir = LauncherUtils.createCustomProfileDir(this.sessionId);
        if (this.customProxyPACDir.exists()) {
            LauncherUtils.recursivelyDeleteDir(this.customProxyPACDir);
        }
        this.customProxyPACDir.mkdir();
        log.info((Object)"Modifying OS X global network settings...");
        this.runNetworkSetup("-setwebproxy", this.networkService, "localhost", "" + this.port);
        this.runNetworkSetup("-setproxybypassdomains", this.networkService, "Empty");
    }

    private String findNetworkSetupBin() {
        String defaultPath = "/System/Library/CoreServices/RemoteManagement/ARDAgent.app/Contents/Support/networksetup";
        File defaultLocation = new File(defaultPath);
        if (defaultLocation.exists()) {
            return defaultLocation.getAbsolutePath();
        }
        File networkSetupBin = AsyncExecute.whichExec("networksetup");
        if (networkSetupBin != null) {
            return networkSetupBin.getAbsolutePath();
        }
        if (defaultLocation.getParentFile().exists()) {
            String[] files = defaultLocation.getParentFile().list();
            String guess = this.chooseSuitableNetworkSetup(System.getProperty("os.version"), System.getProperty("os.arch"), files);
            if (guess != null) {
                File guessedLocation = new File(defaultLocation.getParentFile(), guess);
                log.warn((Object)("Couldn't find 'networksetup' in expected location; we're taking a guess and using " + guessedLocation.getAbsolutePath() + " instead.  Please create a symlink called 'networksetup' to make " + "this warning go away."));
                return guessedLocation.getAbsolutePath();
            }
        }
        throw new MacNetworkSetupException("networksetup couldn't be found in the path!\nPlease add the directory containing 'networksetup' to your PATH environment\nvariable.");
    }

    private String chooseSuitableNetworkSetup(String osVersion, String osArch, String ... files) {
        HashSet<String> candidates = new HashSet<String>();
        for (String file : files) {
            if (!file.startsWith("networksetup-")) continue;
            candidates.add(file);
        }
        if (candidates.isEmpty()) {
            log.debug((Object)"No networksetup candidates found");
            return null;
        }
        if (candidates.size() == 1) {
            log.debug((Object)"One networksetup candidate found");
            return (String)candidates.iterator().next();
        }
        log.debug((Object)("Multiple networksetup candidates found: " + candidates));
        String[] versionParts = osVersion.split("\\.");
        if (versionParts.length < 2) {
            log.debug((Object)("OS version seems to be invalid: " + osVersion));
            return null;
        }
        if (!"10".equals(versionParts[0])) {
            log.debug((Object)("OS version doesn't seem to be 10.*: " + osVersion));
            return null;
        }
        try {
            CodeName codeName = CodeName.minorVersion(versionParts[1]);
            String possibleCandidate = "networksetup-" + codeName.name().toLowerCase();
            if (candidates.contains(possibleCandidate)) {
                log.debug((Object)("This seems to be " + (Object)((Object)codeName) + ", so we'll use " + possibleCandidate));
                return possibleCandidate;
            }
            log.debug((Object)("This seems to be " + (Object)((Object)codeName) + ", but there's no " + possibleCandidate));
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)("Couldn't find code name for OS version " + osVersion));
            return null;
        }
        return null;
    }

    private String findScutilBin() {
        String defaultPath = "/usr/sbin/scutil";
        File defaultLocation = new File(defaultPath);
        if (defaultLocation.exists()) {
            return defaultLocation.getAbsolutePath();
        }
        File scutilBin = AsyncExecute.whichExec("scutil");
        if (scutilBin != null) {
            return scutilBin.getAbsolutePath();
        }
        throw new MacNetworkSetupException("scutil couldn't be found in the path!\nPlease add the directory containing 'scutil' to your PATH environment\nvariable.");
    }

    private MacNetworkSettings getCurrentNetworkSettings() {
        int port1;
        this.getPrimaryNetworkServiceName();
        String output = this.runNetworkSetup("-getwebproxy", this.networkService);
        log.debug((Object)output);
        Map<String, String> dictionary = LauncherUtils.parseDictionary(output.toString(), NETWORKSETUP_LINE);
        String strEnabled = this.verifyKey("Enabled", dictionary, "networksetup", output);
        boolean enabled = this.isTrueOrSomething(strEnabled);
        String server = this.verifyKey("Server", dictionary, "networksetup", output);
        String strPort = this.verifyKey("Port", dictionary, "networksetup", output);
        try {
            port1 = Integer.parseInt(strPort);
        }
        catch (NumberFormatException e) {
            throw new MacNetworkSetupException("Port didn't look right: " + output, e);
        }
        String strAuth = this.verifyKey("Authenticated Proxy Enabled", dictionary, "networksetup", output);
        boolean auth = this.isTrueOrSomething(strAuth);
        String[] bypassDomains = this.getCurrentProxyBypassDomains();
        MacNetworkSettings networkSettings = new MacNetworkSettings(this.networkService, enabled, server, port1, auth, bypassDomains);
        return networkSettings;
    }

    private String[] getCurrentProxyBypassDomains() {
        int i;
        String output = this.runNetworkSetup("-getproxybypassdomains", this.networkService);
        log.debug((Object)output);
        if (output == null) {
            throw new MacNetworkSetupException("-getproxybypassdomains had no output");
        }
        String[] lines = output.split("\n");
        if (lines.length == (i = 0)) {
            return new String[]{""};
        }
        if (lines[i].startsWith("cp: /Library")) {
            ++i;
        }
        if (lines.length == i) {
            return new String[]{""};
        }
        if (lines[i].startsWith("There aren't any")) {
            return new String[0];
        }
        if (i == 0) {
            return lines;
        }
        String[] domains = new String[lines.length - i];
        System.arraycopy(lines, i, domains, 0, lines.length - i);
        return domains;
    }

    private boolean isTrueOrSomething(String value) {
        String[] matches;
        for (String match : matches = new String[]{"yes", "1", "true", "on"}) {
            if (!match.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    private String verifyKey(String key, Map<String, String> dictionary, String executable, String output) {
        if (!dictionary.containsKey(key)) {
            throw new MacNetworkSetupException("Couldn't find " + key + " in " + executable + "; output: " + output);
        }
        return dictionary.get(key);
    }

    private String getPrimaryNetworkServiceName() {
        String userDefinedName;
        String output = this.runScutil("show State:/Network/Global/IPv4");
        log.debug((Object)output);
        Map<String, String> dictionary = LauncherUtils.parseDictionary(output.toString(), SCUTIL_LINE);
        String primaryInterface = this.verifyKey("PrimaryInterface", dictionary, "scutil", output);
        output = this.runNetworkSetup("-listnetworkserviceorder");
        log.debug((Object)output);
        dictionary = LauncherUtils.parseDictionary(output.toString(), NETWORKSETUP_LISTORDER_LINE, true);
        this.networkService = userDefinedName = this.verifyKey(primaryInterface, dictionary, "networksetup -listnetworksetuporder", output);
        return userDefinedName;
    }

    protected String runScutil(String arg) {
        Project p = new Project();
        p.addBuildListener((BuildListener)new AntJettyLoggerBuildListener(log));
        ExecTask exec = new ExecTask();
        exec.setProject(p);
        exec.setTaskType("scutil");
        exec.setExecutable(this.findScutilBin());
        exec.setFailonerror(false);
        exec.setResultProperty("result");
        exec.setOutputproperty("output");
        exec.setInputString(arg + "\nquit\n");
        exec.execute();
        String output = p.getProperty("output");
        String result = p.getProperty("result");
        if (!"0".equals(result)) {
            throw new RuntimeException("exec return code " + result + ": " + output);
        }
        return output;
    }

    protected String runNetworkSetup(String ... args) {
        Project p = new Project();
        p.addBuildListener((BuildListener)new AntJettyLoggerBuildListener(log));
        ExecTask exec = new ExecTask();
        exec.setProject(p);
        exec.setTaskType("networksetup");
        exec.setExecutable(this.findNetworkSetupBin());
        exec.setFailonerror(false);
        exec.setResultProperty("result");
        exec.setOutputproperty("output");
        for (String arg : args) {
            exec.createArg().setValue(String.valueOf(arg));
        }
        exec.execute();
        String output = p.getProperty("output");
        String result = p.getProperty("result");
        if (!"0".equals(result)) {
            throw new RuntimeException("exec return code " + result + ": " + output);
        }
        return output;
    }

    public void backupNetworkSettings() throws IOException {
        if (this.backupIsReady()) {
            return;
        }
        log.info((Object)"Backing up OS X global network settings...");
        MacNetworkSettings networkSettings = this.getCurrentNetworkSettings();
        this.writeToPrefs(networkSettings);
        this.backupReady(true);
    }

    public void restoreNetworkSettings() {
        if (!this.backupIsReady()) {
            return;
        }
        log.info((Object)"Restoring OS X global network settings...");
        MacNetworkSettings networkSettings = this.retrieveFromPrefs();
        this.runNetworkSetup("-setwebproxy", networkSettings.serviceName, networkSettings.proxyServer, "" + networkSettings.port1);
        if (networkSettings.bypass.length > 0) {
            String[] bypassDomainArgs = new String[networkSettings.bypass.length + 2];
            bypassDomainArgs[0] = "-setproxybypassdomains";
            bypassDomainArgs[1] = networkSettings.serviceName;
            System.arraycopy(networkSettings.bypass, 0, bypassDomainArgs, 2, networkSettings.bypass.length);
            this.runNetworkSetup(bypassDomainArgs);
        } else {
            this.runNetworkSetup("-setproxybypassdomains", networkSettings.serviceName, "Empty");
        }
        String enabledArg = networkSettings.enabled ? "on" : "off";
        this.runNetworkSetup("-setwebproxystate", networkSettings.serviceName, enabledArg);
        this.backupReady(false);
    }

    private MacNetworkSettings retrieveFromPrefs() {
        String[] bypass;
        String serviceName = this.prefsGetStringOrFail("serviceName");
        String proxyServer = this.prefsGetStringOrFail("proxyServer");
        String strBypass = this.prefsGetStringOrFail("bypass");
        if ("".equals(strBypass)) {
            bypass = new String[]{};
        } else {
            int domains;
            String[] bypassEncodedArray = strBypass.split("\t");
            try {
                domains = Integer.parseInt(bypassEncodedArray[0]);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("BUG! Couldn't decode bypass preference: " + strBypass);
            }
            bypass = new String[domains];
            if (domains == bypassEncodedArray.length) {
                if (domains == 1) {
                    bypass = new String[]{""};
                } else {
                    if (bypassEncodedArray.length != domains - 1) {
                        throw new RuntimeException("BUG! Couldn't decode bypass preference: " + strBypass);
                    }
                    System.arraycopy(bypassEncodedArray, 1, bypass, 0, domains - 1);
                }
            } else {
                if (bypassEncodedArray.length != domains + 1) {
                    throw new RuntimeException("BUG! Couldn't decode bypass preference: " + strBypass);
                }
                System.arraycopy(bypassEncodedArray, 1, bypass, 0, domains);
            }
        }
        int port1 = this.prefsGetIntOrFail("port");
        boolean enabled = this.prefsGetBooleanOrFail("enabled");
        boolean authenticated = this.prefsGetBooleanOrFail("authenticated");
        return new MacNetworkSettings(serviceName, enabled, proxyServer, port1, authenticated, bypass);
    }

    private String prefsGetStringOrFail(String key) {
        String value = this.prefs.get(key, null);
        if (value == null) {
            throw new RuntimeException("BUG! pref key " + key + " should not be null");
        }
        return value;
    }

    private int prefsGetIntOrFail(String key) {
        this.prefsGetStringOrFail(key);
        return this.prefs.getInt(key, 0);
    }

    private boolean prefsGetBooleanOrFail(String key) {
        this.prefsGetStringOrFail(key);
        return this.prefs.getBoolean(key, false);
    }

    private void writeToPrefs(MacNetworkSettings networkSettings) {
        this.prefs.put("serviceName", networkSettings.serviceName);
        this.prefs.putBoolean("enabled", networkSettings.enabled);
        this.prefs.put("proxyServer", networkSettings.proxyServer);
        this.prefs.putInt("port", networkSettings.port1);
        this.prefs.putBoolean("authenticated", networkSettings.authenticated);
        this.prefs.put("bypass", networkSettings.bypassAsString());
    }

    private boolean backupIsReady() {
        if (!this.prefNodeExists(BACKUP_READY)) {
            return false;
        }
        return this.prefs.getBoolean(BACKUP_READY, false);
    }

    private void backupReady(boolean backupReady) {
        this.prefs.putBoolean(BACKUP_READY, backupReady);
    }

    class MacNetworkSettings {
        final String serviceName;
        final boolean enabled;
        final String proxyServer;
        final int port1;
        final boolean authenticated;
        final String[] bypass;

        public MacNetworkSettings(String serviceName, boolean enabled, String server, int port, boolean authenticated, String[] bypass) {
            this.serviceName = serviceName;
            this.enabled = enabled;
            this.proxyServer = server;
            this.port1 = port;
            this.authenticated = authenticated;
            this.bypass = bypass;
        }

        public String bypassAsString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.bypass.length).append('\t');
            for (String domain : this.bypass) {
                sb.append(domain).append('\t');
            }
            return sb.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("{serviceName=");
            sb.append(this.serviceName).append(", enabled=").append(this.enabled).append(", proxyServer=").append(this.proxyServer).append(", port=").append(this.port1).append(", authenticated=").append(this.authenticated).append(", bypass=").append(Arrays.toString(this.bypass)).append("}");
            return sb.toString();
        }
    }

    static class MacNetworkSetupException
    extends RuntimeException {
        MacNetworkSetupException(Exception e) {
            super(MacNetworkSetupException.generateMessage(), e);
        }

        private static String generateMessage() {
            return "Problem while managing OS X network settings, OS Version " + System.getProperty("os.version");
        }

        MacNetworkSetupException(String message) {
            this(new RuntimeException(message));
        }

        MacNetworkSetupException(String message, Throwable e) {
            super(MacNetworkSetupException.generateMessage() + ": " + message, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CodeName {
        PUMA("1"),
        JAGUAR("2"),
        PANTHER("3"),
        TIGER("4"),
        LEOPARD("5");

        String minorVersion;

        private CodeName(String minorVersion) {
            this.minorVersion = minorVersion;
        }

        static CodeName minorVersion(String minorVersion) {
            for (CodeName cn : CodeName.values()) {
                if (!cn.minorVersion.equals(minorVersion)) continue;
                return cn;
            }
            throw new IllegalArgumentException("No codename matches minorVersion " + minorVersion);
        }
    }
}

