/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.FileNotWriteException;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.UserData;
import org.ultramonkey.l7.model.UserManager;
import org.ultramonkey.l7.view.L7guiServletBase;

public class UserAddServlet
extends L7guiServletBase {
    static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger((String)"l7gui_I/O");

    public UserAddServlet() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11321 class UserAddServlet created.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("UserAddServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11322 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            this.logger.debug((Object)("11323 QueryString=\"" + request.getQueryString() + "\""));
        }
        response.sendRedirect("index.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11324 UserAddServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11325 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            Enumeration keys = request.getParameterNames();
            String post = "";
            while (keys.hasMoreElements()) {
                if (post.length() != 0) {
                    post = String.valueOf(post) + "&";
                }
                String key = (String)keys.nextElement();
                post = String.valueOf(post) + key + "=" + request.getParameter(key);
            }
            this.logger.debug((Object)("11326 PostData=\"" + post + "\""));
        }
        super.doPost(request, response);
        HttpSession session = request.getSession(false);
        if (!this.login || session == null) {
            if (session != null) {
                MessageView error = new MessageView(41080, "l7gui_UserAuthentication", "Invalid session.");
                session.setAttribute("resultMessage", (Object)error);
            }
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11327 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        request.setCharacterEncoding("UTF-8");
        String userId = request.getParameter("userId");
        String description = request.getParameter("description");
        String newPass1 = request.getParameter("new1_passwd");
        String newPass2 = request.getParameter("new2_passwd");
        String button_mode = request.getParameter("button");
        if (userId == null || description == null || newPass1 == null || newPass2 == null || button_mode == null || !button_mode.equals("Add")) {
            MessageView error = new MessageView(41081, "l7gui_UserManage", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11328 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        boolean validationFlag = true;
        validationFlag = this.validationCheck(session, userId, description, newPass1, newPass2);
        if (!validationFlag) {
            UserData inputUser = new UserData();
            inputUser.userName = userId;
            inputUser.description = description;
            session.setAttribute("inputUserData", (Object)inputUser);
            response.sendRedirect("user_add.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11329 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        UserManager user = UserManager.getInstance();
        boolean addUser = false;
        try {
            Vector<UserData> userList = user.getUserList();
            int userCount = userList.size();
            if (userCount >= 16) {
                MessageView error = new MessageView(41082, "l7gui_I/O.File", "GUI Users is up to 16 users. You cannot add over 16 users.");
                session.setAttribute("resultMessage", (Object)error);
                response.sendRedirect("user_add_fail.jsp");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"11330 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                }
                return;
            }
            addUser = user.addUser(userId, newPass1, 0, description);
        }
        catch (FileNotWriteException e) {
            MessageView error = new MessageView(41083, "l7gui_I/O.File", "Cannot write file.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11331 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        catch (Exception e) {
            MessageView error = new MessageView(41084, "l7gui_StartStop", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11332 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        if (addUser) {
            MessageView message = new MessageView(21041, "l7gui_UserManage", "New user added.");
            session.setAttribute("resultMessage", (Object)message);
            session.setAttribute("guiSyncState", (Object)"noSync");
            response.sendRedirect("user_manage.jsp");
        } else {
            MessageView error = new MessageView(41085, "l7gui_UserManage", "Already the same user exists.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("user_add_fail.jsp");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11333 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected boolean validationCheck(HttpSession session, String userId, String description, String newPass1, String newPass2) {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("UserAddServlet::validationCheck(HttpSession session, String userId, String description, String newPass1, String newPass2) in ");
            buf.append("session=(" + session + "), ");
            buf.append("userId=\"" + userId + "\", ");
            buf.append("description=\"" + description + "\", ");
            buf.append("newPass1=\"" + newPass1 + "\", ");
            buf.append("newPass2=\"" + newPass2);
            this.logger.debug((Object)("11334 " + buf.toString()));
        }
        boolean validationFlag = true;
        int MAX_USER_LENGTH = 16;
        int MAX_DESCRIPTION_LENGTH = 64;
        int MIN_PASS_LENGTH = 6;
        int MAX_PASS_LENGTH = 16;
        Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
        if (session == null) {
            validationFlag = false;
        } else if (userId == null || description == null || newPass1 == null || newPass2 == null) {
            MessageView error = new MessageView(21042, "l7gui_UserManage", "Invalid value.");
            session.setAttribute("resultMessage", (Object)error);
            validationFlag = false;
        } else if (userId.length() == 0 && description.length() == 0 && newPass1.length() == 0 && newPass2.length() == 0) {
            MessageView error = new MessageView(21043, "l7gui_UserManage", "All fields are empty.");
            session.setAttribute("resultMessage", (Object)error);
            validationFlag = false;
        } else if (userId.length() == 0 || newPass1.length() == 0 || newPass2.length() == 0) {
            MessageView error = new MessageView(21044, "l7gui_UserManage", "Please fill in the required fields.");
            session.setAttribute("resultMessage", (Object)error);
            validationFlag = false;
        } else {
            Matcher matcherUserId = pattern.matcher(userId);
            Matcher matcherNewPass1 = pattern.matcher(newPass1);
            Matcher matcherNewPass2 = pattern.matcher(newPass2);
            Matcher matcherDescription = pattern.matcher(description);
            if (matcherUserId.find() || matcherNewPass1.find() || matcherNewPass2.find() || matcherDescription.find()) {
                MessageView error = new MessageView(21045, "l7gui_UserManage", "Input item : Invalid value.");
                session.setAttribute("resultMessage", (Object)error);
                validationFlag = false;
            } else if (!newPass1.equals(newPass2)) {
                MessageView error = new MessageView(21046, "l7gui_UserManage", "The Password and confirmation Password do not match.");
                session.setAttribute("resultMessage", (Object)error);
                validationFlag = false;
            } else if (userId.length() > 16 || newPass1.length() < 6 || newPass1.length() > 16 || description.length() > 64) {
                MessageView error = new MessageView(21047, "l7gui_UserManage", "Invalid value.");
                session.setAttribute("resultMessage", (Object)error);
                validationFlag = false;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("11335 UserAddServlet::validationCheck(HttpSession session, String userId, String description, String newPass1, String newPass2) out return=" + validationFlag));
        }
        return validationFlag;
    }
}

