<%@ page
	import="org.ultramonkey.l7.model.*,org.ultramonkey.l7.controller.*,org.ultramonkey.l7.view.*"
	language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<%
	/*
	 * check session
	 */
    L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41395,
		LogCategorySet.GUI_USER_AUTHENTICATION,
		Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get VS IPaddress
	 */
	L7guiFramework framework = new L7guiFramework();
	ClusterData cd = framework.getClusterData();

	String self = "";
	String other = "";

	if (cd == null) {
		MessageView error = new MessageView(41396,
		LogCategorySet.GUI_IO_COMMAND,
		Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	} else {
		self = cd.self_ip;
		other = cd.other_ip;
	}

	if ((self == null) || (other == null)) {
		MessageView error = new MessageView(41397,
		LogCategorySet.GUI_IO_COMMAND,
		Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get result message
	 */
	MessageView message = (MessageView) session
			.getAttribute(SessionKeys.COMMAND_MESSAGE);

	String errorMessage = "";
	int errorNumber = 0;
	String category = "";

	if (message != null) {
		errorMessage = message.getMessage();
		errorNumber = message.getErrno();
		category = message.getCategory();
		session.setAttribute(SessionKeys.COMMAND_MESSAGE, null);
	}

	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if (cd.self_status == ClusterStatus.ACTIVE) {
		cssSeat = "l7gui_act_style.css";
	} else if (cd.self_status == ClusterStatus.STANDBY) {
		cssSeat = "l7gui_sby_style.css";
	}
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<noscript>
<meta http-equiv="refresh"
	content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>" />
</noscript>
<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
<link rel="shortcut icon" href="images/favicon.ico" />
<title>Failed : Sync Resources</title>
</head>

<body class="normal">

<jsp:include page="menu.jsp" flush="false" />

<div id="content">
<h1 class="title">Failed : Sync Resources</h1>
<h2>Sync failed.</h2>

<h2><%=self%> (<%=cd.self_status %>) <img class="arrow2" src="images/arrowlogo2.gif"
		     alt="arrowlogo" /><%=other %> (<%=cd.other_status %>)</h2>

<% if ( (message != null ) && (errorMessage != null)){ 
%>
<h2>Error Reason :</h2>
<p class="error">[<%=category%>-<%=errorNumber%>]</p>
<p class=error><%=errorMessage%></p>
<%
}
%>
</div>
</body>
</html>
