/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.LogData;
import org.ultramonkey.l7.controller.LogFileData;
import org.ultramonkey.l7.model.L7guiFramework;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.view.L7guiServletBase;

public class LogOutputServlet
extends L7guiServletBase {
    static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger((String)"l7gui_I/O");

    public LogOutputServlet() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11363 class LoginServlet created.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block38: {
            BufferedOutputStream out;
            block39: {
                Vector<LogFileData> logList;
                String logFile;
                HttpSession session;
                block37: {
                    if (this.logger.isDebugEnabled()) {
                        StringBuffer buf = new StringBuffer();
                        buf.append("LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
                        buf.append("request=(" + request + "), ");
                        buf.append("response=(" + response + ")");
                        this.logger.debug((Object)("11364 " + buf.toString()));
                        request.setCharacterEncoding("UTF-8");
                        this.logger.debug((Object)("11365 QueryString=\"" + request.getQueryString() + "\""));
                    }
                    super.doPost(request, response);
                    session = request.getSession(false);
                    if (!this.login || session == null) {
                        if (session != null) {
                            MessageView error = new MessageView(41093, "l7gui_UserAuthentication", "Invalid session.");
                            session.setAttribute("resultMessage", (Object)error);
                        }
                        response.sendRedirect("index.jsp");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"11366 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                        }
                        return;
                    }
                    request.setCharacterEncoding("UTF-8");
                    String logType = request.getParameter("type");
                    logFile = request.getParameter("log");
                    if (logType == null || logFile == null) {
                        MessageView error = new MessageView(41094, "l7gui_Log", "Unexpected error.");
                        session.setAttribute("resultMessage", (Object)error);
                        response.sendRedirect("index.jsp");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"11367 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                        }
                        return;
                    }
                    logList = null;
                    L7guiFramework frameWork = new L7guiFramework();
                    LogData log = frameWork.getLogData();
                    try {
                        if (logType.equals("l7vsd")) {
                            logList = log.lbLog.logFiles;
                            break block37;
                        }
                        if (logType.equals("l7vsadm")) {
                            logList = log.admLog.logFiles;
                            break block37;
                        }
                        if (logType.equals("l7directord")) {
                            logList = log.directorLog.logFiles;
                            break block37;
                        }
                        if (logType.equals("SNMPAgent")) {
                            logList = log.snmpLog.logFiles;
                            break block37;
                        }
                        if (logType.equals("l7gui")) {
                            logList = log.guiLog.logFiles;
                            break block37;
                        }
                        if (logType.equals("syncResource")) {
                            logList = log.syncLog.logFiles;
                            break block37;
                        }
                        if (logType.equals("HA")) {
                            logList = log.haLog.logFiles;
                            break block37;
                        }
                        MessageView error = new MessageView(41095, "l7gui_Log", "Unexpected error.");
                        session.setAttribute("resultMessage", (Object)error);
                        response.sendRedirect("index.jsp");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"11368 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                        }
                        return;
                    }
                    catch (NullPointerException e) {
                        MessageView error = new MessageView(41096, "l7gui_Log", "Unexpected error.");
                        session.setAttribute("resultMessage", (Object)error);
                        response.sendRedirect("index.jsp");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"11369 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                        }
                        return;
                    }
                }
                if (logList == null) {
                    MessageView error = new MessageView(41097, "l7gui_Log", "Unexpected error.");
                    session.setAttribute("resultMessage", (Object)error);
                    response.sendRedirect("index.jsp");
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"11370 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                    }
                    return;
                }
                String dwLogFilePath = null;
                boolean matchFlag = false;
                int i = 0;
                while (i < logList.size()) {
                    if (logList.get((int)i).fileName.equals(logFile)) {
                        dwLogFilePath = logList.get((int)i).filePath;
                        matchFlag = true;
                        break;
                    }
                    ++i;
                }
                if (!matchFlag || dwLogFilePath == null) {
                    MessageView error = new MessageView(41098, "l7gui_Log", "Unexpected error.");
                    session.setAttribute("resultMessage", (Object)error);
                    response.sendRedirect("index.jsp");
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"11371 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                    }
                    return;
                }
                File file = new File(dwLogFilePath);
                BufferedInputStream in = null;
                out = null;
                try {
                    int len;
                    response.setContentType("application/octet-stream");
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
                    response.setContentLength((int)file.length());
                    in = new BufferedInputStream(new FileInputStream(file));
                    out = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) != -1) {
                        out.write(buf, 0, len);
                    }
                }
                catch (SocketException buf) {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                    break block38;
                }
                catch (Exception e) {
                    try {
                        response.reset();
                        response.sendError(500, e.toString());
                        break block38;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.flush();
                            out.close();
                        }
                    }
                }
                if (in == null) break block39;
                in.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11372 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("LogOutputServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11373 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            Enumeration keys = request.getParameterNames();
            String post = "";
            while (keys.hasMoreElements()) {
                if (post.length() != 0) {
                    post = String.valueOf(post) + "&";
                }
                String key = (String)keys.nextElement();
                post = String.valueOf(post) + key + "=" + request.getParameter(key);
            }
            this.logger.debug((Object)("11374 PostData=\"" + post + "\""));
        }
        response.sendRedirect("index.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11375 LogOutputServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }
}

