<%@ page import="org.ultramonkey.l7.model.*, org.ultramonkey.l7.controller.*, org.ultramonkey.l7.view.*, 
				java.net.InetAddress, java.net.UnknownHostException,java.util.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"
%>
<%
	/*
	 * check session
	 */
	L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41311, LogCategorySet.GUI_USER_AUTHENTICATION,
				Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get cluster status 
	 */
	L7guiFramework framework = new L7guiFramework(); 
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41312, LogCategorySet.GUI_IO_COMMAND,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}	
		
	/*
	 * get UserNmae
	 */	 
	UserData currentUser = (UserData) session.getAttribute(SessionKeys.LOGIN_SESSION);
	if (currentUser == null) {
		MessageView error = new MessageView(41313, LogCategorySet.GUI_USER_AUTHENTICATION, 
				Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	String userName = currentUser.userName;
	if (userName == null){
		MessageView error = new MessageView(41314, LogCategorySet.GUI_USER_AUTHENTICATION,
				Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	
	/*
	 * get host name
	 */	 
	InetAddress hostName = null;
	try {
		hostName = InetAddress.getLocalHost();
	}
	catch(UnknownHostException e){
		hostName =null;
	}
		
	/*
	 * get save status
	 */	 
	boolean saveState = false;
	String logSaveState = (String)session.getAttribute(SessionKeys.LOG_SAVE_STATE);
	String vsSaveState = (String)session.getAttribute(SessionKeys.VS_SAVE_STATE);

	if ( (logSaveState == null) || (vsSaveState == null) ){
		MessageView error = new MessageView(41315, LogCategorySet.GUI_USER_AUTHENTICATION,
				Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	
	if ((logSaveState.equals(SessionKeys.SAVE)) && (vsSaveState.equals(SessionKeys.SAVE))){
		saveState = true;
	}

	
	/*
	 * get sync status
	 */	 
	boolean syncState = false;
	String logSyncState = (String)session.getAttribute(SessionKeys.LOG_SYNC_STATE);
	String vsSyncState = (String)session.getAttribute(SessionKeys.VS_SYNC_STATE);
	String monitorSyncState = (String)session.getAttribute(SessionKeys.MONITOR_SYNC_STATE);
	String repSyncState = (String)session.getAttribute(SessionKeys.REP_SYNC_STATE);
	String snmpSyncState = (String)session.getAttribute(SessionKeys.SNMP_SYNC_STATE);
	String guiSyncState = (String)session.getAttribute(SessionKeys.GUI_SYNC_STATE);
	
	if ( (logSyncState.equals(SessionKeys.SYNC)) && (vsSyncState.equals(SessionKeys.SYNC)) 
			&& (monitorSyncState.equals(SessionKeys.SYNC)) && (repSyncState.equals(SessionKeys.SYNC)) 
			&& (snmpSyncState.equals(SessionKeys.SYNC)) && (guiSyncState.equals(SessionKeys.SYNC)) ){
		syncState = true;
	}
	
	/*
	 * Adm timeout status
	 */
	Parameter param = Parameter.getInstance(); 
	if (param == null){
		MessageView error = new MessageView(41316, LogCategorySet.GUI_START_STOP,
				Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	
	String sessionTimeout = param.getValue(Parameter.L7VSADM_TIMEOUT_FLAG);
	
	/*
	 * get L7vsAdmData (SNMPAgent) 
	 */
	L7vsAdmData admData = framework.getAdmData();
	SnmpAgentStatus snmpStatus = SnmpAgentStatus.NON_CONNECTING;
	if (admData != null) {
		snmpStatus = admData.snmpStatus;
	}
	
	/*
	 * get L7vsAdmData (Replication) 
	 */
	ReplicationStatus repStatus = ReplicationStatus.SINGLE;
	if (admData != null) {
		repStatus = admData.replicationMode;
	}

	/*
	 * get user info 
	 */	
	UserManager user = UserManager.getInstance();
	Vector<UserData> userList;
	try {
		userList = user.getUserList();
	}
	catch(Exception e){
		MessageView error = new MessageView(41317, LogCategorySet.GUI_IO_FILE,
		Message.READ_ERROR);
	session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
	response.sendRedirect(RedirectPages.LOGIN);
	return;
	}
	if ( userList == null ){
		MessageView error = new MessageView(41318, LogCategorySet.GUI_IO_FILE,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	int userCount = userList.size();
%>

<div id="sidebar">


<a href="top.jsp">
<img class="top" src="images/ultraMonkey-L7rogo.gif" width="207" height="27" alt="UltraMonkey-L7 logo" /></a>
<h4 class="menu">Host Name :
<%
	if (hostName != null){
		out.println(hostName.getHostName());
	}
	else {
		out.println("Unknown Host Name");
	}
%>
</h4>

<h4 class="menu">UserID : <%= userName %></h4>

<%
	if ( (cd.self_status == ClusterStatus.ACTIVE) || (cd.self_status == ClusterStatus.STANDBY ) ){
		int localPort = request.getLocalPort();
		String context = request.getContextPath();
		String peerIP = cd.other_ip;
		String peerAddress = "http://" + peerIP + ":" + localPort + context + "/index.jsp" ; 
		
		if(cd.self_status == ClusterStatus.ACTIVE){
%>
			<h4 class="menu">Self Node Status : <%= cd.self_status %></h4>
			<input class="topeer" type="image" align="middle" id="toSby" name="toSby" src="images/toSby.gif"  onClick="window.open('<%=peerAddress %>')">
<%
		}
		else {
%>
			<h4 class="menu">Self Node Status : <%= cd.self_status %></h4> 
			<input class="topeer" type="image" align="middle" id="toAct" name="toAct" src="images/toAct.gif"  onClick="window.open('<%=peerAddress %>')">
<%
		}
	}

	if ( sessionTimeout == null ) {
		if ( saveState == false){
%>
		<h4 class="note">
		<img src="images/exclamation3.gif" alt="Caution!!" width="16" height="14" align="middle">	
		No Save</h4>
<%
		}
	
		if ( (cd.self_status == ClusterStatus.ACTIVE ) || (cd.self_status == ClusterStatus.STANDBY) ){
			if ( syncState == false ){
%>
				<h4 class="note"> 
				<img src="images/exclamation3.gif" alt="Caution!!" width="16" height="14" align="middle">
				No Sync</h4>
<%
			}
		}
	}
%>		

<br />
<br />


<h2 class="menu">
<img src="images/Monkey.gif" alt="UltraMonkey-L7 graffic" width="30" height="30" align="middle">
MENU
<img src="images/Monkey.gif" alt="UltraMonkey-L7 graffic" width="30" height="30" align="middle">
</h2>

<table class="menu">

<tr>
    <td></td> 
    <td><a href="top.jsp">Top</a></td>
</tr>

<%
	if ( (sessionTimeout == null) && 
			( (cd.self_status.equals(ClusterStatus.ACTIVE)) || (cd.self_status.equals(ClusterStatus.SINGLE)) ) ){
%>	
<tr>
    <td> 
        <img class="icon" src="images/plus.gif" onclick="openTree('virtualservice', this)" />
    </td>
    <td>
        <a href="um7state_info.jsp">VirtualService</a><br />
        <div id="virtualservice" style="display:none">
            <a href="vs_add.jsp" class="sub">Add</a>
        </div>
    </td>
</tr>
<%
	}
	if (sessionTimeout == null){
%>
<tr>
    <td> 
        <img class="icon" src="images/plus.gif" onclick="openTree('monitor', this)" />
    </td>
    <td>
	<a href="monitor_info.jsp" >Monitor</a><br />
        <div id="monitor" style="display:none">
            <a href="monitor_modify.jsp" class="sub">Modify</a>
        </div>
    </td>
</tr>
<%
	}
	if ( sessionTimeout == null && cd.other_ip != null ) {
%>
<tr>
    <td></td> 
    <td><a href="redundant_info.jsp">Redundancy</a></td>
</tr>
<%
	}
	if ( (sessionTimeout == null) && 
			( repStatus != ReplicationStatus.SINGLE ) ){
%>
<tr>
    <td> 
        <img class="icon" src="images/plus.gif" onclick="openTree('replication', this)" />
    </td>
    <td>
        <a href="replication.jsp">Replication</a><br />
        <div id="replication" style="display:none">
            <a href="replication_modify.jsp" class="sub">Modify</a>
        </div>
    </td>
</tr>
<%
	}
	if (sessionTimeout == null){
%>
<tr>
    <td></td> 
    <td><a href="save.jsp">Save Resources</a></td>
</tr>
<%
	}
	if ( (sessionTimeout == null) && 
		( (cd.self_status == ClusterStatus.ACTIVE ) || (cd.self_status == ClusterStatus.STANDBY) ) ){
%>
<tr>
    <td></td> 
    <td><a href="sync.jsp">Sync Resources</a></td>
</tr>
<%
	}
	if ( (sessionTimeout == null) && ( snmpStatus == SnmpAgentStatus.CONNECTING ) ){
%>
<tr>
    <td></td> 
    <td><a href="snmp.jsp">SNMP Agent</a></td>
</tr>
<%
	}

%>
<tr>
    <td> 
        <img class="icon" src="images/plus.gif" onclick="openTree('log', this)" />
    </td>
    <td>
        <a href="log_top.jsp" >Log</a><br />
        <div id="log" style="display:none">
            <a href="log_lb.jsp" class="sub">Load balancer</a><br />
            <a href="log_adm.jsp" class="sub">Admin command</a><br />
            <a href="log_directord.jsp" class="sub">Monitor RealServer</a><br />
            <%if ( snmpStatus == SnmpAgentStatus.CONNECTING ){ 
            %>
            <a href="log_snmp.jsp" class="sub">SNMP Agent</a><br />
            <%
            }
            %>
            <a href="log_gui.jsp" class="sub">GUI</a><br />
            <%if ( (cd.self_status == ClusterStatus.ACTIVE) || (cd.self_status == ClusterStatus.STANDBY) ){ %>
            <a href="log_sync.jsp" class="sub">Sync</a><br />
            <%
            }
            if ( cd.self_status != ClusterStatus.SINGLE ) { 
            %>
            <a href="log_ha.jsp" class="sub">Cluster</a>
            <%
            }
            %>
        </div>
    </td>
</tr>

<tr>
    <td>
        <img class="icon" src="images/plus.gif" onclick="openTree('manageusers', this)" />
    </td>
    <td>
        <a href="user_manage.jsp">Manage Users</a><br />
        <div id="manageusers" style="display:none">
         <%
         	if (userCount < 16){
         %>
            <a href="user_add.jsp" class="sub">Add</a><br />
         <%
         	}
         %>   
            <a href="user_modify.jsp" class="sub">Modify</a><br />
        </div>
        
    </td>
</tr>

<tr>
<td>&nbsp;</td>
</tr>
<tr>
    <td></td>
    <td><a href="logout.jsp">Logout</a></td>
</tr>


</table>

</div>
