
<%@ page import="org.ultramonkey.l7.model.*,
				 org.ultramonkey.l7.controller.*,
				 org.ultramonkey.l7.view.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%
	/*
	 * check session
 	 */
 	L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41371, LogCategorySet.GUI_USER_AUTHENTICATION, Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get result message
	 */
	MessageView message = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
	String errorMessage = "";
	int errorNumber = 0;
	String category = "";
	if (message != null) {
		errorMessage = message.getMessage();
		errorNumber = message.getErrno();
		category = message.getCategory();
		session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
	}
		
	/*
	 * get command message
	 */
	MessageView commandmessage = (MessageView) session.getAttribute(SessionKeys.COMMAND_MESSAGE);
	String commandMessage = "";
	int commandNumber = 0;
	String commandCategory = "";
	if (commandmessage != null) {
		commandMessage = commandmessage.getMessage();
		commandNumber = commandmessage.getErrno();
		commandCategory = commandmessage.getCategory();
		session.setAttribute(SessionKeys.COMMAND_MESSAGE, null);
	}	
	
	/*
	 * get validation error message
	 */
	String invalidMessage = "";
	invalidMessage = (String)session.getAttribute(SessionKeys.INVALID_MESSAGE);
	session.setAttribute(SessionKeys.INVALID_MESSAGE, null);

	/*
	 * get SnmpAgentData
	 */
	SnmpAgentData input_snmp = (SnmpAgentData)session.getAttribute(SessionKeys.INPUT_SNMP);
	String unit_snmpInterval = (String)session.getAttribute(SessionKeys.INPUT_SNMP_UNIT);
	SnmpAgentData snmp = new SnmpAgentData();
	L7guiFramework framework = new L7guiFramework();

	//from session
	if(input_snmp != null){
		snmp = input_snmp ;			
	}
	//from Framework
	else{
		snmp = framework.getSnmpAgentData();
		if ( snmp == null ){
			MessageView error = new MessageView(41372, LogCategorySet.GUI_SNMP, Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			return;
		}
		if((snmp.interval >= 1) && (snmp.interval <= 999)){
			unit_snmpInterval = "ms";
		}
		else if(snmp.interval >= 1000){
			unit_snmpInterval = "s";
			snmp.interval /= 1000;
		}
		else{
			unit_snmpInterval = "ms";
		}
	}			
	session.setAttribute(SessionKeys.INPUT_SNMP, null);
	session.setAttribute(SessionKeys.INPUT_SNMP_UNIT, null);
	
	/*
	 * get cluster status
	 */
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41373, LogCategorySet.GUI_IO_COMMAND, Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	
	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}

%>



<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
	 	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	 	<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Expires" content="0"> 	 	
		<meta http-equiv="Content-Script-Type" content="text/javascript" />
		<meta http-equiv="Content-Style-Type" content="text/css" />
		<script src="l7gui.js" type="text/javascript"></script>
		<noscript> 
			<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
		</noscript> 
		<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
		<link rel="shortcut icon" href="images/favicon.ico" />
		<title>SNMP Agent</title>
	</head>

	<body class="normal">

	<jsp:include page="menu.jsp" flush="false"/>

	<div id ="content">
	<h1 class="title">SNMP Agent</h1>

	<%
		if (message != null) {
	%>	
		<p class="error">[<%=category %>-<%=errorNumber %>]</p>
		<p class="error"><%=errorMessage %></p>
	<%
		}
	%>
	<%
		if (commandmessage != null) {
	%>	
		<p class="success">[<%=commandCategory %>-<%=commandNumber %>]</p>
		<p class="success"><%=commandMessage %></p>
	<%
		}
	%>

	<form method="post" action="SnmpAgentServlet" name="snmp" >

	<fieldset>
	<legend>SNMP Agent Current Status</legend>
	<table class="status">
	<tr>	
		<th>
			<label for="snmp_interval">Query Interval</label>
		</th>
		<td>
			<%		
				if((null != invalidMessage) && (snmp.interval == 1)){
					out.print("<input type=\"text\" maxlength=\"3\" id=\"snmp_interval\" value=\"\" name=\"snmp_interval\" size=\"3\" />");
				}
				else if(invalidMessage != null){					
					out.print("<input type=\"text\" maxlength=\"3\" id=\"snmp_interval\" value=\"" + snmp.interval + "\"name=\"snmp_interval\" size=\"3\" />");					
				}
				else{
					out.print("<input type=\"text\" maxlength=\"3\" id=\"snmp_interval\" value=\"" + snmp.interval + "\"name=\"snmp_interval\" size=\"3\" />");					
				}
			%> 

     		<select id="snmp_interval" name="unit_interval">
      			<option value="ms" <%if (unit_snmpInterval.equals("ms"))
      			out.print("selected");%>>msec</option>
       			<option value="s"<%if (unit_snmpInterval.equals("s"))
      			out.print("selected");%>>sec</option>
    		</select>
    		<% 
				if( null != invalidMessage ){
					out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
				}
			%>	
  		</td>
  		<td>
			<p class="required">1-999(msec/sec)</p>
		</td> 		
  	</tr>
	</table>
	</fieldset>

	<input type="submit" name="button" value="<%=ButtonMode.SAVE %>" onClick="return confirm(snmp_save)" />
	<%
	if (cd.self_status == ClusterStatus.ACTIVE || cd.self_status == ClusterStatus.STANDBY) {
	%>
	<input type="submit" name="button" value="<%=ButtonMode.SAVESYNC %>" onClick="return confirm(snmp_savesync)" />
	<%
	}
	%>

	</form>
	<%-- // Delete  when SNMP Agent finish.--%>
	<% if (snmp.status == SnmpAgentStatus.CONNECTING) { %>
	<h2> MIB Download</h2>
	<h4>Please push the following button,if you would like to download the SNMP MIB related to the UltraMonkey-L7.</h4>
	<form action="MIB.zip">
	<input type="submit" value="Download" />
	</form>	
	<%
	}
	%>

</div>
</body>
</html>

