<%@ page import="org.ultramonkey.l7.model.*, org.ultramonkey.l7.controller.*,org.ultramonkey.l7.view.*,java.util.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%
	 /*
	 * check session
	 */
	if (session.isNew()) {
		MessageView error = new MessageView(41352,
		LogCategorySet.GUI_USER_AUTHENTICATION,
		Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get result message
	 */
	MessageView message = (MessageView) session
			.getAttribute(SessionKeys.RESULT_MESSAGE);
	String errorMessage = null;
	int errorNumber = 0;
	String category = null;
	if (message != null) {
		errorMessage = message.getMessage();
		errorNumber = message.getErrno();
		category = message.getCategory();
		session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
	}


	// get ValidationError Message
	String invalidMessage = null;
	invalidMessage = (String) session
			.getAttribute(SessionKeys.INVALID_MESSAGE);
	session.setAttribute(SessionKeys.INVALID_MESSAGE, null);
			
	// get replicationData
	L7guiFramework framework = new L7guiFramework();
	ReplicationData rep = (ReplicationData)session.getAttribute(SessionKeys.INPUT_REP);
	
	if (null == rep){
		rep = framework.getReplicationData();
	}
	
	if (null == rep) {
		MessageView error = new MessageView(41353,
		LogCategorySet.GUI_IO, Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get cluster status
	 */
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41354, LogCategorySet.GUI_IO_COMMAND,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	
	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}
%>



<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Expires" content="0"> 		
		<meta http-equiv="Content-Script-Type" content="text/javascript" />
		<meta http-equiv="Content-Style-Type" content="text/css" />
		<script src="l7gui.js" type="text/javascript"></script>
		<noscript> 
    	<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
  		</noscript> 
		<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
		<link rel="shortcut icon" href="images/favicon.ico"/>

		<title>Modify Replication Status</title>

	</head>

	<body class="normal">
	<jsp:include page="menu.jsp" flush="false"/>

	<div id="content">


	<h1>Modify Replication Status</h1>

	<%
	if ( (message != null) && (errorMessage != null) ) {
	%>	
		<p class="error">[<%=category%> - <%=errorNumber%>]</p>
		<p class="error"><%=errorMessage%></p>	
	<%
		}
		%>

	<form method="post" action="ReplicationInfoChangeServlet" name="rep_mod" >

	<fieldset>
	<legend>Replication Current Status</legend>
	<table class="status">
	<tr>
		<th>
			<label for="rep_interval">Interval</label>
		</th>
		<td>
			<% 
			if ( ( null != invalidMessage ) && ( 0 == rep.interval ) ){
			%>	
				<input type="text" id="rep_interval" value="" name="rep_interval" size="3" />
			[&#181;sec]
			<%	
			}
			else{
			%>
    			<input type="text" id="rep_interval" value="<%= rep.interval %>" size="3" name="rep_interval" />
    		[&#181;sec]
    		<%
    		}
    		if (null != invalidMessage) {
    		%>
					<p class="invalid"> <%=invalidMessage%></p>
			<%
			}
			%>				
  		</td>
  		<td>
			<p class="required">10-10000(usec)</p>
		</td> 		
  	</tr>
	</table>
	</fieldset>

	<br />

	<input type="submit" name="button" value="<%=ButtonMode.SAVE %>" onClick="return confirm(replication_modify_save)" />	
	<%
			if (cd.self_status == ClusterStatus.ACTIVE
			|| cd.self_status == ClusterStatus.STANDBY) {
		%>
	<input type="submit" name="button" value="<%=ButtonMode.SAVESYNC %>" onClick="return confirm(replication_modify_savesync)" />
	<%
	}
	%>
	</form>
	</div>
	</body>
</html>
