<%@ page import="org.ultramonkey.l7.model.*, org.ultramonkey.l7.controller.*, org.ultramonkey.l7.view.*, java.util.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%

	/*
	 * check session
 	 */
	if (session.isNew()) {
	MessageView error = new MessageView(41398, LogCategorySet.GUI_USER_AUTHENTICATION,
			Message.INVALID_SESSSION);
	session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
	response.sendRedirect(RedirectPages.LOGIN);
	return;
	}

	/*
	 * get result message
	 */
	MessageView message = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
	String errorMessage = null;
	int errorNumber = 0;
	String category = "";
	if ( (message != null) && (errorMessage != null) ) {
		errorMessage = message.getMessage();
		errorNumber = message.getErrno();
		category = message.getCategory();
		session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
	}

	/*
	 * get l7vsadm data from L7guiFramework
	 */
	L7guiFramework framework = new L7guiFramework();
	L7vsAdmData admDataList = framework.getAdmData();
	if (admDataList == null) {
		MessageView error = new MessageView(41399, LogCategorySet.GUI_VIRTUALSERVICE,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get directord data from L7guiFramework
	 */
	DirectorData dd = framework.getDirectorData();
	if (dd == null){
		MessageView error = new MessageView(41400, LogCategorySet.GUI_IO_FILE,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	
	String checkTimeout = dd.checkTimeOut;
	if ( (checkTimeout == null) || (checkTimeout.length() == 0) )
		checkTimeout = "-";
	else 
		checkTimeout = checkTimeout + " [sec]";
	
	String negotiateTimeOut = dd.negotiateTimeOut;
	if ( (negotiateTimeOut == null) || (negotiateTimeOut.length() == 0) )
		negotiateTimeOut = "-";
	else 
		negotiateTimeOut = negotiateTimeOut + " [sec]";

	String checkInterval = dd.checkInterval;
	if ( (checkInterval == null) || (checkInterval.length() == 0) )
		checkInterval = "-";
	else 
		checkInterval = checkInterval + " [sec]";
	
	String checkCount = dd.checkCount;
	if ( (checkCount == null) || (checkCount.length() == 0) )
		checkCount = "-";
	else 
		checkCount = checkCount + " [times]";

	String callback = dd.callback;
	if ( (callback == null) || (callback.length() == 0) )
		callback = "-";

	String fallback = dd.fallback;
	if ( (fallback == null) || (fallback.length() == 0) )
		fallback = "-";
	
	String logFile = dd.logfile;
	if ( (logFile == null) || (logFile.length() == 0) )
		logFile = "-";
	String execute = dd.execute;
	if ( (execute == null) || (execute.length() == 0) )
		execute = "-";
	
	String supervised = dd.supervised;
	if ( (supervised == null) || (supervised.length() == 0) )
		supervised = "-";
	
	String quiescent = dd.quiescent;
	if ( (quiescent == null) || (quiescent.length() == 0) )
		quiescent = "-";
	
	
	/*
	 * get cluster status and fix css seat
	 */
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41401, LogCategorySet.GUI_IO_COMMAND,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}	

	// IP CHECK
	String selfIp = cd.self_ip;
	String otherIp = cd.other_ip;
	
	if ( selfIp == null )
		selfIp = "";
	if (otherIp == null )
		otherIp = "";

	
	/*
	 * get snmpAgent Data
	 */
	SnmpAgentData snmp = framework.getSnmpAgentData();
	if ( snmp == null ) {
		MessageView error = new MessageView(41402, LogCategorySet.GUI_IO_COMMAND,
				Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	int query = snmp.interval;
	String queryUnit = "[msec]";
	if (query > 1000){
		query = query / 1000 ;
		queryUnit = "[sec]";
	}
	
	/*
	 * get replication Data
	 */
	ReplicationData rep = framework.getReplicationData();
	if ( rep == null ) {
		MessageView error = new MessageView(41403, LogCategorySet.GUI_IO_COMMAND,
				Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}	
	ReplicationStatus repStatus = rep.replicationMode;
	String printRepStatus = null;
	switch (repStatus){
		case MASTER:
			printRepStatus = "Master Running";
			break;
		case SLAVE:
			printRepStatus = "Slave Running";
			break;
		case MASTER_STOP:
			printRepStatus = "Master Stopped";
			break;
		case SLAVE_STOP:
			printRepStatus = "Slave Stopped";
			break;
		case SINGLE:
			printRepStatus = "Replication Invalid";
			break;
		case OUT:
			printRepStatus = "In Starting Replication";
			break;
		default :
			MessageView error = new MessageView(41404, LogCategorySet.GUI_IO_COMMAND,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			return;
	}


		
	/*
	 * get process status
	 */
	String l7vsdStatus = "Out of Service";
	String l7vsdClass = "error";
	String l7direcotordStatus = "Out of Service";
	String l7directordClass = "error";
	String snmpAgentStatus = "Out of Service";
	String snmpAgentClass = "error" ;
	String replicationStatus = "Out of Service";
	String replicationClass = "side_error";
	String clusterStatus = null;
	String clusterClass = "error";
	
	// fix l7vsd Status
	if ( framework.getL7vsdProcessStatus() ){
		l7vsdStatus = "In Service";
		l7vsdClass = "ins";
	}
	
	// fix l7direcotord Status
	if ( framework.getL7directordProcessStatus() ){
		l7direcotordStatus = "In Service";
		l7directordClass = "ins";
	}
	
	// fix snmpAgent Status
	if ( snmp.status == SnmpAgentStatus.CONNECTING ){ 
		snmpAgentStatus = "In Service";
		snmpAgentClass = "ins";
	}

	// fix replication Status
	if ( rep.replicationMode != ReplicationStatus.SINGLE && rep.replicationMode != ReplicationStatus.OUT ){
		replicationStatus = "In Service";
		replicationClass = "side_ins";
	}
	
	// fix Cluster Status
	if ( (cd.self_status.equals(ClusterStatus.ACTIVE)) || (cd.self_status.equals(ClusterStatus.STANDBY)) ){
		clusterStatus = "In Service";
		if (cd.self_status.equals(ClusterStatus.ACTIVE) )
			clusterClass = "ins";
	}
	
		
	/*
	 * fix css seat
	 */	
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}

%>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
	 	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta http-equiv="Content-Script-Type" content="text/javascript" />
		<meta http-equiv="Content-Style-Type" content="text/css" />
		<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Expires" content="0"> 
		<script src="l7gui.js" type="text/javascript"></script>
		<noscript> 
			<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
		</noscript> 
		<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
		<link rel="shortcut icon" href="images/favicon.ico" />
		<title>GUI Console TOP</title>
	</head>


	<body class="normal">
	<jsp:include page="menu.jsp" flush="false"/>


	<div id="content">

	<h1>GUI Console TOP</h1>
	<h2> UltraMonkey-L7 Service</h2>

		<fieldset class="">
		<legend>UltraMoneky-L7 Service : Current status</legend>
	
			<table class="infotable">
			<%
			if (clusterStatus != null){
			%>
				<tr>
				<th class="head" colspan="4">
				<label for="UltraMoneky-L7">UltraMoneky-L7</label>
				</th>
				<th class="head">
				<label for="HA Cluster">HA Cluster</label>
				</th>				
				</tr>
			<%
			}
			%>
			<tr>
				<th>
				<label for="l7vsdStatus">l7vsd</label>
				</th>
				<th>
				<label for="l7directord">l7directord</label>
				</th>
				<th>
				<label for="SNMPAgent">SNMPAgent</label>
				</th>
				<th class="point">
				<label for="Replication">Replication</label>
				</th>
				<%
				if (clusterStatus != null){
				%>
					<th>
					<label for="Heartbeat2">Heartbeat2</label>
					</th>
				<%
				}
				%>
			</tr>
			<tr>
				<td class="<%=l7vsdClass %>"><%=l7vsdStatus %></td>
				<td class="<%=l7directordClass %>"><%=l7direcotordStatus %></td>
				<td class="<%=snmpAgentClass %>"><%=snmpAgentStatus %></td>
				<td class="<%=replicationClass %>"><%=replicationStatus %></td>
				<% if (cd.self_status == ClusterStatus.ACTIVE || cd.self_status == ClusterStatus.STANDBY){
				%>
				<td class="<%=clusterClass %>"><%= clusterStatus %></td>
				<%
				}
				%>
			</tr>
		</table>
		</fieldset>


	<h2>Redundancy</h2>
		<fieldset class="">
		<legend>Redundancy : Current Status</legend>

			<table class="infotable">
			<tr>
				<th class="point">
				<label for="empty"></label>
				</th>
				<th>
				<label for="nodeStatus">Node Status</label>
				</th>
				<th>
				<label for="realIp">Real IP Address</label>
				</th>
			</tr>
			<tr>
				<td class="left_point">
				Self Node
				</td>
				<td class="center">
				<%= cd.self_status %>
				</td>
				<td class="center">
				<%= selfIp %>
				</td>
			</tr>
				<% if (cd.self_status != ClusterStatus.SINGLE){
				%>
				<tr>
				<td class="left_point">
				Peer Node
				</td>
				<td class="center">
				<%= cd.other_status %>
				</td>
				<td class="center">
				<%= otherIp %>
				</td>
				</tr>
				<% }
				%>
			</table>
		</fieldset>


	<h2> VirtualService</h2>
	<% if ( (cd.self_status.equals(ClusterStatus.ACTIVE)) || (cd.self_status.equals(ClusterStatus.SINGLE) )){
	%>
	<%
		/*
		 * get VirtualService data from L7guiFramework
		 */
		Vector<VirtualSetting> vsList = new Vector<VirtualSetting>();
		vsList = admDataList.virtualSettings;
		ArrayList<String> vsNameList = new ArrayList<String>();	
		vsNameList.clear();
	
		String vsIp  = null;
		String vsPort = null;
		String vsProtomod = null;
		String vsOption = null;
		String vsSchedule = null;
		String rsIP = null;
		String rsPort = null;
		int rsWeight = 0;
		long activeConnections = 0;
		long inactiveConnections = 0;
		String vsSorryFlag = null;
	
		if ( vsList.size() > 0 ){
	%>
			<fieldset class="">
			<legend>VirtualService : Current Status</legend>
				<table class="infotable" cellspacing="0">
				<tr>
					<th class="head" colspan="5">
					<label for="VirtualService">VirtualService</label>
					</th>
					<th class="head" colspan="5">
					<label for="RealServices">RealServer</label>
					</th>
					<th rowspan="2">
					<label for="SorryFlag">Sorry Flag</label>
					</th>
				</tr>
				<tr>
					<th>
					<label for="VirtualIP Address">VirtualIP Address</label>
					</th> 
					<th>
					<label for="Port Number">Port Number</label>
					</th>
					<th>
					<label for="Persistence Type">Persistence Type</label>
					</th>
					<th>
					<label for="Module option">Module Option</label>
					</th>
					<th class="point">
					<label for="Scheduler Type">Scheduler Type</label>
					</th>
					<th>
					<label for="RealServer IP Address">IP Address</label>						
					</th>
					<th>
					<label for="RealServer Port Number">Port Number</label>									
					</th>
					<th>
					<label for="RealServer weight">Weight</label>												
					</th>
					<th>
					<label for="ActiveConnections">Active Connections</label>												
					</th>
					<th class="point">
					<label for="InactiveConnections">Inactive Connections</label>												
					</th>					
				</tr>
			<% 
				for (int i = 0; i < vsList.size(); i++) {
					try {
						VirtualSetting getVirtualSetting = vsList.get(i);
				
						vsIp = getVirtualSetting.virtual.host;
						vsPort = getVirtualSetting.virtual.port;
						vsProtomod = getVirtualSetting.protomod;
						vsOption = getVirtualSetting.option;
						vsSchedule = getVirtualSetting.sched;
				
						Vector<EndPoint> getRsList =getVirtualSetting.real;
						int rsNumber = getRsList.size();
						if ( rsNumber < 0 ){
							rsNumber = 1;
						}
	
						boolean vsSorry = getVirtualSetting.sorryflag;
						
						if ( (vsIp == null) || (vsProtomod == null) || (vsOption == null) ){
							MessageView error = new MessageView(41405, LogCategorySet.GUI_VIRTUALSERVICE,
							Message.UNEXPECTED_ERROR);
							session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
							response.sendRedirect(RedirectPages.LOGIN);
							return;
						}
			%>
				<tr>
					<td class="center" rowspan="<%=rsNumber %>"><%=vsIp%></td>
					<td class="center" rowspan="<%=rsNumber %>"><%=vsPort%></td>
					<td class="center" rowspan="<%=rsNumber %>"><%=vsProtomod%></td>
					<td class="center" rowspan="<%=rsNumber %>"><%=vsOption%></td>
					<td class="point" rowspan="<%=rsNumber %>"><%=vsSchedule%></td>
				<%
					if ( rsNumber < 1 ){
				%>
						<td class="center">-</td>
						<td class="center">-</td>
						<td class="center">-</td>
						<td class="center">-</td>
						<td class="point">-</td>						
				<%
					}
					else{
						EndPoint getRs = getRsList.get(0);
						rsIP = getRs.host;
						rsPort = getRs.port;
						rsWeight = getRs.weight;
						activeConnections = getRs.actConn;
						inactiveConnections = getRs.inActConn;
				%>
						<td class="center"><%=rsIP%></td>
						<td class="center"><%=rsPort%></td>
						<td class="center"><%=rsWeight%></td>
						<td class="center"><%=activeConnections%></td>
						<td class="point"><%=inactiveConnections%></td>						
				<%
					}
					if(vsSorry == true){
						vsSorryFlag = "On";
					}
					else {
						vsSorryFlag = "Off";
					}
				%>
				<td class="center" rowspan="<%=rsNumber %>"><%=vsSorryFlag %></td>
				</tr>
				<%
					for ( int j = 1; j < rsNumber; j++ ){
						EndPoint addedGetRs = getRsList.get(j);
						rsIP = addedGetRs.host;
						rsPort = addedGetRs.port;
						rsWeight = addedGetRs.weight;
						activeConnections = addedGetRs.actConn;
						inactiveConnections = addedGetRs.inActConn;
				%>
				<tr>
						<td class="center"><%=rsIP%></td>
						<td class="center"><%=rsPort%></td>
						<td class="center"><%=rsWeight%></td>
						<td class="center"><%=activeConnections%></td>
						<td class="point"><%=inactiveConnections%></td>					
				</tr>
				<%
					}
				%>
	
				<%
					}catch(NullPointerException e){
						MessageView error = new MessageView(41406, LogCategorySet.GUI_VIRTUALSERVICE,
								Message.UNEXPECTED_ERROR);
						session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
						response.sendRedirect(RedirectPages.LOGIN);
						return;
					}
				}
				%>
				</table>
			</fieldset>
		<%
		}
		else {
		%>
			<p class="error">No VirtualService List</p>
		<%
		}
	}
	else{
		%>
		<p class="error">No VirtualService List</p>
		<%
	}
		%>

	<h2>Monitor</h2>
		<fieldset class="">
		<legend>Monitor : Current Status</legend>
			<table class="infotable">
			<tr>
				<th>
				<label for="checkTimeOut">CheckTimeOut</label>
				</th>
				<th>
				<label for="negotiateTimeOut">NegotiateTimeOut</label>
				</th>
				<th>
				<label for="checkInterval">CheckInterval</label>
				</th>
				<th>
				<label for="checkCount">CheckCount</label>
				</th>
				<th>
				<label for="quiescent">Quiescent</label>
				</th>
			</tr>
			<tr>
				<td class="center"><%=checkTimeout%></td>
				<td class="center"><%=negotiateTimeOut%></td>
				<td class="center"><%=checkInterval%></td>
				<td class="center"><%=checkCount%></td>
				<td class="center"><%=quiescent%></td>
			</tr>
		</table>
		</fieldset>


	<%
	if (snmp.status == SnmpAgentStatus.CONNECTING) {
	%>	
	<h2>SNMP Agent</h2>
		<fieldset class="">
		<legend>SNMP Agent : Current Status</legend>
			<table class="infotable">
			<tr>
				<th>
				<label for="queryInterval">Query Interval</label>
				</th>
			</tr>
			<tr>
				<td class="center"><%=query %> <%=queryUnit %></td>
			</tr>
			</table>
		</fieldset>
	<%
	}
	%>
	
	<%
	if ( rep.replicationMode != ReplicationStatus.SINGLE ){
	%>
	<h2>Replication</h2>
		<fieldset class="">
		<legend>Replication : Current Status</legend>
			<table class="infotable">
			<tr>
				<th>
				<label for="Replication Mode">Replication Mode</label>
				</th>
				<th>
				<label for="Interval">Interval</label>
				</th>
			</tr>
			<tr>
				<td class="center"><%=printRepStatus %></td>
				<td class="center"><%=rep.interval %> [&#181;sec]</td>
			</tr>	
			</table>
			</fieldset>
	<%
	}
	%>

	</div>

</body>
</html>
