/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.MessageView;

public class L7SyncSocket {
    protected Logger debugLogger = Logger.getLogger((String)"l7sync_Connection");
    protected OutputStream outputStream;
    protected InputStream inputStream;
    protected BufferedReader bufferedReader;
    protected BufferedWriter bufferedWriter;
    protected final String SEPARATOR = "\r\n";
    protected final int ENTRY_NUMBER = 3;

    public L7SyncSocket() {
        if (this.debugLogger.isDebugEnabled()) {
            this.debugLogger.debug((Object)"11221 class L7SyncSocket created.");
        }
    }

    public void openConnection(InputStream inputStream, OutputStream outputStream) throws MessageView {
        StringBuffer buf;
        if (this.debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncSocket::openConnection(InputStream inputStream, OutputStream outputStream) throws MessageView in ");
            if (inputStream != null) {
                buf.append("inputStream= " + inputStream.toString() + ", ");
            } else {
                buf.append("inputStream= null, ");
            }
            if (outputStream != null) {
                buf.append("outputStream= " + outputStream.toString());
            } else {
                buf.append("outputStream= null");
            }
            this.debugLogger.debug((Object)("11222 " + buf.toString()));
        }
        if (inputStream == null || outputStream == null) {
            throw new MessageView(40009, "l7sync_Connection", "Invalid argument supplied for OpenConnection : null");
        }
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.outputStream));
        this.bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
        if (this.debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncSocket::openConnection(InputStream inputStream, OutputStream outputStream) throws MessageView out ");
            this.debugLogger.debug((Object)("11223 " + buf.toString()));
        }
    }

    public void sendData(String[] payloadStr) throws MessageView {
        if (this.debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncSocket::sendData(String[] payloadStr) throws MessageView in ");
            buf.append("payloadStr= ");
            if (payloadStr == null) {
                buf.append("null");
            } else {
                int i = 0;
                while (i < payloadStr.length) {
                    if (payloadStr.length - 1 == i) {
                        buf.append(payloadStr[i].toString());
                        break;
                    }
                    buf.append(String.valueOf(payloadStr[i].toString()) + ",");
                    ++i;
                }
            }
            this.debugLogger.debug((Object)("11224 " + buf.toString()));
        }
        if (payloadStr == null) {
            throw new MessageView(40010, "l7sync_Connection", "Invalid argument supplied for SendData : " + payloadStr);
        }
        try {
            int i = 0;
            while (i < payloadStr.length) {
                this.bufferedWriter.write(payloadStr[i]);
                this.bufferedWriter.write("\r\n");
                ++i;
            }
            this.bufferedWriter.write("\r\n");
            this.bufferedWriter.flush();
        }
        catch (Exception e) {
            throw new MessageView(50001, "l7sync_Connection", "Failed to send data : " + e);
        }
        if (this.debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncSocket::sendData(String[] payloadStr) throws MessageView out ");
            this.debugLogger.debug((Object)("11225 " + buf.toString()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] recvData() throws MessageView {
        if (this.debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncSocket::recvData() throws MessageView in ");
            this.debugLogger.debug((Object)("11226 " + buf.toString()));
        }
        String[] readDataArray = null;
        try {
            readDataArray = new String[3];
            int i = 0;
            while (true) {
                String readStr;
                if ((readStr = this.bufferedReader.readLine()) == null) {
                    return null;
                }
                if (readStr.length() != 0) {
                    if (i >= 3) {
                        throw new MessageView(40011, "l7sync_Connection", "Invalid receive data.");
                    }
                    readDataArray[i] = readStr;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new MessageView(50002, "l7sync_Connection", "Failed to receive data : " + e);
        }
        if (this.debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncSocket::recvData() throws MessageView out ");
            buf.append("return= ");
            if (readDataArray.length == 0) {
                buf.append("null");
            } else {
                int i = 0;
                while (i < readDataArray.length) {
                    if (readDataArray.length - 1 == i) {
                        buf.append(readDataArray[i].toString());
                        break;
                    }
                    buf.append(String.valueOf(readDataArray[i].toString()) + ",");
                    ++i;
                }
            }
            this.debugLogger.debug((Object)("11227 " + buf.toString()));
        }
        return readDataArray;
    }

    public void closeConnection() throws MessageView {
        StringBuffer buf;
        if (this.debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncSocket::closeConnection() throws MessageView in ");
            this.debugLogger.debug((Object)("11228 " + buf.toString()));
        }
        try {
            this.outputStream.close();
        }
        catch (Exception e) {
            throw new MessageView(50003, "l7sync_Connection", "Failed to close connection. :" + e);
        }
        if (this.debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncSocket::closeConnection() throws MessageView out ");
            this.debugLogger.debug((Object)("11229 " + buf.toString()));
        }
    }
}

