/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.mail.internet.MimeUtility;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.DirectorData;
import org.ultramonkey.l7.controller.L7vsConfData;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.UserData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Payload {
    protected Logger debugLogger = Logger.getLogger((String)"l7sync_Sync");
    protected Logger debugDirectorLogger = Logger.getLogger((String)"l7sync_Sync.DirectorData");
    protected Logger debugL7vsdConfLogger = Logger.getLogger((String)"l7sync_Sync.L7vsdConfData");
    protected Logger debugUserLogger = Logger.getLogger((String)"l7sync_Sync.UserData");
    protected int size;
    protected int categoryId;
    protected Object body;
    protected final String ENCODING = "base64";
    protected final String SIZE_KEY_STRING = "size=";
    protected final String CATEGORY_KEY_STRING = "category=";
    protected final String BODY_KEY_STRING = "body=";
    protected final String separator = "\r\n";
    protected final int SIZE_PADDING_NUMBER = 7;
    protected final int CATEGORY_PADDING_NUMBER = 2;
    protected final int ENTRY_NUMBER = 3;

    public Payload(String[] str) throws MessageView {
        if (this.debugLogger.isDebugEnabled()) {
            this.debugLogger.debug((Object)"11175 class Payload created.");
        }
        String sizeStr = str[0];
        String[] sizeSplit = sizeStr.split("=");
        this.size = Integer.parseInt(sizeSplit[1]);
        String categoryStr = str[1];
        String[] categorySplit = categoryStr.split("=");
        this.categoryId = Integer.parseInt(categorySplit[1]);
        String bodyStr = str[2];
        String[] bodySplit = bodyStr.split("=", 2);
        if (bodySplit[1].length() != this.size) {
            throw new MessageView(40003, "l7sync_Sync", "Failed to get data : payload");
        }
        if (1 != this.categoryId && 2 != this.categoryId) {
            this.body = this.decodeAndDeserialize(bodySplit[1]);
        }
    }

    public Payload(int categoryId, Vector<UserData> userData) throws MessageView {
        if (this.debugUserLogger.isDebugEnabled()) {
            this.debugUserLogger.debug((Object)"11176 class Payload created.");
        }
        switch (categoryId) {
            case 11: {
                this.size = 0;
                this.categoryId = categoryId;
                this.setBody(userData);
                break;
            }
            default: {
                throw new MessageView(40004, "l7sync_Sync.UserData", "Invalid category id.");
            }
        }
    }

    public Payload(int categoryId, DirectorData directorData) throws MessageView {
        if (this.debugDirectorLogger.isDebugEnabled()) {
            this.debugDirectorLogger.debug((Object)"11177 class Payload created.");
        }
        switch (categoryId) {
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                this.size = 0;
                this.categoryId = categoryId;
                this.setBody(directorData);
                break;
            }
            default: {
                throw new MessageView(40005, "l7sync_Sync.DirectorData", "Invalid category id.");
            }
        }
    }

    public Payload(int categoryId, L7vsConfData l7vsConfData) throws MessageView {
        if (this.debugL7vsdConfLogger.isDebugEnabled()) {
            this.debugL7vsdConfLogger.debug((Object)"11178 class Payload created.");
        }
        switch (categoryId) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                this.size = 0;
                this.categoryId = categoryId;
                this.setBody(l7vsConfData);
                break;
            }
            default: {
                throw new MessageView(40006, "l7sync_Sync.L7vsdConfData", "Invalid category id.");
            }
        }
    }

    protected Object getBody() {
        StringBuffer buf;
        if (this.debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("Payload::getBody() in ");
            this.debugLogger.debug((Object)("11179 " + buf.toString()));
        }
        if (this.debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("Payload::getBody() out ");
            buf.append("return= " + this.body.toString());
            this.debugLogger.debug((Object)("11180 " + buf.toString()));
        }
        return this.body;
    }

    protected void setBody(Object body) {
        StringBuffer buf;
        if (this.debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("Payload::setBody(Object body) in ");
            buf.append("body= " + body.toString());
            this.debugLogger.debug((Object)("11181 " + buf.toString()));
        }
        if (this.debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("Payload::setBody(Object body) out ");
            this.debugLogger.debug((Object)("11182 " + buf.toString()));
        }
        this.body = body;
    }

    protected String serializeAndEncode() throws MessageView {
        if (this.debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::serializeAndEncode() throws MessageView in ");
            this.debugLogger.debug((Object)("11183 " + buf.toString()));
        }
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(byteArray);
            outputStream.writeObject(this.body);
            outputStream.flush();
            outputStream.close();
            OutputStream base64OutputStream = MimeUtility.encode((OutputStream)byteArray, (String)"base64");
            byte[] serializeByte = byteArray.toByteArray();
            byteArray.reset();
            base64OutputStream.write(serializeByte);
            base64OutputStream.close();
            if (this.debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("Payload::serializeAndEncode() throws MessageView out ");
                buf.append("return= " + byteArray.toString());
                this.debugLogger.debug((Object)("11184 " + buf.toString().replaceAll("[\r\n]", "")));
            }
            return byteArray.toString().replaceAll("[\r\n]", "");
        }
        catch (Exception e) {
            throw new MessageView(40007, "l7sync_Sync", "Failed to serialize or encode.");
        }
    }

    protected Object decodeAndDeserialize(String body) throws MessageView {
        if (this.debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::decodeAndDeserialize(String body) throws MessageView in ");
            buf.append("body= " + body);
            this.debugLogger.debug((Object)("11185 " + buf.toString()));
        }
        try {
            byte[] readBytes = new byte[10000000];
            InputStream base64InputStream = MimeUtility.decode((InputStream)new ByteArrayInputStream(body.getBytes()), (String)"base64");
            base64InputStream.read(readBytes);
            ObjectInputStream inputStream = new ObjectInputStream(new ByteArrayInputStream(readBytes));
            Object result = inputStream.readObject();
            if (this.debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("Payload::decodeAndDeserialize(String body) throws MessageView out ");
                buf.append("return= " + result.toString());
                this.debugLogger.debug((Object)("11186 " + buf.toString()));
            }
            return result;
        }
        catch (Exception e) {
            throw new MessageView(40008, "l7sync_Sync", "Failed to decode or deserialize." + e);
        }
    }

    public String[] getMessage() throws MessageView {
        if (this.debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::getMessage() throws MessageView in ");
            this.debugLogger.debug((Object)("11187 " + buf.toString()));
        }
        String body = this.serializeAndEncode();
        String sizeNumber = new Integer(body.length()).toString();
        String categoryStr = new Integer(this.categoryId).toString();
        StringBuffer sizeBuffer = new StringBuffer();
        sizeBuffer.append("size=");
        sizeBuffer.append(sizeNumber);
        int count = 0;
        while (count < 7 - sizeNumber.length()) {
            sizeBuffer.insert("size=".length(), "0");
            ++count;
        }
        StringBuffer categoryBuffer = new StringBuffer();
        categoryBuffer.append("category=");
        categoryBuffer.append(categoryStr);
        int count2 = 0;
        while (count2 < 2 - categoryStr.length()) {
            categoryBuffer.insert("category=".length(), "0");
            ++count2;
        }
        StringBuffer bodyBuffer = new StringBuffer();
        bodyBuffer.append("body=");
        bodyBuffer.append(body);
        String[] messageArray = new String[]{sizeBuffer.toString(), categoryBuffer.toString(), bodyBuffer.toString()};
        if (this.debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Payload::getMessage() throws MessageView out ");
            buf.append("return= " + messageArray.toString());
            this.debugLogger.debug((Object)("11188 " + buf.toString()));
        }
        return messageArray;
    }

    public Vector<UserData> getUserData() {
        StringBuffer buf;
        if (this.debugUserLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("Payload::getUserData() in ");
            this.debugUserLogger.debug((Object)("11189 " + buf.toString()));
        }
        if (this.debugUserLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("Payload::getUserData() out ");
            buf.append("return= " + ((Vector)this.body).toString());
            this.debugUserLogger.debug((Object)("11190 " + buf.toString()));
        }
        return (Vector)this.body;
    }

    public DirectorData getDirectorData() {
        StringBuffer buf;
        if (this.debugDirectorLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("Payload::getDirectorData() in ");
            this.debugLogger.debug((Object)("11191 " + buf.toString()));
        }
        if (this.debugDirectorLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("Payload::getDirectorData() out ");
            buf.append("return= " + ((DirectorData)this.body).toString());
            this.debugDirectorLogger.debug((Object)("11192 " + buf.toString()));
        }
        return (DirectorData)this.body;
    }

    public L7vsConfData getL7vsdConfData() {
        StringBuffer buf;
        if (this.debugL7vsdConfLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("Payload::getL7vsdConfData() in ");
            this.debugL7vsdConfLogger.debug((Object)("11193 " + buf.toString()));
        }
        if (this.debugL7vsdConfLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("Payload::getL7vsdConfData() out ");
            buf.append("return= " + ((L7vsConfData)this.body).toString());
            this.debugL7vsdConfLogger.debug((Object)("11194 " + buf.toString()));
        }
        return (L7vsConfData)this.body;
    }
}

