<%@ page import="org.ultramonkey.l7.model.*,
				 org.ultramonkey.l7.controller.*,
				 org.ultramonkey.l7.view.*, java.util.*, 
				 java.io.File, java.util.Calendar, java.util.Date, java.text.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%

	/*
	 * check session
 	 */
 	L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41361, LogCategorySet.GUI_USER_AUTHENTICATION,
				Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get result message
	 */
	MessageView message = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
	String errorMessage = "";
	int errorNumber = 0;
	String category = "";
	if (message != null) {
		errorMessage = message.getMessage();
		errorNumber = message.getErrno();
		category = message.getCategory();
		session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
	}
	
	/*
	 * get command message
	 */
	MessageView commandmessage = (MessageView) session.getAttribute(SessionKeys.COMMAND_MESSAGE);
	String commandMessage = "";
	int commandNumber = 0;
	String commandCategory = "";
	if (commandmessage != null) {
		commandMessage = commandmessage.getMessage();
		commandNumber = commandmessage.getErrno();
		commandCategory = commandmessage.getCategory();
		session.setAttribute(SessionKeys.COMMAND_MESSAGE, null);
	}

	/*
	 * get save status
	 */
	String saveLogStatus = (String)session.getAttribute(SessionKeys.LOG_SAVE_STATE);
	String saveVsStatus = (String)session.getAttribute(SessionKeys.VS_SAVE_STATE);
	
	if ((saveLogStatus == null) || (saveVsStatus == null)){
		MessageView error = new MessageView(41362, LogCategorySet.GUI_USER_AUTHENTICATION,
				Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	
	if (saveLogStatus.equals(SessionKeys.SAVE)){
		saveLogStatus = "Save";
	}
	else if (saveLogStatus.equals(SessionKeys.NO_SAVE)){
		saveLogStatus = "No Save";
	}
	
	if(saveVsStatus.equals(SessionKeys.SAVE)){
		saveVsStatus = "Save";
	}
	else if (saveVsStatus.equals(SessionKeys.NO_SAVE)){
		saveVsStatus = "No Save";
	}
	
	/*
	 * get save file info
	 */
	final String logConfName = "/etc/l7vs/l7vs.cf";

	final String vsConfName = "/etc/ha.d/conf/l7directord.cf";

	File logConfFile = new File(logConfName);
	File vsConfFile = new File(vsConfName);
	String logDisplayTime  = null;
	String vsDisplayTime = null;
	long logConfTime = logConfFile.lastModified();
	long vsConfTime = vsConfFile.lastModified();

	if (logConfTime == 0){
		logDisplayTime = "-";
	}
	else{
		// get logConfTime
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.JAPAN);
		logDisplayTime = sdf.format(new Long(logConfTime));
}	

	if (vsConfTime == 0){
		vsDisplayTime = "-";
	}
	else{
		// get vsConfTime
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.JAPAN);
		vsDisplayTime = sdf.format(new Long(vsConfTime));
	}
	
	 
	/*
	 * get cluster status
	 */
	L7guiFramework framework = new L7guiFramework(); 
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41363, LogCategorySet.GUI_IO_COMMAND,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}	
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Expires" content="0"> 
		<meta http-equiv="Content-Script-Type" content="text/javascript" />
		<meta http-equiv="Content-Style-Type" content="text/css" />
		<script src="l7gui.js" type="text/javascript"></script>
		<noscript> 
    	<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
  		</noscript> 
		<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
		<link rel="shortcut icon" href="images/favicon.ico" />

		<title>Save Resources</title>
	</head>

	<body class="normal">
	<jsp:include page="menu.jsp" flush="false"/>

	<div id="content">

		<h1>Save Resources</h1>
	
		<%
			if (message != null) {
		%>
		
		<p class="error">[<%=category %>-<%=errorNumber %>]</p>
		<p class="error"><%=errorMessage %></p>
		
		<%
			}
			else if ((commandmessage != null) && (commandMessage != null) ){
		%>
		<p class="success">[<%=commandCategory %>-<%=commandNumber %>]</p>
		<p class="success"><%=commandMessage %></p>
		<%		
			}
		%>	
		
	
		<form method="post" action="SaveStateServlet">
		<fieldset class="">
		<legend>Save / No Save Info</legend>
		
		<table  class="infotable" cellspacing="0">
			<thead>
			<tr>
				<th>Save<br />CHECK</th><th>Save / No Save</th><th>Category</th><th>Description</th><th>File Name</th><th>Last Save Time</th></tr>
			</thead> 
			<tbody>
			<tr>
				<td class="center"><input type="checkbox" name="save_category" value="save_log" /></td>
				<td><%= saveLogStatus %></td>
				<td>Log</td>
				<td> Log setting<br />(except GUI &amp; Sync)</td>
				<td><%=logConfName %></td>
				<td><%=logDisplayTime %></td>
			</tr>
			<tr>
				<td class="center"><input type="checkbox" name="save_category" value="save_service" /></td>
				<td><%= saveVsStatus %></td>			
				<td>Service</td>
				<td>VirtualService settings</td>
				<td><%=vsConfName %></td>
				<td><%=vsDisplayTime %></td>
			</tr>
			</tbody>
		</table>
		</fieldset>


		<input type="submit" name="button" value="<%=ButtonMode.SAVE%>" onClick="return confirm(save)" />	
		</form>

	</div>
	</body>
</html>