package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.*;
import org.ultramonkey.l7.model.*;

/**
 * <p>
 * class MonitorSetServlet
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * <p>
 * Servlet implementation class for Servlet: MonitorSet
 * </p>
 * 
 * @author tsubone
 */
public class MonitorSetServlet extends L7guiServletBase {
	static final long serialVersionUID = 1L;

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public MonitorSetServlet() {
		super();
		// --- debug log (constructor) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11485 class MonitorSetServlet created.");
		}
		// --- debug log (constructor) ---
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf
					.append("MonitorServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
			buf.append("request=(" + request + "), ");
			buf.append("response=(" + response + ")");
			logger.debug("11486 " + buf.toString());
			request.setCharacterEncoding("UTF-8");
			logger.debug("11487 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			logger
					.debug("11488 MonitorServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf
					.append("MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
			buf.append("request=(" + request + "), ");
			buf.append("response=(" + response + ")");
			logger.debug("11489 " + buf.toString());
			request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11490 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---

		/*
		 * check login session
		 */
		super.doPost(request, response);

		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41211,
						LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);

			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger
						.debug("11491 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		/*
		 * get MonitorInfo
		 */
		request.setCharacterEncoding("UTF-8");
		HashMap<String, String[]> tmpMap = (HashMap<String, String[]>) request
				.getParameterMap();
		if (tmpMap == null) {
			MessageView error = new MessageView(41212, LogCategorySet.GUI_IO_FILE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger
						.debug("11492 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		HashMap<String, String> inputMonitorMap = new HashMap<String, String>();
		Iterator i = tmpMap.keySet().iterator();
		while (i.hasNext()) {
			String key = (String) i.next();
			inputMonitorMap.put(key, tmpMap.get(key)[0]);
		}

		L7guiFramework frame = new L7guiFramework();
		DirectorData monitorInfo = frame.getDirectorData();

		if (monitorInfo == null) {
			MessageView error = new MessageView(41213, LogCategorySet.GUI_IO_FILE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger
						.debug("11493 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		/*
		 * validation check
		 */
		boolean validationFlag = true;
		HashMap<String, String> invalidMap = new HashMap<String, String>();

		validationFlag = validationCheck(inputMonitorMap, invalidMap,
				monitorInfo);

		if (validationFlag == false) {
			MessageView error = new MessageView(21091, LogCategorySet.GUI_MONITOR,
					Message.VALIDATION_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			session.setAttribute(SessionKeys.INPUT_MONITOR, monitorInfo);
			session.setAttribute(SessionKeys.INVALID_MESSAGE, invalidMap);

			response.sendRedirect(RedirectPages.MONITOR_MODIFY);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger
						.debug("11494 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		/*
		 * choice button mode, commandExecute mode
		 */
		CommandExecuter thread = new CommandExecuter(session);

		ExecuteMode mode;
		String redirectPage;

		String button_mode = inputMonitorMap.get("button");

		// button mode : save
		if (button_mode != null && button_mode.equals(ButtonMode.SAVE)) {
			mode = ExecuteMode.DIRECTOR_SAVE;
			redirectPage = RedirectPages.MONITOR_MODIFY_EXECUTIVE;
		}

		// button mode : save and sync
		else if (button_mode != null && button_mode.equals(ButtonMode.SAVESYNC)) {
			mode = ExecuteMode.DIRECTOR_SAVESYNC;
			redirectPage = RedirectPages.SAVE_SYNC_EXECUTIVE;

			SessionTransData trans = new SessionTransData();
			trans.sourceURI = RedirectPages.MONITOR_MODIFY;
			trans.destURI = RedirectPages.MONITOR_INFO;
			trans.errorURI = RedirectPages.MONITOR_MODIFY_NG;
			session.setAttribute(SessionKeys.PAGE_TRANSDATA, trans);
		} else {
			MessageView error = new MessageView(41214, LogCategorySet.GUI_MONITOR,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger
						.debug("11495 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		try {
			thread.setExecute(mode, monitorInfo);
			thread.start();
		} catch (Exception e) {
			MessageView error = new MessageView(41215, LogCategorySet.GUI_MONITOR,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger
						.debug("11496 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		response.sendRedirect(redirectPage);
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			logger
					.debug("11497 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/**
	 * 
	 * <p>
	 * validationCheck method
	 * </p>
	 * 
	 * @param inputMonitorMap
	 * @param invalidMap
	 * @param monitorInfo
	 * @return
	 */

	protected boolean validationCheck(HashMap<String, String> inputMonitorMap,
			HashMap<String, String> invalidMap, DirectorData monitorInfo) {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf
					.append("MonitorSetServlet::validationCheck(HashMap<String, String> inputMonitorMap, HashMap<String, String> invalidMap, DirectorData monitorInfo) in ");
			buf.append("inputMonitorMap=(" + inputMonitorMap + "), ");
			buf.append("invalidMap=(" + invalidMap + "), ");
			buf.append("monitorInfo=(" + monitorInfo + ")");
			logger.debug("11498 " + buf.toString());
		}
		// --- debug log (in method) ---

		boolean validationFrag = true;

		final int MIN_CHECK_TIME_OUT = 1;
		final int MAX_CHECK_TIME_OUT = Integer.MAX_VALUE;
		final int MIN_NEGOTIATE_TIME_OUT = 1;
		final int MAX_NEGOTIATE_TIME_OUT = Integer.MAX_VALUE;
		final int MIN_CHECK_INTERVAL = 1;
		final int MAX_CHECK_INTERVAL = Integer.MAX_VALUE;
		final int MIN_CHECK_COUNT = 1;
		final int MAX_CHECK_COUNT = Integer.MAX_VALUE;
		final int CALLBACK_LENGTH = 127;
		final int FALLBACK_LENGTH = 127;
		final int LOGFILE_LENGTH = 127;
		final int EXECUTE_LENGTH = 127;

		// checkTimeOut validationCheck
		String checkTimeOut = inputMonitorMap.get("checkTimeOut");
		if (checkTimeOut != null && checkTimeOut.length() > 0) {
			int int_checkTimeOut = 0;
			try {
				int_checkTimeOut = Integer.parseInt(checkTimeOut);
				if ((int_checkTimeOut < MIN_CHECK_TIME_OUT)
						|| (int_checkTimeOut > MAX_CHECK_TIME_OUT)) {
					invalidMap.put("checkTimeOut", Message.INVALID_VALUE);
					validationFrag = false;
				}
			} catch (NumberFormatException e) {
				invalidMap.put("checkTimeOut", Message.INVALID_VALUE);
				validationFrag = false;
			}
		}
		monitorInfo.checkTimeOut = checkTimeOut;

		// negotiateTimeOut validationCheck
		String negotiateTimeOut = inputMonitorMap.get("negotiateTimeOut");
		if (negotiateTimeOut != null && negotiateTimeOut.length() > 0) {
			int int_negotiateTimeOut = 0;
			try {
				int_negotiateTimeOut = Integer.parseInt(negotiateTimeOut);
				if ((int_negotiateTimeOut < MIN_NEGOTIATE_TIME_OUT)
						|| (int_negotiateTimeOut > MAX_NEGOTIATE_TIME_OUT)) {
					invalidMap.put("negotiateTimeOut", Message.INVALID_VALUE);
					validationFrag = false;
				}
			} catch (NumberFormatException e) {
				invalidMap.put("negotiateTimeOut", Message.INVALID_VALUE);
				validationFrag = false;
			}
		}
		monitorInfo.negotiateTimeOut = negotiateTimeOut;

		// CheckInterval validationCheck
		String checkInterval = inputMonitorMap.get("checkInterval");
		if (checkInterval != null && checkInterval.length() > 0) {
			int int_checkInterval = 0;
			try {
				int_checkInterval = Integer.parseInt(checkInterval);
				if ((int_checkInterval < MIN_CHECK_INTERVAL)
						|| (int_checkInterval > MAX_CHECK_INTERVAL)) {
					invalidMap.put("checkInterval", Message.INVALID_VALUE);
					validationFrag = false;
				}
			} catch (NumberFormatException e) {
				invalidMap.put("checkInterval", Message.INVALID_VALUE);
				validationFrag = false;
			}
		}
		monitorInfo.checkInterval = checkInterval;

		// checkCount validationCheck
		String checkCount = inputMonitorMap.get("checkCount");
		if (checkCount != null && checkCount.length() > 0) {
			int int_checkCount = 0;
			try {
				int_checkCount = Integer.parseInt(checkCount);
				if ((int_checkCount < MIN_CHECK_COUNT)
						|| (int_checkCount > MAX_CHECK_COUNT)) {
					invalidMap.put("checkCount", Message.INVALID_VALUE);
					validationFrag = false;
				}
			} catch (NumberFormatException e) {
				invalidMap.put("checkCount", Message.INVALID_VALUE);
				validationFrag = false;
			}
		}
		monitorInfo.checkCount = checkCount;

		// callback validationCheck
		String callback = inputMonitorMap.get("callback");
		if (callback != null && callback.length() > 0) {
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(callback);

			if (callback.length() > CALLBACK_LENGTH || matcher.find()) {
				invalidMap.put("callback", Message.INVALID_VALUE);
				validationFrag = false;
			}
		}
		monitorInfo.callback = callback;

		// fallback validationCheck
		String fallback = inputMonitorMap.get("fallback");
		if (fallback != null && fallback.length() > 0) {
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(fallback);

			if (fallback.length() > FALLBACK_LENGTH || matcher.find()) {
				invalidMap.put("fallback", Message.INVALID_VALUE);
				validationFrag = false;
			}
		}
		monitorInfo.fallback = fallback;

		// logfile validationCheck
		String logfile = inputMonitorMap.get("logfile");
		if (logfile != null && logfile.length() > 0) {
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(logfile);

			if (logfile.length() > LOGFILE_LENGTH || matcher.find()) {
				invalidMap.put("logfile", Message.INVALID_VALUE);
				validationFrag = false;
			}
		}
		monitorInfo.logfile = logfile;

		// execute validationCheck
		String execute = inputMonitorMap.get("execute");
		if (execute != null && execute.length() > 0) {
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(execute);

			if (execute.length() > EXECUTE_LENGTH || matcher.find()) {
				invalidMap.put("execute", Message.INVALID_VALUE);
				validationFrag = false;
			}
		}
		monitorInfo.execute = execute;

		// supervised validationCheck
		String supervised = inputMonitorMap.get("supervised");
		if (supervised != null && supervised.length() > 0) {
			if (!supervised.equals("yes") && !supervised.equals("no")) {
				invalidMap.put("supervised", Message.INVALID_VALUE);
				validationFrag = false;
			}
		}
		monitorInfo.supervised = supervised;

		// quiescent validationCheck
		String quiescent = inputMonitorMap.get("quiescent");
		if (quiescent != null && quiescent.length() > 0) {
			if (!quiescent.equals("yes") && !quiescent.equals("no")) {
				invalidMap.put("quiescent", Message.INVALID_VALUE);
				validationFrag = false;
			}
		}
		monitorInfo.quiescent = quiescent;

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11499 MonitorSetServlet::validationCheck(HashMap<String, String> inputMonitorMap, HashMap<String, String> invalidMap, DirectorData monitorInfo) return=" + validationFrag);
		}
		// --- debug log (out method) ---
		return validationFrag;
	}

}
