package org.ultramonkey.l7.controller;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.*;
import java.util.regex.*;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.LogCategorySet;

/**
 * 
 * <p>
 * class ClusterController
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author tanuma
 */
public class ClusterController {

	/*
	 * TODO This class is only for Heartbeat cluster now. We have to be
	 * refactoring for any cluster software using JNDI later.
	 */

	private Logger ioCommandLogger = Logger.getLogger(LogCategorySet.GUI_IO_COMMAND);

	protected static ClusterData data = null;

	private static final String CRM_MON = "/usr/sbin/crm_mon";

	private static final String CRM_STANDBY = "/usr/sbin/crm_standby";

	private static final int CHECK_TIMEOUT = 10;
	
	private static String HB_LOG = "/var/log/ha-log";

	/**
	 * 
	 * <p>
	 * getData method
	 * </p>
	 * 
	 * @return cluster data
	 */
	public ClusterData getData() {
		// --- debug log (in method) ---
		if (ioCommandLogger.isDebugEnabled()) {
            ioCommandLogger.debug("11558 ClusterController::getData() in");
		}
		// --- debug log (in method) ---

		synchronized (this) {
			String command = CRM_MON + " -1";
			String result = runProcess(command);
	
			ClusterData data = new ClusterData();
			data.self_status = ClusterStatus.SINGLE;
			data.logFileName = HB_LOG;
	
			try {
				InetAddress local = InetAddress.getLocalHost();
				String host = local.getHostName();
				data.self_ip = local.getHostAddress();
	
				if (result != null) {
					Pattern p = Pattern.compile("^Node: ([^ ]+)[^:]+: (\\w+)$",
							Pattern.MULTILINE);
					Matcher m = p.matcher(result);
					while (m.find()) {
						if (host.equals(m.group(1))) {
							data.self_hostname = m.group(1);
							data.self_ip = local.getHostAddress();
							if ("OFFLINE".equals(m.group(2)))
								data.self_status = ClusterStatus.OUT_OF_SERVICE;
							else if ("online".equals(m.group(2)))
								data.self_status = ClusterStatus.STANDBY;
							else if ("standby".equals(m.group(2)))
								data.self_status = ClusterStatus.OUT_OF_SERVICE;
							else
								data.self_status = ClusterStatus.SINGLE;
						} else {
							data.other_hostname = m.group(1);
							try {
								data.other_ip = InetAddress.getByName(m.group(1))
										.getHostAddress();
							} catch (UnknownHostException e) {
								ioCommandLogger.info("21100 name resolution failed: " + m.group(1));
								data.other_ip = null;
							}
							if ("OFFLINE".equals(m.group(2)))
								data.other_status = ClusterStatus.OUT_OF_SERVICE;
							else if ("online".equals(m.group(2)))
								data.other_status = ClusterStatus.STANDBY;
							else if ("standby".equals(m.group(2)))
								data.other_status = ClusterStatus.OUT_OF_SERVICE;
							else
								data.other_status = ClusterStatus.SINGLE;
						}
					}
					p = Pattern.compile("Started ([-\\.\\w]+)$", Pattern.MULTILINE);
					m = p.matcher(result);
					while (m.find()) {
						if (m.group(1).equals(data.self_hostname)
								&& data.self_status == ClusterStatus.STANDBY)
							data.self_status = ClusterStatus.ACTIVE;
						else if (m.group(1).equals(data.other_hostname)
								&& data.other_status == ClusterStatus.STANDBY)
							data.other_status = ClusterStatus.ACTIVE;
					}
				}
			} catch (Exception e) {
				ioCommandLogger.error("41242 Exception occured: " + e.getMessage());
				data = null;
			}

			// --- debug log (in method) ---
			if (ioCommandLogger.isDebugEnabled()) {
				StringBuffer buf = new StringBuffer();
				buf.append("ClusterController::getData() out ");
				buf.append("return=(" + data + ")");
				ioCommandLogger.debug("11559 " + buf.toString());
			}
			// --- debug log (in method) ---
			return data;
		}
	}

	/**
	 * 
	 * <p>
	 * setData method
	 * </p>
	 * 
	 * @param cd
	 */
	public void setData(ClusterData cd) {
		// --- debug log (in method) ---
		if (ioCommandLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
			buf.append("ClusterController::setData(ClusterData cd) in ");
			buf.append("cd=(" + cd + ")");
			ioCommandLogger.debug("11560 " + buf.toString());
		}
		// --- debug log (in method) ---

		synchronized (this) {
			data = cd;
		}
		
		// --- debug log (in method) ---
		if (ioCommandLogger.isDebugEnabled()) {
			ioCommandLogger.debug("11561 ClusterController::setData(ClusterData cd) out");
		}
		// --- debug log (in method) ---
	}

	/**
	 * 
	 * <p>
	 * changeClusterMode method
	 * </p>
	 * 
	 * @return result of switch over.
	 */
	public boolean changeClusterMode() {
		// --- debug log (in method) ---
		if (ioCommandLogger.isDebugEnabled()) {
            ioCommandLogger.debug("11562 ClusterController::changeClusterMode() in");
		}
		// --- debug log (in method) ---

		synchronized (this) {
			// get current status
			ClusterData data = this.getData();
			String command = null;
			boolean self_flag = true;
	
			if (data != null && data.self_status == ClusterStatus.ACTIVE
					&& data.other_status == ClusterStatus.STANDBY) {
				self_flag = true;
				command = CRM_STANDBY + " -U " + data.self_hostname + " -v on";
			} else if (data != null && data.other_status == ClusterStatus.ACTIVE
					&& data.self_status == ClusterStatus.STANDBY) {
				self_flag = false;
				command = CRM_STANDBY + " -U " + data.other_hostname + " -v on";
			} else {
				ioCommandLogger.error("41243 Invalid status: " + data);
				// --- debug log (out method) ---
				if (ioCommandLogger.isDebugEnabled()) {
		            ioCommandLogger.debug("11563 ClusterController::changeClusterMode() out return=false");
				}
				// --- debug log (out method) ---
				return false;
			}
	
			// run crm_standby command
			String result = runProcess(command);
			if (result == null || result.length() != 0) {
				ioCommandLogger.error("41244 Command error: command=" + command);
				ioCommandLogger.error("41245 Command error:  result=" + result);
				// --- debug log (out method) ---
				if (ioCommandLogger.isDebugEnabled()) {
		            ioCommandLogger.debug("11564 ClusterController::changeClusterMode() out return=false");
				}
				// --- debug log (out method) ---
				return false;
			}
	
			int timeout = CHECK_TIMEOUT;
	
			while (true) {
				// reload current status
				data = this.getData();
	
				if (data == null) {
					ioCommandLogger.error("41246 Invalid status: " + data);
					// --- debug log (out method) ---
					if (ioCommandLogger.isDebugEnabled()) {
			            ioCommandLogger.debug("11565 ClusterController::changeClusterMode() out return=false");
					}
					// --- debug log (out method) ---
					return false;
				} else if (self_flag) {
					if (data.self_status == ClusterStatus.OUT_OF_SERVICE
							&& data.other_status == ClusterStatus.ACTIVE) {
						command = CRM_STANDBY + " -U " + data.self_hostname
								+ " -v off";
						break;
					}
				} else {
					if (data.other_status == ClusterStatus.OUT_OF_SERVICE
							&& data.self_status == ClusterStatus.ACTIVE) {
						command = CRM_STANDBY + " -U " + data.other_hostname
								+ " -v off";
						break;
					}
				}
	
				timeout--;
				if (timeout <= 0) {
					ioCommandLogger.error("41247 Switch-Over timeout(" + CHECK_TIMEOUT + "sec)");
					// --- debug log (out method) ---
					if (ioCommandLogger.isDebugEnabled()) {
			            ioCommandLogger.debug("11566 ClusterController::changeClusterMode() out return=false");
					}
					// --- debug log (out method) ---
					return false;
				}
	
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					ioCommandLogger.error("41248 Exception occured: " + e.getMessage());
					// --- debug log (out method) ---
					if (ioCommandLogger.isDebugEnabled()) {
			            ioCommandLogger.debug("11567 ClusterController::changeClusterMode() out return=false");
					}
					// --- debug log (out method) ---
					return false;
				}
			}
	
			// run crm_standby command
			result = runProcess(command);
			if (result == null || result.length() != 0) {
				ioCommandLogger.error("41249 Command error: command=" + command);
				ioCommandLogger.error("41250 Command error:  result=" + result);
				// --- debug log (out method) ---
				if (ioCommandLogger.isDebugEnabled()) {
		            ioCommandLogger.debug("11568 ClusterController::changeClusterMode() out return=false");
				}
				// --- debug log (out method) ---
				return false;
			}
	
			// reload current status
			data = this.getData();
	
			if (data == null) {
				ioCommandLogger.error("41251 Invalid status: null");
				// --- debug log (out method) ---
				if (ioCommandLogger.isDebugEnabled()) {
		            ioCommandLogger.debug("11569 ClusterController::changeClusterMode() out return=false");
				}
				// --- debug log (out method) ---
				return false;
			} else if (self_flag) {
				if (data.self_status != ClusterStatus.STANDBY
						|| data.other_status != ClusterStatus.ACTIVE) {
					ioCommandLogger.error("41252 Invalid status: " + data);
					// --- debug log (out method) ---
					if (ioCommandLogger.isDebugEnabled()) {
			            ioCommandLogger.debug("11570 ClusterController::changeClusterMode() out return=false");
					}
					// --- debug log (out method) ---
					return false;
				}
			} else {
				if (data.other_status != ClusterStatus.STANDBY
						|| data.self_status != ClusterStatus.ACTIVE) {
					ioCommandLogger.error("41253 Invalid status: " + data);
					// --- debug log (out method) ---
					if (ioCommandLogger.isDebugEnabled()) {
			            ioCommandLogger.debug("11571 ClusterController::changeClusterMode() out return=false");
					}
					// --- debug log (out method) ---
					return false;
				}
			}
	
			// --- debug log (out method) ---
			if (ioCommandLogger.isDebugEnabled()) {
	            ioCommandLogger.debug("11572 ClusterController::changeClusterMode() out return=true");
			}
			// --- debug log (out method) ---
			return true;
		}
	}

	/**
	 * 
	 * <p>
	 * runProcess method
	 * </p>
	 * 
	 * @param command
	 * @return result string of command execution
	 */
	protected String runProcess(String command) {
		// --- debug log (in method) ---
		if (ioCommandLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
			buf.append("ClusterController::runProcess(String command) in ");
			buf.append("command=\"" + command + "\"");
			ioCommandLogger.debug("11573 " + buf.toString());
		}
		// --- debug log (in method) ---
		synchronized (this) {
			StringBuffer result = new StringBuffer();
	
			try {
				// TODO using sudo command temporally
				Process p = Runtime.getRuntime().exec("sudo " + command);
				InputStream stderr = p.getErrorStream();
				BufferedReader br = new BufferedReader(new InputStreamReader(stderr));
				String line = null;
				while ((line = br.readLine()) != null) {
					result.append(line + "\n");
				}
				InputStream is = p.getInputStream();
				br = new BufferedReader(new InputStreamReader(is));
				while ((line = br.readLine()) != null) {
					result.append(line + "\n");
				}
			} catch (Exception e) {
				ioCommandLogger.error("41254 Exception occured: " + e.getMessage());
				result = null;
			}
	
			// --- debug log (out method) ---
			if (ioCommandLogger.isDebugEnabled()) {
	            ioCommandLogger.debug("11574 ClusterController::runProcess(String command) out return=" + result);
			}
			// --- debug log (out method) ---
			return (result == null) ? null : result.toString();
		}
	}
}
