<%@ page import="org.ultramonkey.l7.model.*,
				 org.ultramonkey.l7.controller.*,
				 org.ultramonkey.l7.view.*, java.util.*,
				 java.text.SimpleDateFormat,java.text.NumberFormat"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%
    /*
     * check session
     */
    if (session.isNew()) {
        MessageView error = new MessageView(41272, LogCategorySet.GUI_USER_AUTHENTICATION, Message.INVALID_SESSSION); 
        session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
        response.sendRedirect(RedirectPages.LOGIN);
        return;
    }

    /*
     * get result message
     */
    MessageView message = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
    String errorMessage = "";
    int errorNumber = 0;
    String category = "";
    String resultJudge = "success";
    if (message != null) {
      errorMessage = message.getMessage();
      errorNumber = message.getErrno();
      category = message.getCategory();
      session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
      if ( errorNumber >= ErrNo.ERRORNUMBER )
    	  resultJudge = "error";
    }
    
    /*
     * get command message
     */
    MessageView commandmessage = (MessageView) session.getAttribute(SessionKeys.COMMAND_MESSAGE);
    String commandMessage = "";
    int commandNumber = 0;
    String commandCategory = "";
    if (commandmessage != null) {
      commandMessage = commandmessage.getMessage();
      commandNumber = commandmessage.getErrno();
      commandCategory = commandmessage.getCategory();
      session.setAttribute(SessionKeys.COMMAND_MESSAGE, null);
    }
    
    /*
     * get ha_log info
     */
     L7guiFramework framework = new L7guiFramework();
     LogData logdata = framework.getLogData();
     
     if (logdata == null){
         MessageView error = new MessageView(41273, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
         session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
         response.sendRedirect(RedirectPages.LOGIN);
         return;
     }

     LogSet data = logdata.haLog;
     
     if (data == null){
         MessageView error = new MessageView(41274, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
         session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
         response.sendRedirect(RedirectPages.LOGIN);
         return;
     } 

     Vector<LogFileData> logfiles = data.logFiles;
     if (logfiles == null){
         MessageView error = new MessageView(41275, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
         session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
         response.sendRedirect(RedirectPages.LOGIN);
         return;
     }

     
     /*
      * get cluster status
      */
     ClusterData cd = framework.getClusterData();
     
     if (cd == null){
         MessageView error = new MessageView(41276, LogCategorySet.GUI_IO_COMMAND, Message.CLUSTER_DATA_ERROR);
         session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
         response.sendRedirect(RedirectPages.LOGIN);
     }
      
    /*
     * fix style seat
     */
    String cssSeat = "l7gui_single_style.css";
    if ( cd.self_status == ClusterStatus.ACTIVE ){
      cssSeat = "l7gui_act_style.css";
    }
    else if ( cd.self_status == ClusterStatus.STANDBY ){
      cssSeat = "l7gui_sby_style.css";
    }

%>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">

<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
   	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0"> 		
    <meta http-equiv="Content-Script-Type" content="text/javascript" />
    <meta http-equiv="Content-Style-Type" content="text/css" />
    <script src="l7gui.js" type="text/javascript"></script>
    <noscript> 
         <meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
      </noscript> 
    <link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
    <link rel="shortcut icon" href="images/favicon.ico"/>
        <title>Log - HA -</title>
    </head>

  <body class="normal">
  <jsp:include page="menu.jsp" flush="false"/>
  <div id="content">

    <h1>Log - HA (Heartbeat2) -</h1>
     <%
    if ( (message != null) && (errorMessage != null) ) {
    %>  
	    <p class="<%=resultJudge %>">[<%=category%>-<%=errorNumber%>]</p>
	    <p class="<%=resultJudge %>"><%=errorMessage%></p>
    <%
    } 
    %>
    
    <h2> Download Log File</h2>
    <h4>Please select the following list you would like to download the log file. </h4>

      <table  class="infotable" cellspacing="0">

      <tr>
      <th>LogFileName</th><th>LastUpdate</th><th>FileSize(byte)</th>
      </tr>
      
      <%
		SimpleDateFormat dfm = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
  		NumberFormat num = NumberFormat.getInstance();
      	Iterator<LogFileData> i = logfiles.iterator();
      	
        while ( i.hasNext() ){
            LogFileData log = (LogFileData) i.next();
            
            if ( log != null && log.fileName != null){
                   out.println("<tr>");
                   out.println("<td>");
                   out.println("<a href=\"LogOutputServlet?type=" + LogCategorySet.HA + "&log=" + log.fileName + "\">" + log.fileName + "</a>");
                   out.println("</td>");
                   out.println("<td class=\"center\">" + dfm.format(log.time) + "</td>");            
                   out.println("<td class=\"right\">" + num.format(log.size) + "</td>");               
                   out.println("</tr>");
            }
        }
      %>     
    </table>

  </div>
  </body>
</html>
