<%@ page import="org.ultramonkey.l7.model.*,
				 org.ultramonkey.l7.controller.*,
				 org.ultramonkey.l7.view.*, java.util.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"
%>
<%

	/*
	 * check session
 	 */
 	L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41413, LogCategorySet.GUI_USER_AUTHENTICATION,
				Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}


	/*
	 * get result message
	 */
	MessageView message = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
	String errorMessage = "";
	int errorNumber = 0;
	String  category = "";
	if (message != null) {
		errorMessage = message.getMessage();
		errorNumber = message.getErrno();
		category = message.getCategory();
		session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
	}

	/*
	 * get user info 
	 */	
	UserManager user = UserManager.getInstance();
	Vector<UserData> userList;
	try {
		userList = user.getUserList();
	}
	catch(Exception e){
		MessageView error = new MessageView(41414, LogCategorySet.GUI_IO_FILE,
		Message.READ_ERROR);
	session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
	response.sendRedirect(RedirectPages.LOGIN);
	return;
	}
	if ( userList == null ){
		MessageView error = new MessageView(41415, LogCategorySet.GUI_IO_FILE,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	int userCount = userList.size();

	/*
	 * get Input User Data
	 */
	UserData inputUser = (UserData)session.getAttribute(SessionKeys.INPUT_USERDATA);
	if ( inputUser != null ){
			session.setAttribute(SessionKeys.INPUT_USERDATA, null);
		}

	
	/*
	 * get cluster status
	 */
	L7guiFramework framework = new L7guiFramework(); 
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41416, LogCategorySet.GUI_IO_COMMAND,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}

%>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
	 	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	 	<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Expires" content="0"> 
		<meta http-equiv="Content-Script-Type" content="text/javascript" />
		<meta http-equiv="Content-Style-Type" content="text/css" />
		<script src="l7gui.js" type="text/javascript"></script>
		<noscript> 
			<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
		</noscript> 
		<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
		<link rel="shortcut icon" href="images/favicon.ico" />

			<title>Add User</title>
		</head>

		<body class="normal">
		<jsp:include page="menu.jsp" flush="false"/>

		<div id="content">

	<h1>Add User </h1>

	<% if ( userCount >= 16){
	%>
			<p class="error"><%=Message.USER_MAX %></p>
	<% 
		}
		else {
			if (message != null) {
	%>
				<p class="error">[<%=category %> - <%=errorNumber %>]</p>
				<p class="error"><%=errorMessage %></p>
				<%
					}
				%>

	<form method="post" action="UserAddServlet">
 
		<fieldset>
		<legend>Add User Info</legend>	
		<table class="status">
		<tr>
			<th>
				<label for="userId">User ID</label>
			</th>
			<td>
			<% if ( (inputUser != null) && (inputUser.userName != null) ){ %>
				<input type="text" name="userId" value="<%=inputUser.userName %>"  size="20" maxlength="16">
			<%} 
			else {%>
				<input type="text" name="userId" size="20" maxlength="16">
			<%} %>
			</td>
			<td>
				<p class="item">Required Field</p>
				<p class="required">Between 1 and 16 one-byte characters in English</p>				
			</td>
		</tr>
		<tr>
			<th>
				<label for="description">Description</label>
			</th>
			<td>
			<% if ( (inputUser != null) && (inputUser.description != null) ){ %>
				<input type="text" name="description" value="<%=inputUser.description %>" size="20" maxlength="64">	
			<% }
			else{
			%>
				<input type="text" name="description" size="20" maxlength="64">
			<%
			}
			%>
			</td>
			<td>
				<p class="required">Up to 64 one-byte characters in English</p>
			</td>
		</tr>
		<tr>
			<th>
				<label for="password">Password</label>
			</th>
			<td>
			<input type="password" name="new1_passwd" size="20" maxlength="16">
			</td>
			<td>
				<p class="item">Required Field</p>
				<p class="required">Between 6 and 16 one-byte characters in English</p>				
			</td>
		</tr>
		<tr>
			<th>
				<label for="password">Re-type Password</label>
			</th>
			<td>
			<input type="password" name="new2_passwd" size="20" maxlength="16">
			</td>
			<td>
				<p class="item">Required Field</p>
				<p class="required">Between 6 and 16 one-byte characters in English</p>				
			</td>
		</tr>
		</table>
		</fieldset>
		
	<br>
		<input type="submit" name="button" value="<%= ButtonMode.ADD %>" onClick="return confirm(user_add)" />
		<input type = "Reset" value = "Clear">
	
	</form>
	<%
	}
	%>
	</div>
	</body>
</html>
