package org.ultramonkey.l7.controller;

import java.util.*;
import java.io.Serializable;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.LogCategorySet;

/**
 * 
 * <p>class L7vsAdmData</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author tanuma
 */
public class L7vsAdmData extends VirtualSetting implements Serializable {
    static final long serialVersionUID = 1L;

    /**
     * Virtual service setting.
     */
	public Vector<VirtualSetting> virtualSettings;
	
	/**
	 * Replication status. (MASTER, MASTER_STOP, SLAVE, SLAVE_STOP, SINGLE, OUT)
	 */
	public ReplicationStatus replicationMode;
	
	/**
	 * SNMP Agent status. (CONNECTING, NON_CONNECTING)
	 */
	public SnmpAgentStatus snmpStatus;
	
	/**
	 * l7vsd log level
	 */
	public HashMap<LogData.LogCategory, LogData.LogLevel> l7vsdLogLevel;
	
	/**
	 * SNMP Agent log level
	 */
	public HashMap<LogData.LogCategory, LogData.LogLevel> snmpLogLevel;
	
	private Logger ioCommandLogger = Logger.getLogger(LogCategorySet.GUI_IO_COMMAND); 

	/**
	 * 
	 * Constructor
	 *
	 */
	public L7vsAdmData() {
        // --- debug log (constructor) ---
        if (ioCommandLogger.isDebugEnabled()) {
            ioCommandLogger.debug("11509 class L7vsAdmData created.");
        }
        // --- debug log (constructor) ---

		this.virtualSettings = new Vector<VirtualSetting>();
		this.l7vsdLogLevel = new HashMap<LogData.LogCategory, LogData.LogLevel>();
		this.snmpLogLevel = new HashMap<LogData.LogCategory, LogData.LogLevel>();
		this.replicationMode = ReplicationStatus.OUT;
		this.snmpStatus = SnmpAgentStatus.NON_CONNECTING;
	}

	/**
	 * 
	 * <p> equals method</p>
	 *
	 * @param admData
	 * @return Compares this L7vsAdmData to the specified object. 
	 * 			The result is true if and only if the argument is not null
	 * 			and is a L7vsAdmData object that represents the same field as this object. 
	 */
	public boolean equals(L7vsAdmData admData) {
        // --- debug log (in method) ---
        if (ioCommandLogger.isDebugEnabled()) {
            ioCommandLogger.debug("11510 L7vsAdmData::equals(L7vsAdmData admData) in admData=(" + admData + ")");
        }
        // --- debug log (in method) ---

		if (admData != null &&
			this.virtualSettings.equals(admData.virtualSettings) &&
			this.replicationMode == admData.replicationMode &&
			this.snmpStatus == admData.snmpStatus &&
			this.l7vsdLogLevel.equals(admData.l7vsdLogLevel) &&
			this.snmpLogLevel.equals(admData.snmpLogLevel)) {
	        // --- debug log (in method) ---
	        if (ioCommandLogger.isDebugEnabled()) {
	            ioCommandLogger.debug("11511 L7vsAdmData::equals(L7vsAdmData admData) out return=true");
	        }
	        // --- debug log (in method) ---
			return true;
		}
		
        // --- debug log (in method) ---
        if (ioCommandLogger.isDebugEnabled()) {
            ioCommandLogger.debug("11512 L7vsAdmData::equals(L7vsAdmData admData) out return=false");
        }
        // --- debug log (in method) ---
		return false;
	}
	
	/**
	 * 
	 * {@inheritDoc}
	 */
	public String toString() {
		return 
			"virtualSettings=" + this.virtualSettings + ", " +
			"replicationMode=" + this.replicationMode + ", " +
			"snmpLogLevel=" + this.snmpLogLevel + ", " +
			"l7vsdLogLevel=" + this.l7vsdLogLevel + ", " +
			"snmpLogLevel=" + this.snmpLogLevel;
	}
}
