package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.*;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.FileNotWriteException;
import org.ultramonkey.l7.model.LogCategorySet;
import org.ultramonkey.l7.model.Message;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.UserData;
import org.ultramonkey.l7.model.UserManager;

/**
 * 
 * <p>
 * class UserAddServlet
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author kubota
 */
public class UserAddServlet extends org.ultramonkey.l7.view.L7guiServletBase {
	static final long serialVersionUID = 1L;

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public UserAddServlet() {
		super();
        // --- debug log (constructor) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11321 class UserAddServlet created.");
		}
		// --- debug log (constructor) ---
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("UserAddServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11322 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			logger.debug("11323 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11324 UserAddServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11325 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11326 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---
		
		// check login session
		super.doPost(request, response);

		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41080, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11327 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

       request.setCharacterEncoding("UTF-8");
		String userId = request.getParameter("userId");
		String description = request.getParameter("description");
		String newPass1 = request.getParameter("new1_passwd");
		String newPass2 = request.getParameter("new2_passwd");
		String button_mode = request.getParameter("button");

		if ((userId == null) || (description == null) || (newPass1 == null)
				|| (newPass2 == null) || (button_mode == null)
				|| (button_mode.equals(ButtonMode.ADD) == false)) {
			MessageView error = new MessageView(41081, LogCategorySet.GUI_USER_MANAGE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11328 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		boolean validationFlag = true;
		validationFlag = validationCheck(session, userId, description,
				newPass1, newPass2);
		if (validationFlag == false) {
			UserData inputUser = new UserData();
			inputUser.userName = userId;
			inputUser.description = description;
			session.setAttribute(SessionKeys.INPUT_USERDATA, inputUser);
			response.sendRedirect(RedirectPages.USER_ADD);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11329 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		UserManager user = UserManager.getInstance();
		
		Vector<UserData> userList;
		boolean addUser = false;
		try {
			userList = user.getUserList();
			int userCount = userList.size();
			if (userCount >= 16){
				MessageView error = new MessageView(41082, LogCategorySet.GUI_IO_FILE,
						Message.USER_MAX);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				response.sendRedirect(RedirectPages.USER_ADD_FAIL);
				// --- debug log (out method) ---
				if (logger.isDebugEnabled()) {
		            logger.debug("11330 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
				}
				// --- debug log (out method) ---
				return;
			}
			
			addUser = user.addUser(userId, newPass1, 0, description);
		}
		catch (FileNotWriteException e) {
			MessageView error = new MessageView(41083, LogCategorySet.GUI_IO_FILE, Message.WRITE_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11331 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		} 
		catch(Exception e){
			MessageView error = new MessageView(41084, LogCategorySet.GUI_START_STOP,
			Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11332 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		if (addUser == true) {
			MessageView message = new MessageView(21041, LogCategorySet.GUI_USER_MANAGE,
					Message.USER_ADD_SUCCESS);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, message);
			session.setAttribute(SessionKeys.GUI_SYNC_STATE, SessionKeys.NO_SYNC);
			response.sendRedirect(RedirectPages.USER_MANAGE);
		} else {
			MessageView error = new MessageView(41085, LogCategorySet.GUI_USER_MANAGE,
					Message.SAME_USER_EXISTS);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.USER_ADD_FAIL);
		}

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11333 UserAddServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/**
	 * 
	 * <p>
	 * validationCheck method
	 * </p>
	 * 
	 * @param session
	 * @param userId
	 * @param description
	 * @param curPass
	 * @param newPass1
	 * @param newPass2
	 * @return
	 */
	protected boolean validationCheck(HttpSession session, String userId,
			String description, String newPass1, String newPass2) {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("UserAddServlet::validationCheck(HttpSession session, String userId, String description, String newPass1, String newPass2) in ");
			buf.append("session=(" + session + "), ");
			buf.append("userId=\"" + userId + "\", ");
			buf.append("description=\"" + description + "\", ");
			buf.append("newPass1=\"" + newPass1 + "\", ");
			buf.append("newPass2=\"" + newPass2);
			logger.debug("11334 " + buf.toString());
		}
		// --- debug log (in method) ---

		boolean validationFlag = true;
		final int MAX_USER_LENGTH = 16;
		final int MAX_DESCRIPTION_LENGTH = 64;
		final int MIN_PASS_LENGTH = 6;
		final int MAX_PASS_LENGTH = 16;

		Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");

		if (session == null) {
			validationFlag = false;
		} else if (userId == null || description == null || newPass1 == null || newPass2 == null) {
			MessageView error = new MessageView(21042, LogCategorySet.GUI_USER_MANAGE, Message.INVALID_VALUE);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			validationFlag = false;
		} else if ((userId.length() == 0) && (description.length() == 0)
				&& (newPass1.length() == 0) && (newPass2.length() == 0)) {
			MessageView error = new MessageView(21043, LogCategorySet.GUI_USER_MANAGE, Message.NOT_EXIST);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			validationFlag = false;
		} else if ((userId.length() == 0) || (newPass1.length() == 0)
				|| (newPass2.length() == 0)) {
			MessageView error = new MessageView(21044, LogCategorySet.GUI_USER_MANAGE,
					Message.NOT_INPUT_ITEM);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			validationFlag = false;
		}
		else {
			Matcher matcherUserId = pattern.matcher(userId);
			Matcher matcherNewPass1 = pattern.matcher(newPass1);
			Matcher matcherNewPass2 = pattern.matcher(newPass2);
			Matcher matcherDescription = pattern.matcher(description);

			if (matcherUserId.find() || matcherNewPass1.find()
					|| matcherNewPass2.find() || matcherDescription.find()) {
				MessageView error = new MessageView(21045, LogCategorySet.GUI_USER_MANAGE, 
						"Input item : " + Message.INVALID_VALUE);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				validationFlag = false;
			} else if (false == newPass1.equals(newPass2)) {
				MessageView error = new MessageView(21046, LogCategorySet.GUI_USER_MANAGE,
						Message.NOT_EQUAL);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				validationFlag = false;
			} else if ((userId.length() > MAX_USER_LENGTH)
					|| (newPass1.length() < MIN_PASS_LENGTH)
					|| (newPass1.length() > MAX_PASS_LENGTH)
					|| (description.length() > MAX_DESCRIPTION_LENGTH)) {
				MessageView error = new MessageView(21047, LogCategorySet.GUI_USER_MANAGE,
						Message.INVALID_VALUE);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				validationFlag = false;
			}
		}

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11335 UserAddServlet::validationCheck(HttpSession session, String userId, String description, String newPass1, String newPass2) out return=" + validationFlag);
		}
		// --- debug log (out method) ---
		return validationFlag;
	}
}