package org.ultramonkey.l7.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

import org.apache.log4j.Logger;

/**
 * <p>
 * class L7SyncSocket
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author momose
 */
public class L7SyncSocket {
	protected Logger debugLogger = Logger
			.getLogger(LogCategorySet.SYNC_CONNECTION);

	protected OutputStream outputStream;

	protected InputStream inputStream;

	protected BufferedReader bufferedReader;

	protected BufferedWriter bufferedWriter;

	protected final String SEPARATOR = "\r\n";

	protected final int ENTRY_NUMBER = 3;

	/**
	 * Constructor
	 * 
	 */
	public L7SyncSocket() {
		// debug log(constructor)
		if (debugLogger.isDebugEnabled()) {
			debugLogger.debug("11221 class L7SyncSocket created.");
		}
	}

	/**
	 * <p>
	 * Sets inputStream and outputastream which got at L7SyncManager.
	 * </p>
	 * 
	 * @param inputStream
	 * @param outputStream
	 * @throws MessageView
	 */
	public void openConnection(InputStream inputStream,
			OutputStream outputStream) throws MessageView {

		// debug log(in method)
		if (debugLogger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("L7SyncSocket::openConnection(InputStream inputStream, OutputStream outputStream) throws MessageView in ");

			if (null != inputStream) {
				buf.append("inputStream= " + inputStream.toString() + ", ");
			} else {
				buf.append("inputStream= " + "null, ");
			}
			if (null != outputStream) {
				buf.append("outputStream= " + outputStream.toString());
			} else {
				buf.append("outputStream= " + "null");
			}
			debugLogger.debug("11222 " + buf.toString());
		}

		if ((null == inputStream) || (null == outputStream)) {
			throw new MessageView(40009, LogCategorySet.SYNC_CONNECTION,
					Message.SYNC_INVALID_ARGUMENT + " OpenConnection : null");
		}

		this.inputStream = inputStream;
		this.outputStream = outputStream;

		bufferedWriter = new BufferedWriter(new OutputStreamWriter(
				this.outputStream));

		bufferedReader = new BufferedReader(new InputStreamReader(
				this.inputStream));

		// debug log(out method)
		if (debugLogger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("L7SyncSocket::openConnection(InputStream inputStream, OutputStream outputStream) throws MessageView out ");
			debugLogger.debug("11223 " + buf.toString());
		}

	}

	/**
	 * <p>
	 * Sends data.
	 * </p>
	 * 
	 * @param payloadStr
	 *            recieve data
	 * @throws MessageView
	 */
	public void sendData(String[] payloadStr) throws MessageView {
		// debug log(in method)
		if (debugLogger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("L7SyncSocket::sendData(String[] payloadStr) throws MessageView in ");
			buf.append("payloadStr= ");
			if (null == payloadStr) {
				buf.append("null");
			} else {
				for (int i = 0; i < payloadStr.length; i++) {
					if (payloadStr.length - 1 == i) {
						buf.append(payloadStr[i].toString());
						break;
					}
					buf.append(payloadStr[i].toString() + ",");
				}
			}
			debugLogger.debug("11224 " + buf.toString());
		}

		if (null == payloadStr) {
			throw new MessageView(40010, LogCategorySet.SYNC_CONNECTION,
					Message.SYNC_INVALID_ARGUMENT + " SendData : " + payloadStr);
		}
		try {
			for (int i = 0; i < payloadStr.length; i++) {
				bufferedWriter.write(payloadStr[i]);
				bufferedWriter.write(SEPARATOR);
			}
			bufferedWriter.write(SEPARATOR);
			bufferedWriter.flush();
		} catch (Exception e) {
			throw new MessageView(50001, LogCategorySet.SYNC_CONNECTION,
					Message.SYNC_SEND_ERROR + " : " + e);
		}
		// debug log(out method)
		if (debugLogger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("L7SyncSocket::sendData(String[] payloadStr) throws MessageView out ");
			debugLogger.debug("11225 " + buf.toString());
		}
	}

	/**
	 * <p>
	 * Recieves data.
	 * </p>
	 * 
	 * @return buffer send data
	 * @throws MessageView
	 */
	public String[] recvData() throws MessageView {
		// debug log(in method)
		if (debugLogger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("L7SyncSocket::recvData() throws MessageView in ");
			debugLogger.debug("11226 " + buf.toString());
		}

		String readStr;
		String[] readDataArray = null;

		try {
			readDataArray = new String[ENTRY_NUMBER];
			int i = 0;
			while (true) {
				readStr = bufferedReader.readLine();
				if (null == readStr) {
					return null;
				}

				if ((0 == readStr.length())) {
					break;
				}
				if (i >= ENTRY_NUMBER) {
					throw new MessageView(40011,
							LogCategorySet.SYNC_CONNECTION,
							Message.SYNC_INVALID_RECV_DATA);
				}
				readDataArray[i] = readStr;
				i++;
			}
		} catch (Exception e) {
			throw new MessageView(50002, LogCategorySet.SYNC_CONNECTION,
					Message.SYNC_RECV_ERROR + " : " + e);
		}

		// debug log(out method)
		if (debugLogger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("L7SyncSocket::recvData() throws MessageView out ");
			buf.append("return= ");
			if (0 == readDataArray.length) {
				buf.append("null");
			} else {
				for (int i = 0; i < readDataArray.length; i++) {
					if (readDataArray.length - 1 == i) {
						buf.append(readDataArray[i].toString());
						break;
					}
					buf.append(readDataArray[i].toString() + ",");
				}
			}
			debugLogger.debug("11227 " + buf.toString());
		}
		return readDataArray;
	}

	/**
	 * <p>
	 * Active server closes connection after recieving all results from stand-by
	 * server.
	 * </p>
	 * 
	 * @throws MessageView
	 */
	public void closeConnection() throws MessageView {
		// debug log(in method)
		if (debugLogger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("L7SyncSocket::closeConnection() throws MessageView in ");
			debugLogger.debug("11228 " + buf.toString());
		}
		try {
			outputStream.close();
		} catch (Exception e) {
			throw new MessageView(50003, LogCategorySet.SYNC_CONNECTION,
					Message.SYNC_CLOSE_ERROR + " :" + e);
		}
		// debug log(out method)
		if (debugLogger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("L7SyncSocket::closeConnection() throws MessageView out ");
			debugLogger.debug("11229 " + buf.toString());
		}
	}
}
