package org.ultramonkey.l7.model;

//import java.util.logging.Logger;
import org.apache.log4j.Logger;

/**
 * <p>class SyncCategoryId</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author momose
 */
public class SyncCategoryIdSet {
    protected static Logger debugLogger = Logger.getLogger(LogCategorySet.SYNC_SYNC);

    static public final int SYNC_OK = 1;

    static public final int SYNC_NG = 2;

    static public final int L7VSD_LOG_ID = 3;

    static public final int ADM_LOG_ID = 4;

    static public final int SNMP_LOG_ID = 5;

    static public final int REPLICATION_INFO_ID = 6;

    static public final int SNMP_INFO_ID = 7;

    static public final int ADM_INFO_ID = 8;

    static public final int MONITOR_ID = 9;

    static public final int SERVICE_ID = 10;

    static public final int USERDATA_ID = 11;

    static public final int LOG_ALL_ID = 12;

    /**
     * <p> change category name to category ID</p>
     *
     * @param inStr category name
     * @return
     * @throws MessageView
     */
    public static int toCategoryId(String inStr) throws MessageView {

        // debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf
                            .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView in ");
            buf.append("inStr= " + inStr);
            debugLogger.debug("11195 " + buf.toString());
        }

        if (inStr.equals("SYNC_OK")) {
            // debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView out ");
                buf.append("return= SYNC_OK");
                debugLogger.debug("11196 " + buf.toString());
            }
            return SYNC_OK;
        }
        if (inStr.equals("SYNC_NG")) {
            // debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView out ");
                buf.append("return= SYNC_NG");
                debugLogger.debug("11197 " + buf.toString());
            }
            return SYNC_NG;
        }
        if (inStr.equals("l7vsd_log")) {
            // debug log (out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView out ");
                buf.append("return= L7VSD_LOG_ID");
                debugLogger.debug("11198 " + buf.toString());
            }
            return L7VSD_LOG_ID;
        }
        if (inStr.equals("adm_log")) {
            // debug log (out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView out ");
                buf.append("return= ADM_LOG_ID");
                debugLogger.debug("11199 " + buf.toString());
            }
            return ADM_LOG_ID;
        }
        if (inStr.equals("snmp_log")) {
            // debug log (out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView out ");
                buf.append("return= SNMP_LOG_ID");
                debugLogger.debug("11200 " + buf.toString());
            }
            return SNMP_LOG_ID;
        }
        if (inStr.equals("replication_info")) {
            // debug log (out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView out ");
                buf.append("return= REPLICATION_INFO_ID");
                debugLogger.debug("11201 " + buf.toString());
            }
            return REPLICATION_INFO_ID;
        }
        if (inStr.equals("snmp_info")) {
            // debug log (out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView out ");
                buf.append("return= SNMP_INFO_ID");
                debugLogger.debug("11202 " + buf.toString());
            }
            return SNMP_INFO_ID;
        }
        if (inStr.equals("adm_info")) {
            // debug log (out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView out ");
                buf.append("return= ADM_INFO_ID");
                debugLogger.debug("11203 " + buf.toString());
            }
            return ADM_INFO_ID;
        }
        if (inStr.equals("monitor")) {
            // debug log (out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView out ");
                buf.append("return= MONITOR_ID");
                debugLogger.debug("11204 " + buf.toString());
            }
            return MONITOR_ID;
        }
        if (inStr.equals("service")) {
            // debug log (out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView out ");
                buf.append("return= SERVICE_ID");
                debugLogger.debug("11205 " + buf.toString());
            }
            return SERVICE_ID;
        }
        if (inStr.equals("userdata")) {
            // debug log (out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView out ");
                buf.append("return= USERDATA_ID");
                debugLogger.debug("11206 " + buf.toString());
            }
            return USERDATA_ID;
        }
        if (inStr.equals("log_all")) {
            // debug log (out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryId(String inStr) throws MessageView out ");
                buf.append("return= LOG_ALL_ID");
                debugLogger.debug("11207 " + buf.toString());
            }
            return LOG_ALL_ID;
        } else
            throw new MessageView(40001, LogCategorySet.SYNC_SYNC,
                            Message.SYNC_INVALID_ARGUMENT + " toCategoryId : " + inStr);

    }

    /**
     * <p> change category ID to category name</p>
     *
     * @param categoryId category ID
     * @return category name
     * @throws MessageView
     */
    public static String toCategoryName(int categoryId) throws MessageView {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf
                            .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView in ");
            buf.append("categoryId= " + categoryId);
            debugLogger.debug("11208 " + buf.toString());
        }

        switch (categoryId) {
        case L7VSD_LOG_ID:
            //          debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView out ");
                buf.append("return= l7vsd_log");
                debugLogger.debug("11209 " + buf.toString());
            }
            return "l7vsd_log";

        case ADM_LOG_ID:
            // debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView out ");
                buf.append("return= adm_log");
                debugLogger.debug("11210 " + buf.toString());
            }
            return "adm_log";

        case SNMP_LOG_ID:
            //          debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView out ");
                buf.append("return= snmp_log");
                debugLogger.debug("11211 " + buf.toString());
            }

            return "snmp_log";

        case REPLICATION_INFO_ID:
            //          debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView out ");
                buf.append("return= replication_info");
                debugLogger.debug("11212 " + buf.toString());
            }
            return "replication_info";

        case SNMP_INFO_ID:
            //          debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView out ");
                buf.append("return= snmp_info");
                debugLogger.debug("11213 " + buf.toString());
            }
            return "snmp_info";

        case ADM_INFO_ID:
            //          debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView out ");
                buf.append("return= adm_info");
                debugLogger.debug("11214 " + buf.toString());
            }
            return "adm_info";

        case MONITOR_ID:
            //          debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView out ");
                buf.append("return= monitor");
                debugLogger.debug("11215 " + buf.toString());
            }
            return "monitor";

        case SERVICE_ID:
            //          debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView out ");
                buf.append("return= service");
                debugLogger.debug("11216 " + buf.toString());
            }
            return "service";

        case USERDATA_ID:
            //          debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView out ");
                buf.append("return= userdata");
                debugLogger.debug("11217 " + buf.toString());
            }
            return "userdata";

        case LOG_ALL_ID:
            //          debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView out ");
                buf.append("return= log_all");
                debugLogger.debug("11218 " + buf.toString());
            }
            return "log_all";

        case SYNC_OK:
            //          debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView out ");
                buf.append("return= sync_ok");
                debugLogger.debug("11219 " + buf.toString());
            }
            return "sync_ok";

        case SYNC_NG:
            //          debug log(out method)
            if (debugLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf
                                .append("SyncCategoryIdSet::toCategoryName(int categoryId) throws MessageView out ");
                buf.append("return= sync_ng");
                debugLogger.debug("11220 " + buf.toString());
            }
            return "sync_ng";

        default:
            throw new MessageView(40002, LogCategorySet.SYNC_SYNC,
                            Message.SYNC_INVALID_ARGUMENT + " toCategoryName : "
                                            + categoryId);
        }
    }
}
