package org.ultramonkey.l7.model;

import java.util.Vector;
import java.io.*;
import javax.servlet.http.*;

import org.apache.log4j.Logger;

/**
 * 
 * <p>
 * class UserManager
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author tanuma
 */
public final class UserManager {
	static final long serialVersionUID = 1;

	/**
	 * userdata save filename ("/opt/l7vsd/userdata.dat")
	 */
	protected static final String FileName = "/opt/l7vsd/userdata.dat";

	/**
	 * instance of this class (singleton)
	 */
	protected static UserManager instance = null;

	/**
	 * userdata structure
	 */
	protected Vector<UserData> uservec = null;
	protected Vector<UserData> olduservec = null;

	protected UserManager() throws FileNotReadException {
        // --- debug log (constructor) ---
		Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
        if (userLogger.isDebugEnabled()) {
            userLogger.debug("11011 class UserManager created.");
        }
        // --- debug log (constructor) ---

		uservec = new Vector<UserData>();
		this.loadFromFile();
	}

	/**
	 * 
	 * <p>
	 * getInstance method
	 * </p>
	 * 
	 * @return instance of this class.
	 */
	public synchronized static UserManager getInstance() {
		// --- debug log (in method) ---
		Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
		if (userLogger.isDebugEnabled()) {
            userLogger.debug("11012 UserManager::getInstance() in");
		}
		// --- debug log (in method) ---

		if (instance == null) {
			try {
				instance = new UserManager();
			} catch (FileNotReadException e) {
				userLogger.error("41002 Exception occured: " + e.getMessage());
				// --- debug log (out method) ---
				if (userLogger.isDebugEnabled()) {
		            userLogger.debug("11013 UserManager::getInstance() out return=null");
				}
				// --- debug log (out method) ---
				return null;
			}
		}

		// --- debug log (out method) ---
		if (userLogger.isDebugEnabled()) {
            userLogger.debug("11014 UserManager::getInstance() out return=(" + instance + ")");
		}
		// --- debug log (out method) ---
		return instance;
	}

	/**
	 * save function
	 * 
	 * @return true/false
	 */
	protected void saveToFile() throws FileNotWriteException {
		// --- debug log (in method) ---
		Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
		if (userLogger.isDebugEnabled()) {
            userLogger.debug("11015 UserManager::saveToFile() throws FileNotWriteException in");
		}
		// --- debug log (in method) ---

		try {
			ObjectOutputStream oos = new ObjectOutputStream(
					new FileOutputStream(FileName));
			oos.writeObject(uservec);
			oos.close();
		} catch (IOException e) {
			this.uservec = this.olduservec;
			FileNotWriteException exception = new FileNotWriteException();
			exception.setFileName(FileName);
			exception.setErrMessage("Cannot write file.");
			userLogger.error("41003 Exception occured: " + e.getMessage());
			// --- debug log (out method) ---
			if (userLogger.isDebugEnabled()) {
	            userLogger.debug("11016 UserManager::saveToFile() throws FileNotWriteException out exception=\"" + exception.toString() + "\"");
			}
			// --- debug log (out method) ---
			throw exception;
		}

		// --- debug log (out method) ---
		if (userLogger.isDebugEnabled()) {
            userLogger.debug("11017 UserManager::saveToFile() throws FileNotWriteException out");
		}
		// --- debug log (out method) ---
	}

	/**
	 * load function
	 * 
	 * @return true/false
	 */
	protected void loadFromFile() throws FileNotReadException {
		// --- debug log (in method) ---
		Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
		if (userLogger.isDebugEnabled()) {
            userLogger.debug("11018 UserManager::loadFromFile() throws FileNotReadException in");
		}
		// --- debug log (in method) ---

		try {
			ObjectInputStream ois = new ObjectInputStream(
					new FileInputStream(FileName));
			uservec = (Vector<UserData>) ois.readObject();
			ois.close();
		} catch (FileNotFoundException ex) {
			FileNotReadException exception = new FileNotReadException();
			exception.setFileName(FileName);
			exception.setErrMessage("Cannot read file.");
			userLogger.error("41004 Exception occured: " + ex.getMessage());
			// --- debug log (out method) ---
			if (userLogger.isDebugEnabled()) {
	            userLogger.debug("11019 UserManager::loadFromFile() throws FileNotReadException out exception=\"" + exception.toString() + "\"");
			}
			// --- debug log (out method) ---
			throw exception;
		} catch (IOException ex) {
			FileNotReadException exception = new FileNotReadException();
			exception.setFileName(FileName);
			exception.setErrMessage("Catch IOException: " + ex.getMessage());
			userLogger.error("41005 Exception occured: " + ex.getMessage());
			// --- debug log (out method) ---
			if (userLogger.isDebugEnabled()) {
	            userLogger.debug("11020 UserManager::loadFromFile() throws FileNotReadException out exception=\"" + exception.toString() + "\"");
			}
			// --- debug log (out method) ---
			throw exception;
		} catch (ClassNotFoundException ex) {
			FileNotReadException exception = new FileNotReadException();
			exception.setFileName(FileName);
			exception.setErrMessage("Catch ClassNotFoundException.");
			userLogger.error("41006 Exception occured: " + ex.getMessage());
			// --- debug log (out method) ---
			if (userLogger.isDebugEnabled()) {
	            userLogger.debug("11021 UserManager::loadFromFile() throws FileNotReadException out exception=\"" + exception.toString() + "\"");
			}
			// --- debug log (out method) ---
			throw exception;
		}

		// --- debug log (out method) ---
		if (userLogger.isDebugEnabled()) {
            userLogger.debug("11022 UserManager::loadFromFile() throws FileNotReadException out");
		}
		// --- debug log (out method) ---
	}

	/**
	 * 
	 * <p>
	 * authUser method
	 * </p>
	 * 
	 * @param userid
	 * @param userpass
	 * @return
	 */
	public UserData authUser(String userid, String userpass) {
		// --- debug log (in method) ---
		Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
		if (userLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
			buf.append("UserManager::authUser(String userid, String userpass) in ");
			buf.append("userid=\"" + userid + "\", ");
			buf.append("userpass=\"" + userpass + "\"");
			userLogger.debug("11023 " + buf.toString());
		}
		// --- debug log (in method) ---

		UserData ret = null;
		if (userid != null || userpass != null) {
			for (UserData data : uservec) {
				if (data.userName.equals(userid) && data.passwd.equals(userpass)) {
					ret = data;
					break;
				}
			}
		}

		// --- debug log (out method) ---
		if (userLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
			buf.append("UserManager::authUser(String userid, String userpass) out ");
			buf.append("return=(" + ret + ")");
			userLogger.debug("11024 " + buf.toString());
		}
		// --- debug log (out method) ---
    	return ret;
	}

	/**
	 * 
	 * <p>
	 * closeUser method
	 * </p>
	 * 
	 * @param request
	 */
	public void closeUser(HttpServletRequest request) {
		// --- debug log (in method) ---
		Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
		if (userLogger.isDebugEnabled()) {
			userLogger.debug("11025 UserManager::closeUser(HttpServletRequest request) in request=(" + request +")");
		}
		// --- debug log (in method) ---

		if (request != null) {
			HttpSession session = request.getSession();
			if (session != null) {
				session.invalidate();
			}
		}

		// --- debug log (out method) ---
		if (userLogger.isDebugEnabled()) {
			userLogger.debug("11026 UserManager::closeUser(HttpServletRequest request) out");
		}
		// --- debug log (out method) ---
	}

	/**
	 * check userid in userlist
	 * 
	 * @param userid
	 * @return
	 */
	public UserData findUser(String userid) {
		// --- debug in (out method) ---
		Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
		if (userLogger.isDebugEnabled()) {
			userLogger.debug("11027 UserManager::findUser(String userid) in userid=\"" + userid + "\"");
		}
		// --- debug log (in method) ---

		UserData ret = null;
		if (userid != null) {
			for (UserData data : uservec) {
				if (data.userName.equals(userid)) {
					ret = data;
				}
			}
		}

		// --- debug log (out method) ---
		if (userLogger.isDebugEnabled()) {
			userLogger.debug("11028 UserManager::findUser(String userid) out return=(" + ret + ")");
		}
		// --- debug log (out method) ---
		return ret;
	}

	/**
	 * user data add in UserDatas
	 * 
	 * @param userid
	 *            userid
	 * @param password
	 *            password
	 * @param acl
	 * @param description
	 * @throws Exception
	 *             UserData can't write
	 */
	public boolean addUser(String userid, String password, int acl,
			String description) throws FileNotWriteException {
		// --- debug log (in method) ---
		Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
		if (userLogger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("UserManager::addUser(String userid, String password, int acl, String description) throws FileNotWriteException in ");
			buf.append("userid=\"" + userid + "\", ");
			buf.append("password=\"" + password + "\", ");
			buf.append("acl=" + acl + ", ");
			buf.append("description=\"" + description + "\"");
			userLogger.debug("11029 " + buf.toString());
		}
		// --- debug log (in method) ---
		
		if (userid == null || password == null || description == null) {
			// --- debug log (out method) ---
			if (userLogger.isDebugEnabled()) {
				userLogger.debug("11030 UserManager::addUser(String userid, String password, int acl, String description) throws FileNotWriteException out return=false");
			}
			// --- debug log (out method) ---
			return false;
		}
		UserData data = findUser(userid);
		if (data == null) {
			data = new UserData();
			data.userName = userid;
			data.passwd = password;
			data.acl = acl;
			data.description = description;
			this.deepCopy();
			uservec.add(data);
			this.saveToFile();
		} else {
			// --- debug log (out method) ---
			if (userLogger.isDebugEnabled()) {
				userLogger.debug("11031 UserManager::addUser(String userid, String password, int acl, String description) throws FileNotWriteException out return=false");
			}
			// --- debug log (out method) ---
			return false;
		}

		// --- debug log (out method) ---
		if (userLogger.isDebugEnabled()) {
			userLogger.debug("11032 UserManager::addUser(String userid, String password, int acl, String description) throws FileNotWriteException out return=true");
		}
		// --- debug log (out method) ---
		return true;
	}

	/**
	 * 
	 * <p>
	 * changeUser method
	 * </p>
	 * 
	 * @param data
	 * @return
	 * @throws FileNotWriteException
	 */
	public boolean changeUser(UserData data) throws FileNotWriteException {
		// --- debug log (in method) ---
		Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
		if (userLogger.isDebugEnabled()) {
			userLogger.debug("11033 UserManager::changeUser(UserData data) throws FileNotWriteException in data=(" + data + ")");
		}
		// --- debug log (in method) ---

		if (data == null) {
			// --- debug log (out method) ---
			if (userLogger.isDebugEnabled()) {
				userLogger.debug("11034 UserManager::changeUser(UserData data) throws FileNotWriteException out return=false");
			}
			// --- debug log (out method) ---
			return false;
		}
		UserData found = findUser(data.userName);
		if (found != null) {
			this.deepCopy();
			found.passwd = data.passwd;
			found.acl = data.acl;
			found.description = data.description;
			this.saveToFile();
		} else {
			// --- debug log (out method) ---
			if (userLogger.isDebugEnabled()) {
				userLogger.debug("11035 UserManager::changeUser(UserData data) throws FileNotWriteException out return=false");
			}
			// --- debug log (out method) ---
			return false;
		}

		// --- debug log (out method) ---
		if (userLogger.isDebugEnabled()) {
			userLogger.debug("11036 UserManager::changeUser(UserData data) throws FileNotWriteException out return=true");
		}
		// --- debug log (out method) ---
		return true;
	}

	/**
	 * user data delete from UserDatas
	 * 
	 * @param userid
	 * @throws Exception
	 */
	public boolean delUser(String userid) throws FileNotWriteException {
		// --- debug log (in method) ---
		Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
		if (userLogger.isDebugEnabled()) {
			userLogger.debug("11037 UserManager::delUser(String userid) throws FileNotWriteException in userid=\"" + userid + "\"");
		}
		// --- debug log (in method) ---

		if (userid == null) {
			// --- debug log (out method) ---
			if (userLogger.isDebugEnabled()) {
				userLogger.debug("11038 UserManager::delUser(String userid) throws FileNotWriteException out return=false");
			}
			// --- debug log (out method) ---
			return false;
		}
		UserData data = findUser(userid);
		if (data != null && uservec.size() > 1) {
			this.deepCopy();
			uservec.remove(data);
			this.saveToFile();
			// --- debug log (out method) ---
			if (userLogger.isDebugEnabled()) {
				userLogger.debug("11039 UserManager::delUser(String userid) throws FileNotWriteException out return=true");
			}
			// --- debug log (out method) ---
			return true;
		}

		// --- debug log (out method) ---
		if (userLogger.isDebugEnabled()) {
			userLogger.debug("11040 UserManager::delUser(String userid) throws FileNotWriteException out return=false");
		}
		// --- debug log (out method) ---
		return false;
	}

	/**
	 * 
	 * <p>
	 * getUserList method
	 * </p>
	 * 
	 * @return
	 */
	public Vector<UserData> getUserList() throws FileNotReadException {
		// --- debug log (in/out method) ---
		Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
		if (userLogger.isDebugEnabled()) {
            userLogger.debug("11041 UserManager::getUserList() in");
            userLogger.debug("11042 UserManager::getUserList() out return=(" + uservec + ")");
		}
		// --- debug log (in/out method) ---
		this.loadFromFile();
		
		return this.uservec;
	}

	/**
	 * 
	 * <p>
	 * setUserList method
	 * </p>
	 */
	public void setUserList(Vector<UserData> uservec) throws FileNotWriteException {
		// --- debug log (in method) ---
		Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
		if (userLogger.isDebugEnabled()) {
            userLogger.debug("11043 UserManager::setUserList(Vector<UserData> uservec) in uservec=(" + uservec + ")");
		}
		// --- debug log (in method) ---

		this.deepCopy();
		this.uservec = uservec;
		this.saveToFile();

		// --- debug log (out method) ---
		if (userLogger.isDebugEnabled()) {
            userLogger.debug("11044 UserManager::setUserList(Vector<UserData> uservec) out");
		}
		// --- debug log (out method) ---
	}
	
	protected void deepCopy() {
		this.olduservec = new Vector<UserData>();
		for (UserData cur : this.uservec) {
			UserData copy = new UserData(cur);
			olduservec.add(copy);
		}
	}
}
