package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.L7guiFramework;
import org.ultramonkey.l7.model.LogCategorySet;
import org.ultramonkey.l7.model.Message;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SaveCategoryIdSet;

/**
 * Servlet implementation class for Servlet: SaveStateServlet
 * 
 */
public class SaveStateServlet extends org.ultramonkey.l7.view.L7guiServletBase {
	static final long serialVersionUID = 1L;

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	private enum status {
		NO_SAVE, SAVE_OK, SAVE_NG
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public SaveStateServlet() {
		super();
        // --- debug log (constructor) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11249 class SaveStateServlet created.");
		}
		// --- debug log (constructor) ---
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("SaveStateServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11250 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			logger.debug("11251 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11252 SaveStateServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("SaveStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11253 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11254 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---

		// check login session
		super.doPost(request, response);

		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41050, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11255 SaveStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		// get checkbox Category Data & button Mode
        request.setCharacterEncoding("UTF-8");
		String selectCheck[] = request.getParameterValues("save_category");
		String button_mode = request.getParameter("button");
		if (button_mode == null || button_mode.equals(ButtonMode.SAVE) == false) {
			MessageView error = new MessageView(41051, LogCategorySet.GUI_SAVE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11256 SaveStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		if (selectCheck == null) {
			MessageView error = new MessageView(21033, LogCategorySet.GUI_SAVE,
					Message.SAVE_CATEGORY_SELECT_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.SAVE);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11257 SaveStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		status saveLogResult = status.NO_SAVE;
		status saveVsResult = status.NO_SAVE;
		String resultPage = RedirectPages.SAVE;

		L7guiFramework framework = new L7guiFramework();

		for (int i = 0; i < selectCheck.length; i++) {
			if (selectCheck[i].equals("save_log")) {
				HashSet<SaveCategoryIdSet> saveCategory = new HashSet<SaveCategoryIdSet>();
				saveCategory.add(SaveCategoryIdSet.LOG_ID);

				if (framework.saveExecute(saveCategory)) {
					session.setAttribute(SessionKeys.LOG_SAVE_STATE,
							SessionKeys.SAVE);
					saveLogResult = status.SAVE_OK;
				} else {
					saveLogResult = status.SAVE_NG;
					resultPage = RedirectPages.SAVE_FAIL;
				}
			} else if (selectCheck[i].equals("save_service")) {
				HashSet<SaveCategoryIdSet> saveCategory = new HashSet<SaveCategoryIdSet>();

				saveCategory.add(SaveCategoryIdSet.VS_ID);
				if (framework.saveExecute(saveCategory)) {
					session.setAttribute(SessionKeys.VS_SAVE_STATE,
							SessionKeys.SAVE);
					saveVsResult = status.SAVE_OK;
				} else {
					saveVsResult = status.SAVE_NG;
					resultPage = RedirectPages.SAVE_FAIL;
				}
			} else {
				MessageView error = new MessageView(41052, LogCategorySet.GUI_SAVE,
						Message.UNEXPECTED_ERROR);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				response.sendRedirect(RedirectPages.LOGIN);
				// --- debug log (out method) ---
				if (logger.isDebugEnabled()) {
		            logger.debug("11258 SaveStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
				}
				// --- debug log (out method) ---
				return;
			}
		}

		if (saveLogResult == status.SAVE_OK &&
			saveVsResult  == status.SAVE_OK) {
			MessageView success = new MessageView(21034, LogCategorySet.GUI_SAVE,
					Message.SAVE_LOG_VS_SUCCESS);
			session.setAttribute(SessionKeys.COMMAND_MESSAGE, success);
		} else if (saveLogResult == status.SAVE_OK
				 && saveVsResult  == status.SAVE_NG) {
			MessageView error = new MessageView(41053, LogCategorySet.GUI_SAVE, Message.SAVE_LOG_SUCCESS
					+ "<br />\n" + Message.SAVE_VS_FAIL);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		} else if (saveLogResult == status.SAVE_OK
				 && saveVsResult  == status.NO_SAVE) {
			MessageView success = new MessageView(21035, LogCategorySet.GUI_SAVE, Message.SAVE_LOG_SUCCESS);
			session.setAttribute(SessionKeys.COMMAND_MESSAGE, success);
		} else if (saveLogResult == status.SAVE_NG
				 && saveVsResult  == status.SAVE_OK) {
			MessageView error = new MessageView(41054, LogCategorySet.GUI_SAVE, Message.SAVE_LOG_FAIL
					+ "<br />\n" + Message.SAVE_VS_SUCCESS);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		} else if (saveLogResult == status.SAVE_NG
				 && saveVsResult  == status.SAVE_NG) {
			MessageView error = new MessageView(41055, LogCategorySet.GUI_SAVE, Message.SAVE_LOG_VS_FAIL);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		} else if (saveLogResult == status.SAVE_NG
				 && saveVsResult  == status.NO_SAVE) {
			MessageView error = new MessageView(41056, LogCategorySet.GUI_SAVE, Message.SAVE_LOG_FAIL);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		} else if (saveLogResult == status.NO_SAVE
				 && saveVsResult  == status.SAVE_OK) {
			MessageView success = new MessageView(21036, LogCategorySet.GUI_SAVE, Message.SAVE_VS_SUCCESS);
			session.setAttribute(SessionKeys.COMMAND_MESSAGE, success);
		} else if (saveLogResult == status.NO_SAVE
				 && saveVsResult  == status.SAVE_NG) {
			MessageView error = new MessageView(41057, LogCategorySet.GUI_SAVE, Message.SAVE_VS_FAIL);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		} else {
			MessageView error = new MessageView(41058, LogCategorySet.GUI_SAVE, Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11259 SaveStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		response.sendRedirect(resultPage);
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11260 SaveStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}
}
