
#include <map>
#include "l7vs_snmpbridge.h"
#include "logger_wrapper.h"
#include "parameter_wrapper.h"
#include "l7ag_parameter.h"

#define	NIC_DEFAULT	"eth0"
#define	ADDR_DEFAULT	"127.0.0.1"
#define	PORT_DEFAULT	60162
#define	INTERVAL_DEFAULT	1000

#define BRIDGE_STUB

static	std::map<LOG_CATEGORY_TAG,std::string> snmp_loglevel_map;
static	std::map<std::string,LOG_LEVEL_TAG> levelstring_map;

struct	l7ag_parameter	snmpparam;

//define internal functions
#ifndef BRIDGE_STUB
static	int	snmpbridge_send_message();
#endif
static	void	load_config();
static  void    load_loglevel();

/*!
 * Initialize
 * @return	int
 */
int	l7vs_snmpbridge_initialize()
{
	int	retval = 0;

	//create loglevel map
	snmp_loglevel_map.clear();
	snmp_loglevel_map.insert( std::pair<LOG_CATEGORY_TAG,std::string>( LOG_CAT_SNMPAGENT_START_STOP, "snmpagent_start_stop" ) );
	snmp_loglevel_map.insert( std::pair<LOG_CATEGORY_TAG,std::string>( LOG_CAT_SNMPAGENT_MANAGER_RECEIVE, "snmpagent_manager_receive" ) );
	snmp_loglevel_map.insert( std::pair<LOG_CATEGORY_TAG,std::string>( LOG_CAT_SNMPAGENT_MANAGER_SEND, "snmpagent_manager_send" ) );
	snmp_loglevel_map.insert( std::pair<LOG_CATEGORY_TAG,std::string>( LOG_CAT_SNMPAGENT_L7VSD_RECEIVE, "snmpagent_l7vsd_receive" ) );
	snmp_loglevel_map.insert( std::pair<LOG_CATEGORY_TAG,std::string>( LOG_CAT_SNMPAGENT_L7VSD_SEND, "snmpagent_l7vsd_send" ) );
	snmp_loglevel_map.insert( std::pair<LOG_CATEGORY_TAG,std::string>( LOG_CAT_SNMPAGENT_LOGGER, "snmpagent_logger" ) );
	snmp_loglevel_map.insert( std::pair<LOG_CATEGORY_TAG,std::string>( LOG_CAT_SNMPAGENT_PARAMETER, "snmpagent_parameter" ) );

	levelstring_map.clear();
	levelstring_map.insert( std::pair<std::string,LOG_LEVEL_TAG>("debug",LOG_LV_DEBUG) );
	levelstring_map.insert( std::pair<std::string,LOG_LEVEL_TAG>("info",LOG_LV_INFO) );
	levelstring_map.insert( std::pair<std::string,LOG_LEVEL_TAG>("warn",LOG_LV_WARN) );
	levelstring_map.insert( std::pair<std::string,LOG_LEVEL_TAG>("error",LOG_LV_ERROR) );
	levelstring_map.insert( std::pair<std::string,LOG_LEVEL_TAG>("fatal",LOG_LV_FATAL) );

	load_config();

#ifndef BRIDGE_STUB
	//create ListenSocket

	//start listening

	//put iom

	//setup iom

	//register iom
#endif
	return retval;
}

/*!
 * finalize
 * @param[in]
 * @return
 */
void	l7vs_snmpbridge_finalize()
{
	//Close TCP connection to agent

	//Close ListenSocket

	//Bring back iom

}

/*!
 * TRAP Request send
 * @param[in]	TRAPID_TAG	Trap ID
 * @param[in]	*message	Trap message
 * @return	int		
 */
int	l7vs_snmpbridge_send_trap( TRAPID_TAG trapid, char* message )
{
	int	retval = 0;

#ifndef BRIDGE_STUB
	//create message


	//register tx message to iom
	retval = snmpbridge_send_message();
#endif

	return retval;
}

/*!
 * reload config
 */
void	l7vs_snmpbridge_reload_config()
{
#ifndef BRIDGE_STUB
	//create message

	//register send event to the iom
	retval = snmpbridge_send_message();
#endif
	
	load_config();
}

/*!
 * Change log level
 */
int	l7vs_snmpbridge_change_loglevel( LOG_CATEGORY_TAG snmp_log_category, LOG_LEVEL_TAG loglevel )
{
	int	retval = 0;

	if( snmpparam.loglevel.end() != snmpparam.loglevel.find( snmp_log_category ) ){
#ifndef BRIDGE_STUB
		//create message

		//register send event to the iom
		retval = snmpbridge_send_message();
		if( 0 == retval ){
#endif
			snmpparam.loglevel.find( snmp_log_category )->second = loglevel;
#ifndef BRIDGE_STUB
		}
#endif
	}else{
		retval = -1;
	}
	return retval;
}

/*!
 * Change loglevel (all category)
 */
int	l7vs_snmpbridge_change_loglevel_allcategory( LOG_LEVEL_TAG loglevel )
{
	int	retval = 0;

#ifndef BRIDGE_STUB
		//create message

		//register send event to the iom
		retval = snmpbridge_send_message();
		if( 0 == retval ){
#endif
			for( std::map<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>::iterator it = snmpparam.loglevel.begin(); it != snmpparam.loglevel.end(); ++it ){
				it->second = loglevel;
			}
#ifndef BRIDGE_STUB
		}
#endif
	
	return retval;
}

/*!
 * Send result of mib collection
 */
int	l7vs_snmpbridge_send_mibcollection()
{
	int	retval = 0;
	
#ifndef BRIDGE_STUB
	//create message

	//register send event to the iom
	retval = snmpbridge_send_message();
#endif

	return retval;
}

/*!
 * Get connection state
 */
int	l7vs_snmpbridge_get_connectionstate()
{
	int	retval = 0;
	
#ifdef BRIDGE_STUB
	retval	= snmpparam.status;
#else
#endif
	return retval;
}

/*!
 * get log level
 */
LOG_LEVEL_TAG	l7vs_snmpbridge_get_loglevel( LOG_CATEGORY_TAG snmp_log_category )
{
	LOG_LEVEL_TAG	level = LOG_LV_NONE;
	if( snmpparam.loglevel.end() != snmpparam.loglevel.find( snmp_log_category ) ){
		level = snmpparam.loglevel.find( snmp_log_category )->second;
	}
	return	level;
}

/*!
 * callback
 */
int	l7vs_snmpbridge_callback( l7vs_iomux* iom )
{
	
	return 0;
}

/*!
 *
 */
#ifndef BRIDGE_STUB
static	int	snmpbridge_send_message()
{

	return 0;
}
#endif

/*!
 *
 */
static	void	load_config()
{
	int	retval = 0;
	//NIC
	if( parameter_is_char_exist( PARAM_COMP_SNMPAGENT, "nic" ) ){
		snmpparam.nic = parameter_get_char_value( PARAM_COMP_SNMPAGENT, "nic" );
	}else{
		snmpparam.nic = NIC_DEFAULT;
	}
	//EndPoint
	if( parameter_is_char_exist( PARAM_COMP_SNMPAGENT, "ip_addr" ) ){
		snmpparam.address = parameter_get_char_value( PARAM_COMP_SNMPAGENT, "ip_addr" );
	}else{
		snmpparam.address = ADDR_DEFAULT;
	}
	if( parameter_is_int_exist( PARAM_COMP_SNMPAGENT, "port" ) ){
		snmpparam.portno = parameter_get_int_value( PARAM_COMP_SNMPAGENT, "port" );
	}else{
		snmpparam.portno = PORT_DEFAULT;
	}

	//Read Agent parameter
	//request interval
	if( parameter_is_int_exist( PARAM_COMP_SNMPAGENT, "interval" ) ){
		snmpparam.interval = parameter_get_int_value( PARAM_COMP_SNMPAGENT, "interval" );
	}else{
		snmpparam.interval = INTERVAL_DEFAULT;
	}
	if( parameter_is_int_exist( PARAM_COMP_SNMPAGENT, "status" ) ){
		snmpparam.status = parameter_get_int_value( PARAM_COMP_SNMPAGENT, "status" );
	}else{
		snmpparam.status = 0;
	}
	load_loglevel();
}

static	void	load_loglevel()
{
	//get log level
	snmpparam.loglevel.clear();
	//
	if( parameter_is_char_exist( PARAM_COMP_LOGGER, "snmpagent_start_stop" ) ){
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_START_STOP, levelstring_map[parameter_get_char_value( PARAM_COMP_LOGGER, "snmpagent_start_stop" )] ) );
	}else{
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_START_STOP, LOG_LV_INFO) );
	}
	//
	if( parameter_is_char_exist( PARAM_COMP_LOGGER, "snmpagent_manager_receive" ) ){
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_MANAGER_RECEIVE, levelstring_map[parameter_get_char_value( PARAM_COMP_LOGGER, "snmpagent_manager_receive" )] ) );
	}else{
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_MANAGER_RECEIVE, LOG_LV_INFO ) );
	}
	//
	if( parameter_is_char_exist( PARAM_COMP_LOGGER, "snmpagent_manager_send" ) ){
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_MANAGER_SEND, levelstring_map[parameter_get_char_value( PARAM_COMP_LOGGER, "snmpagent_manager_send" )] ) );
	}else{
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_MANAGER_SEND, LOG_LV_INFO ) );
	}
	//
	if( parameter_is_char_exist( PARAM_COMP_LOGGER, "snmpagent_l7vsd_receive" ) ){
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_L7VSD_RECEIVE, levelstring_map[parameter_get_char_value( PARAM_COMP_LOGGER, "snmpagent_l7vsd_receive" )] ) );
	}else{
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_L7VSD_RECEIVE, LOG_LV_INFO ) );
	}
	//
	if( parameter_is_char_exist( PARAM_COMP_LOGGER, "snmpagent_l7vsd_send" ) ){
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_L7VSD_SEND, levelstring_map[parameter_get_char_value( PARAM_COMP_LOGGER, "snmpagent_l7vsd_send" )] ) );
	}else{
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_L7VSD_SEND, LOG_LV_INFO ) );
	}
	//
	if( parameter_is_char_exist( PARAM_COMP_LOGGER, "snmpagent_logger" ) ){
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_LOGGER, levelstring_map[parameter_get_char_value( PARAM_COMP_LOGGER, "snmpagent_logger" )] ) );
	}else{
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_LOGGER, LOG_LV_INFO ) );
	}
	//
	if( parameter_is_char_exist( PARAM_COMP_LOGGER, "snmpagent_parameter" ) ){
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_PARAMETER, levelstring_map[parameter_get_char_value( PARAM_COMP_LOGGER, "snmpagent_parameter" )] ) );
	}else{
		snmpparam.loglevel.insert( std::pair<LOG_CATEGORY_TAG,LOG_LEVEL_TAG>( LOG_CAT_SNMPAGENT_PARAMETER, LOG_LV_INFO ) );
	}
}

